
<style>
  @media (min-width: 100px) and (max-width: 989px) {
    #rodape{
        width: 100vw !important;
    }
  }
   @media (min-width: 990px) and (max-width: 991px) {
    #rodape{
        width: 100vw !important;
    }
  }

  @media (min-width: 991px) and (max-width: 992px) {
    #rodape{
        width: calc(100vw - 4.6rem) !important;
    }
  }
  
  #rodape{
    position: fixed;
    bottom: 0;
    z-index: 1059;
    background-color: var(--color-secondary) !important;
    width: calc(100vw - 250px);
    padding: 0.3rem 1rem !important;
    font-size: 12px !important;
  }
  
  body.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    width: calc(100vw - 70px);
    z-index: 1;
  }

  body.sidebar-mini.layout-fixed.vsc-initialized.iframe-mode-fullscreen #rodape {
    z-index: 9999;
}


</style>


<div class="main-footer" id="rodape">
  <strong>Copyright &copy; 2024 <a target="_blank" href="https://sisplansistemas.com.br">Sisplan Sistemas</a>.</strong>
  Todos os direitos reservados.
  <div class="float-right d-none d-sm-inline-block">
    <b>Versão</b> 3.2410.21.2
  </div>
  <div class="float-right d-none d-sm-inline-block" style="margin-right: 7px">
    <b>
      <p id="conexaoInternaExterna" style="margin-bottom:0px ">| IP Interno  -</p>
    </b>
  </div>
  <div class="float-right d-none d-sm-inline-block" style="margin-right: 7px">
    <b>
      <p id="statusConexaoServidor" style="margin-bottom:0px " data-toggle="tooltip" data-placement="top" title="Excelente: Menos de 35 ms    /    Boa: 35-64 ms    /    Aceitável: 65-114 ms    /    Atenção: Acima de 115 ms">Verificando a conexão com o servidor...</p>
    </b>
  </div>
</div>

<script>
  $(function () {
    $('[data-toggle="tooltip"]').tooltip()
  })

  $(window).on('load', function() {
    if (window.top === window.self) { // Verifica se a janela atual é a principal
      let totalPings = 0;
      let pings = 0;
      let latenciaTotal = 0;
      const janelaLatencia = [];
      const maxJanelaTamanho = 3; // Quantidade de ping para tirar a média 
      
      async function pingServidor() {
        const url = '/sisplan/funcoes/v1/ping?';
        
        let inicioRequisicao = performance.now();
        try {
          const response = await requisicao('GET', url, '', null);

          if (response.ok) {
            let fimRequisicao = performance.now();
            let latencia = fimRequisicao - inicioRequisicao;

            janelaLatencia.push(latencia);
            if (janelaLatencia.length > maxJanelaTamanho) {
              janelaLatencia.shift();
            }

            latenciaTotal = janelaLatencia.reduce((a, b) => a + b, 0);
            pings++;
          } else if (response.status === 401) {
            console.warn('Não autorizado. Tentando revalidar o token...');
            const revalidado = await revalidaToken();
            if (revalidado) {
              await pingServidor();
            } else {
              console.error('Falha ao revalidar o token.');
            }
          }
    
        }finally {
          totalPings++;
          await atualizarStatus();
        }
      }

      async function atualizarStatus() {
        let latenciaMedia = (pings > 0 && janelaLatencia.length > 0) ? (latenciaTotal / janelaLatencia.length).toFixed(2) : 0;
        let perdaPacote = ((totalPings - pings) / totalPings * 100).toFixed(2);

        let statusText = `Latência média: <span class="latencia">${latenciaMedia}</span> ms `;
        const latenciaElem = $('<img class="latencia-emoji" alt="Latência Emoji" class="mx-1" style="width: 18px; margin:0px 0px 3px 6px">');

        $('#statusConexaoServidor').html(statusText).append(latenciaElem);

        const latenciaClassElem = $('#statusConexaoServidor .latencia');

        latenciaClassElem.removeClass('latenciaVerde latenciaAmarelo latenciaVermelho');
        if (latenciaMedia < 50) {
          latenciaClassElem.addClass('latenciaVerde');
          latenciaElem.attr('src', `${BASE_URI}/dist/img/latenciaBoa.svg`);
        } else if (latenciaMedia >= 50 && latenciaMedia <= 99) {
          latenciaClassElem.addClass('latenciaAmarelo');
          latenciaElem.attr('src', `${BASE_URI}/dist/img/latenciaMedia.svg`);
        } else {
          latenciaClassElem.addClass('latenciaVermelho');
          latenciaElem.attr('src', `${BASE_URI}/dist/img/latenciaBaixa.svg`);
        }

        latenciaElem.on('load', function() {
          this.width;
        });

        if (latenciaMedia > 100) {
          await rotinaGeraLog('LATENCIA', latenciaMedia, `DiaHora: (${new Date().toLocaleString()}), Ping: (${latenciaMedia}), Usuario: ${getCookie('cod_usuario')}-${getCookie('usuario')}, Empresa: ${getCookie('emp_id')} `, 'Latencia');
        }
      }

      setInterval(pingServidor, 60000); // Verificar a cada 1 minutos
      pingServidor();
    }
  })
</script>