$(document).ready(async function () {

    $('#txtNovoClienteDesdobra').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnNovoClienteDesdobra').pesquisa('#txtNovoClienteDesdobra', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "ENTIDADE","camposSelect": ["CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');

    $('#btnANovoClienteDesdobra').on('click', function () {
        $('#txtNovoClienteDesdobra').val('');
    });

    $('#modal-desdobra-pagar').on('shown.bs.modal', async function () {
        $.LoadingOverlay('show');
        try {
            $('#txtDataBaseDesdobra').val(formataData(new Date()));
            $('#txtDataVenctoDesdobra').val(formataData(new Date()));
            $('#txtDataEmissaoDesdobra').val(formataData(new Date()));
            $('#txtDataEntradaDesdobra').val(formataData(new Date()));
            $('#txtParcelasDesdobra').val('1');
            $('#txtIntervaloDesdobra').val('0');
            await carregaDadosPagar();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    adicionaMascaraCampos();

    function adicionaMascaraCampos() {
        $('.apenasFloat').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.apenasInteiros').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        });
    };

    async function carregaDadosPagar() {
        try {
            const numeros = $("#tabelaPagar").DataTable().rows(".selected").data().toArray().map(function (e) { return e.NUM_AP });

            let response = await requisicao('GET', '/Sisplan/desdobrapagar/V1/buscapagar?', `&NUMEROS=${numeros}`, null);

            if (!response) {
                return;
            }

            const dadosSel = await response.json();

            await criaTabelaSelecionadas(dadosSel.DADOS);

            if (dadosSel.SOMENTE_CONSULTA) {
                $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', true);
                // $('#btnGravarDesdobra').prop('disabled', true);
                $('#divDesdobradas').addClass('d-none');
                $('#textoVisualizacao').removeClass('d-none');
            } else {
                $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', false);
                // $('#btnGravarDesdobra').prop('disabled', false);
                $('#divDesdobradas').removeClass('d-none');
                $('#textoVisualizacao').addClass('d-none');
            }

            $('#btnGravarDesdobra').prop('disabled', true).attr('title', 'Gere a AP para depois gravar.');

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    }


    async function criaTabelaSelecionadas(info) {
        if ($.fn.DataTable.isDataTable('#tabelaAPSelDesdobra')) {
            $('#tabelaAPSelDesdobra').DataTable().destroy();
            $('#tabelaAPSelDesdobra').empty();
        }

        const cols = [{
            data: 'NUM_AP',
            title: 'Número AP'
        },
        {
            data: 'STATUS',
            title: 'Status'
        },
        {
            data: 'DOCTO',
            title: 'Docto'
        },
        {
            data: 'DT_EMI',
            title: 'Emissão'
        },
        {
            data: 'DT_VEN',
            title: 'Vencimento'
        },
        {
            data: 'SALDO',
            title: 'Valor'
        },
        {
            data: 'JUROS_CALC',
            title: 'Juros Calc.'
        },
        {
            data: 'VALOR_CALC',
            title: 'Valor Calc.'
        },
        {
            data: 'OBS',
            title: 'Obs'
        },
        {
            data: 'DT_ATUAL',
            title: 'Data Atual'
        }]

        $("#tabelaAPSelDesdobra").DataTable({
            order: [],
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            ordering: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [5, 6, 7],
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [3, 4, 9],
                },
                {
                    targets: '_all',
                    orderable: false
                }
            ],
        });

        $('#tabelaAPSelDesdobra thead').on('click', 'th', function (e) {
            e.stopPropagation();
        });

        $('#tabelaAPSelDesdobra').on('click', 'tr', async function () {
            $.LoadingOverlay('show');
            try {
                $('#tabelaAPSelDesdobra').DataTable().$('tr.selected').removeClass('selected');
                const data = $('#tabelaAPSelDesdobra').DataTable().row($(this)).data();
                $(this).addClass('selected');
                await buscaAssociadas(data);
            } finally {
                $.LoadingOverlay('hide');
            }
        });

        $('#labelTotalValor').html(parseFloat($('#tabelaAPSelDesdobra').DataTable().data().toArray().reduce((e, o) => {
            return e + o.SALDO;
        }, 0)).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('#labelTotalSoma').html(parseFloat(0).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        }));

        $('#labelTotalSaldo').html(parseFloat(0).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        }));

        if ($('#tabelaAPSelDesdobra').DataTable().data().length > 0) {
            $($('#tabelaAPSelDesdobra tr')[1]).trigger('click');
        }

    }

    async function buscaAssociadas(data) {
        try {
            let response = await requisicao('GET', '/Sisplan/desdobrapagar/V1/buscaassociadas?', `&NUMERO=${data.NUM_AP}&STATUS=${data.STATUS}`, null);

            if (!response) {
                return;
            }

            const dadosAss = await response.json();

            if (dadosAss.length > 0) {
                criaTabelaAssociadas(dadosAss);
                $('#divSel').addClass('col-7');
                $('#divSel').removeClass('col-12');
                $('#divAss').removeClass('d-none');
                $('#tituloAss').removeClass('d-none');
            } else {
                $('#divSel').removeClass('col-7');
                $('#divSel').addClass('col-12');
                $('#divAss').addClass('d-none');
                $('#tituloAss').addClass('d-none');
            }
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados, favor recarregar a página: ${e}`);
        }
    }

    function criaTabelaAssociadas(info) {
        if ($.fn.DataTable.isDataTable('#tabelaAPAssDesdobra')) {
            $('#tabelaAPAssDesdobra').DataTable().destroy();
            $('#tabelaAPAssDesdobra').empty();
        }
        const cols = [
            {
                data: 'NUM_AP',
                title: 'Número AP'
            },
            {
                data: 'STATUS',
                title: 'Status'
            },
            {
                data: 'DT_EMI',
                title: 'Emissão'
            },
            {
                data: 'DT_VEN',
                title: 'Vencimento'
            },
            {
                data: 'SALDO',
                title: 'Saldo'
            }];

        $("#tabelaAPAssDesdobra").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [4],
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [2, 3],
                },
            ],
        });
    }

    $('#btnProcessarDesdobra').on('click', function () {
        $.LoadingOverlay('show');
        try {

            const dataBase = $('#txtDataBaseDesdobra').val();
            const taxaJuros = $('#txtTaxaJurosDesdobra').val();

            if (dataBase == '') {
                msgErro('Data base não informada. Impossível continuar.');
                return;
            }

            if (taxaJuros == '') {
                msgErro('Taxa de juros não informada. Impossível continuar.');
                return;
            }

            processaJuros(dataBase, taxaJuros);

            $('#labelTotalValor').html(parseFloat($('#tabelaAPSelDesdobra').DataTable().data().toArray().reduce((e, o) => {
                return e + o.VALOR_CALC;
            }, 0)).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    function processaJuros(data, juros) {
        try {
            const dados = $('#tabelaAPSelDesdobra').DataTable().data().toArray();

            dados.map(function (e) {
                if (e.DT_VEN < data) {
                    let dias = daysBetween(new Date(e.DT_VEN), new Date(data));
                    let taxa = dias / 30;
                    taxa = taxa * juros;
                    let valorJuros = (e.SALDO * taxa) / 100;

                    e.JUROS_CALC = valorJuros;
                    e.VALOR_CALC = parseFloat(parseFloat(e.SALDO + valorJuros).toFixed(2));
                }
            });

            criaTabelaSelecionadas(dados);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível processar os dados: ${e}`);
        }
    }

    function retornaFiltros() {
        const retorno = {};

        retorno.PARCELAS = formataInt($('#txtParcelasDesdobra').val());
        retorno.INTERVALO = formataInt($('#txtIntervaloDesdobra').val());
        retorno.PRIMEIRO_VENCIMENTO = $('#txtDataVenctoDesdobra').val() == '' ? formataData(new Date()) : $('#txtDataVenctoDesdobra').val();
        retorno.VENCTO_MESMO_DIA = $('#cbVenctoDiaDesdobra').prop('checked');
        retorno.EMISSAO = $('#txtDataEmissaoDesdobra').val() == '' ? formataData(new Date()) : $('#txtDataEmissaoDesdobra').val();
        retorno.ENTRADA = $('#txtDataEntradaDesdobra').val() == '' ? formataData(new Date()) : $('#txtDataEntradaDesdobra').val();
        retorno.TIPO_OBS = $('[name="rdTipoObs"]:checked').val();

        return retorno;
    }

    $('#btnGerarDesdobra').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaAPSelDesdobra').DataTable().data().toArray();

            let valida = undefined;

            const status = data[0].STATUS;

            valida = data.find(e => status != e.STATUS);

            if (valida != undefined) {
                msgErro('O status precisa ser o mesmo para todas as APs. Impossível continuar.');
                return;
            }

            await desdobraAPs();

            if (data.length !== 0) {
                $('#btnGravarDesdobra').prop('disabled', false).removeAttr('title');
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function formataInt(v) {
        let result;
        if (v == '') {
            return 0;
        }

        try {
            result = parseInt(v);

            if (result == 'NaN') {
                result = 0;
            }
        } catch (e) {
            result = 0;
        }

        return result;
    }
    function formataFloat(v) {
        let result;
        if (v == '') {
            return 0;
        }

        try {
            result = parseFloat(parseFloat(v).toFixed(2));

            if (result == 'NaN') {
                result = 0;
            }
        } catch (e) {
            result = 0;
        }

        return result;
    }

    async function desdobraAPs() {
        try {
            const dadosSel = $('#tabelaAPSelDesdobra').DataTable().row($('tr.selected')).data();
            if (dadosSel == undefined) {
                msgErro('É necessário selecionar uma duplicata para desdobrar.');
                return;
            }

            let numeros = [dadosSel.NUMERO];

            $("#tabelaAPSelDesdobra").DataTable().data().toArray().map(function (e) { if (e.NUMERO != dadosSel.NUMERO) { numeros.push(e.NUMERO) } });
            const maxDocto = $("#tabelaAPSelDesdobra").DataTable().data().toArray().reduce(function (max, row) {
                return row.DOCTO > max ? row.DOCTO : max;
            }, '00000');
            const filtros = retornaFiltros();
            const valor = $('#labelTotalValor').html();

            let primeiroRegistro = $('#tabelaAPSelDesdobra').DataTable().row($('tr.selected')).data();

            const duplicatasOriginais = [primeiroRegistro];

            $('#tabelaAPSelDesdobra').DataTable().data().toArray().map(function (e) { if (e.NUM_AP != primeiroRegistro) { duplicatasOriginais.push(e) } });

            const originais = { DUPLICATAS: duplicatasOriginais }

            let response = await requisicao("GET", `/Sisplan/desdobrapagar/V1/desdobraaps?`,
                `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&MAIOR_DOCTO=${maxDocto}&EMP_ID=${getCookie('emp_id')}&VALOR=${valor}&ORIGINAIS=${encodeURIComponent(JSON.stringify(originais))}`);

            let json = await response.json();

            await criaTabelaDesdobradas(json);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function criaTabelaDesdobradas(info) {

        function carregaInput(valor, indices) {
            try {

                switch (indices.col) {
                    case 0: {
                        return `<input disabled type="text" id="txtNumAPDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 15ch;" value="${valor}">`;
                    }
                    case 1: {
                        return `<input type="date" id="txtVenctoDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 2: {
                        return `<input type="text" id="txtValorDesdobra_${indices.row}"
                                class="input-default focus form-control text-right apenasFloat inputValorTabela"
                                style="width: 15ch" value="${valor}">`;
                    }
                    case 3: {
                        const value = valor != '' ? insereValor(`#txtBancoDesdobra_${indices.row}`, valor, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: valor }) : '';

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeBancoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtBancoDesdobra_${indices.row}" name="txtBancoDesdobra_${indices.row}" placeholder="Banco">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnBancoDesdobra_${indices.row}" name="btnBancoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaBancoDesdobra_${indices.row}" name="btnLimpaBancoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 4: {
                        const value = valor != '' ? insereValor(`#txtClasseDesdobra_${indices.row}`, valor, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }) : '';
                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeClasseDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtClasseDesdobra_${indices.row}" name="txtClasseDesdobra_${indices.row}" placeholder="Classe">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClasseDesdobra_${indices.row}" name="btnClasseDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClasseDesdobra_${indices.row}" name="btnLimpaClasseDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 5: {
                        const value = valor != '' ? insereValor(`#txtHistoricoDesdobra_${indices.row}`, valor, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: valor }) : '';
                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeHistoricoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtHistoricoDesdobra_${indices.row}" name="txtHistoricoDesdobra_${indices.row}" placeholder="Histórico">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnHistoricoDesdobra_${indices.row}" name="btnHistoricoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaHistoricoDesdobra_${indices.row}" name="btnLimpaHistoricoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 6: {
                        const value = valor != '' ? insereValor(`#txtSituacaoDesdobra_${indices.row}`, valor, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }) : '';
                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeSituacaoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtSituacaoDesdobra_${indices.row}" name="txtSituacaoDesdobra_${indices.row}" placeholder="Situação">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnSituacaoDesdobra_${indices.row}" name="btnSituacaoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaSituacaoDesdobra_${indices.row}" name="btnLimpaSituacaoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 7: {
                        return `<input disabled type="text" id="txtDupliDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 15ch;" value="${valor}">`;
                    }
                    case 8: {
                        return `<input type="date" id="txtCompetenciaDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 9: {
                        return `<input type="date" id="txtEmissaoDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 10: {
                        return `<input type="date" id="txtEntradaDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 11: {
                        return `<input type="text" id="txtObservacaoDesdobra_${indices.row}"
                                class="input-default focus form-control tamanhoDinamico"
                                style="min-width: 30ch; max-width: 50ch" value="${valor}">`;
                    }
                    case 12: {
                        return `<input type="text" id="txtDoctoDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 20ch" value="${valor}">`;
                    }
                    default:
                        break;
                }
            } catch (e) {
                msgErro(`Não foi possível carregar os dados: ${e}`);
                console.log(e);
            }
        }

        if ($.fn.DataTable.isDataTable('#tabelaAPGeradasDesdobra')) {
            $('#tabelaAPGeradasDesdobra').DataTable().destroy();
            $('#tabelaAPGeradasDesdobra').empty();
        }

        const cols = [{
            data: 'NUM_AP',
            title: 'Número AP'
        },
        {
            data: 'DT_VEN',
            title: 'Vencimento'
        },
        {
            data: 'VALOR',
            title: 'Valor'
        },
        {
            data: 'BANCO',
            title: 'Banco'
        },
        {
            data: 'CLASSE',
            title: 'Classe'
        },
        {
            data: 'HISTORICO',
            title: 'Histórico'
        },
        {
            data: 'SITUACAO',
            title: 'Situação'
        },
        {
            data: 'DUPLI',
            title: 'Dupli'
        },
        {
            data: 'COMPETENCIA',
            title: 'Competência'
        },
        {
            data: 'DT_EMISSAO',
            title: 'Emissão'
        },
        {
            data: 'DT_ENTRADA',
            title: 'Entrada'
        },
        {
            data: 'OBSERVACAO',
            title: 'Observação'
        },
        {
            data: 'DOCTO',
            title: 'Documento'
        }]

        $("#tabelaAPGeradasDesdobra").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: '_all',
                    render: function (data, v2, v3, index) {
                        return carregaInput(data, index);
                    }
                },
            ],
        });

        $('.tamanhoDinamico').on('input', function () {
            this.style.width = this.value.length + "ch";
        });

        $('.tamanhoDinamico').trigger('input');

        adicionaPesquisasInputs();

        $('#labelTotalSoma').html(parseFloat($('#tabelaAPGeradasDesdobra').DataTable().data().toArray().reduce((e, o) => {
            return e + o.VALOR;
        }, 0)).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('#labelTotalSaldo').html((parseFloat($('#labelTotalValor').html().replaceAll('.', '').replaceAll(',', '.')) - (parseFloat($('#labelTotalSoma').html().replaceAll('.', '').replaceAll(',', '.')))).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('.inputValorTabela').on('blur', function () {
            $('#labelTotalSoma').html(parseFloat($('#tabelaAPGeradasDesdobra').DataTable().data().toArray().reduce((e, o, i) => {
                return e + parseFloat($(`#txtValorDesdobra_${i}`).val());
            }, 0)).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );

            $('#labelTotalSaldo').html((parseFloat($('#labelTotalValor').html().replaceAll('.', '').replaceAll(',', '.')) - (parseFloat($('#labelTotalSoma').html().replaceAll('.', '').replaceAll(',', '.')))).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );
        })
        adicionaMascaraCampos();

        const pesquisaParam = {
            tabela: 'PAGTO',
            camposSelect: [
                'PAGTO.SITUACAO', 'TABSIT.DESCRICAO DESC_SIT', 'PAGTO.HISTORICO', 'HISTCP.DESCRICAO DESC_HIST', 
                'PAGTO.BANCO', 'CADBAN.NOME_BANCO', 'PAGTO.NUM_OS CLASSE', 'CLASSE_GER.DESCRICAO DESC_CLASSE'
            ],
            leftJoin: [
                { tabela: 'TABSIT', condicao: 'TABSIT.CODIGO = PAGTO.SITUACAO' },
                { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = PAGTO.HISTORICO' },
                { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = PAGTO.BANCO' },
                { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PAGTO.NUM_OS' }
            ],
            where: [`PAGTO.NUM_AP = '${$('#tabelaAPSelDesdobra').DataTable().rows('.selected').data()[0].NUM_AP}'`],
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        insereValor('.classeBancoDesdobra', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO)
        insereValor('.classeClasseDesdobra', jsonStr[0].CLASSE, jsonStr[0].DESC_CLASSE)
        insereValor('.classeHistoricoDesdobra', jsonStr[0].HISTORICO, jsonStr[0].DESC_HIST)
        insereValor('.classeSituacaoDesdobra', jsonStr[0].SITUACAO, jsonStr[0].DESC_SIT)
    }

    $('#cbGeraSeqDesdobra').on('change', function () {
        if ($('#cbGeraSeqDesdobra').prop('checked')) {
            $('#cbNumeroDupliDesdobra').prop('disabled', true);
            $('#cbNumeroDupliDesdobra').prop('checked', false);
        } else {
            $('#cbNumeroDupliDesdobra').prop('disabled', false);
        }
    })

    function adicionaPesquisasInputs() {
        try {
            // { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }
            // { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: valor }
            // { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }
            // { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: valor }

            $('.classeBancoDesdobra').map(function (e, i) {
                $(`#txtBancoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
                $(`#btnBancoDesdobra_${e}`).pesquisa(`#txtBancoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADBAN","camposSelect": ["CADBAN.BANCO CODIGO", "CADBAN.NOME_BANCO DESCRICAO"]}`, 'Pesquisa Banco', 'CADBAN');
                $(`#btnLimpaBancoDesdobra_${e}`).on('click', function () {
                    $(`#txtBancoDesdobra_${e}`).val('');
                });

                $(`#txtClasseDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnClasseDesdobra_${e}`).pesquisa(`#txtClasseDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CLASSE_GER","camposSelect": ["CLASSE_GER.CODIGO CODIGO", "CLASSE_GER.DESCRICAO DESCRICAO"]}`, 'Pesquisa Classe', 'CLASSE_GER');
                $(`#btnLimpaClasseDesdobra_${e}`).on('click', function () {
                    $(`#txtClasseDesdobra_${e}`).val('');
                });

                $(`#txtHistoricoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnHistoricoDesdobra_${e}`).pesquisa(`#txtHistoricoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "HISTCP", "camposSelect": ["HISTCP.HISTORICO CODIGO", "HISTCP.DESCRICAO DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP');
                $(`#btnLimpaHistoricoDesdobra_${e}`).on('click', function () {
                    $(`#txtHistoricoDesdobra_${e}`).val('');
                });

                $(`#txtSituacaoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnSituacaoDesdobra_${e}`).pesquisa(`#txtSituacaoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABSIT", "camposSelect": ["TABSIT.CODIGO CODIGO", "TABSIT.DESCRICAO DESCRICAO"]}`, 'Pesquisa Situação', 'TABSIT');
                $(`#btnLimpaSituacaoDesdobra_${e}`).on('click', function () {
                    $(`#txtSituacaoDesdobra_${e}`).val('');
                });
            });
        } catch (e) {
            console.log(e);
        }
    }

    let deletarRateio;

    $('#btnGravarDesdobra').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => {
                let numeros = '';
                $('#tabelaAPSelDesdobra').DataTable().data().toArray().map(function (e) {
                    if (numeros == '') {
                        numeros = `'${e.NUM_AP}'`
                    } else {
                        numeros += ',' + `'${e.NUM_AP}'`
                    }
                });

                let response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela":"CENTRO_RATEIO", "camposSelect":["NUMERO"], "where": ["NUMERO IN (${numeros})", "TIPO = 'CP'", "EMP_ID = ${getCookie('emp_id')}"]}`, null);

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }

                if (jsonStr.RESULT[0].length > 0) {
                    msgAlerta("Existem APs com rateio. Deseja excluir o rateio e continuar?", () => { }, () => { }, async () => {
                        deletarRateio = true;
                        $.LoadingOverlay('show');
                        await gravaDados();
                        $.LoadingOverlay('hide');
                    });
                } else {
                    deletarRateio = false;
                    $.LoadingOverlay('show');
                    await gravaDados();
                    $.LoadingOverlay('hide');
                }
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function retornaAPsDesdobradas() {
        const retorno = [];

        $('#tabelaAPGeradasDesdobra').DataTable().data().toArray().map(function (e, i) {
            retorno.push({
                NUM_AP: $(`#txtNumAPDesdobra_${i}`).val(),
                DT_VEN: $(`#txtVenctoDesdobra_${i}`).val(),
                VALOR: $(`#txtValorDesdobra_${i}`).val(),
                BANCO: pegaChave(`#txtBancoDesdobra_${i}`),
                CLASSE: pegaChave(`#txtClasseDesdobra_${i}`),
                HISTORICO: pegaChave(`#txtHistoricoDesdobra_${i}`),
                SITUACAO: pegaChave(`#txtSituacaoDesdobra_${i}`),
                DUPLI: $(`#txtDupliDesdobra_${i}`).val(),
                COMPETENCIA: $(`#txtCompetenciaDesdobra_${i}`).val(),
                OBSERVACAO: $(`#txtObservacaoDesdobra_${i}`).val(),
                DT_EMISSAO: $(`#txtEmissaoDesdobra_${i}`).val(),
                DT_ENTRADA: $(`#txtEntradaDesdobra_${i}`).val(),
                DOCTO: $(`#txtDoctoDesdobra_${i}`).val()
            })
        });

        return retorno;
    }

    async function gravaDados() {
        try {
            let primeiroRegistro = $('#tabelaAPSelDesdobra').DataTable().row($('tr.selected')).data();

            const duplicatasOriginais = [primeiroRegistro];

            $('#tabelaAPSelDesdobra').DataTable().data().toArray().map(function (e) { if (e.NUMERO != primeiroRegistro) { duplicatasOriginais.push(e) } });

            const filtros = retornaFiltros();
            const originais = { DUPLICATAS: duplicatasOriginais }
            const desdobradas = { DUPLICATAS: retornaAPsDesdobradas() }
            const valor = $('#labelTotalValor').html();
            const soma = $('#labelTotalSoma').html();

            let response = await requisicao("POST", `/Sisplan/desdobrapagar/V1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&ORIGINAIS=${encodeURIComponent(JSON.stringify(originais))}&DESDOBRADAS=${encodeURIComponent(JSON.stringify(desdobradas))}&VALOR=${valor}&SOMA=${soma}&DELETAR_RATEIO=${deletarRateio}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                let json = await response.json();
                msgErro(json.mensagem);
                return;
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                    if (deletarRateio) {
                        msgAlerta('Deseja lançar o rateio para a(s) nova(s) AP(s)?', () => { }, () => { $('#modal-desdobra-pagar').modal('hide') }, async () => { await lancaRateioAPsDesdobradas() })
                    } else {
                        $('#modal-desdobra-pagar').modal('hide');
                    }
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });


        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        }
    }

    $('#txtIntervaloDesdobra').on('blur', function () {
        if ($(this).val() == '30') {
            $('#cbVenctoDiaDesdobra').prop('checked', true);
        }
    })

    $('#modal-desdobra-pagar').on('hide.bs.modal', async function () {
        $.LoadingOverlay('show');
        try {
            if ($.fn.DataTable.isDataTable('#tabelaAPSelDesdobra')) {
                $('#tabelaAPSelDesdobra').DataTable().destroy();
                $('#tabelaAPSelDesdobra').empty();
            }
            if ($.fn.DataTable.isDataTable('#tabelaAPGeradasDesdobra')) {
                $('#tabelaAPGeradasDesdobra').DataTable().destroy();
                $('#tabelaAPGeradasDesdobra').empty();
            }

            $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', false);
            $('#btnGravarDesdobra').prop('disabled', false);

            $('#divDesdobradas div input').val('');
            $('#txtMetodoDesdobra').val('JS');
            $('#divDesdobradas div input[type="checkbox"]').prop('checked', false);

            $('#divSelecionadas div input').val('');
            $('.labelTotais').html('');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnCancelarDesdobra').on('click', function () {
        $('#modal-desdobra-pagar').modal('hide');
    });

    async function lancaRateioAPsDesdobradas() {
        try {
            const data = retornaAPsDesdobradas();

            for (let i = 0; i < data.length; i++) {
                const e = data[i];
                await abreModalLancaRateioDesdobradas(e);
            }
        } finally {
            $('#modal-desdobra-pagar').modal('hide');
        }
    }

    async function abreModalLancaRateioDesdobradas(data) {
        return await new Promise(async (resolve) => {
            $('#txtNumeroRateio').val(data.NUM_AP)
            $('#txtClasseRateio').val(data.CLASSE)
            $('#txtTipoRateio').val('CP')
            $('#txtValorRateio').val(parseFloat(data.VALOR).toFixed(2))
            $('#txtDataRateio').val(formataData(new Date()))
            $('#txtNumeroAnt').val(data.NUM_AP)
            $('#txtDataVencto').val(data.DT_VEN)
            $('#txtDuplicata').val('')
            $('#txtNumeroOC').val('')
            $('#txtCentroCustoFixo').val('')
            $('#txtEmpId').val(getCookie('emp_id'))
            $('#modalLancRateio').modal('show');

            $('#modalLancRateio').on('fechaRateioDesagrupaPagar', function () {
                resolve();
            })

        })
    }

});