$(document).ready(async function () {

    let tipoValor;

    $('#btnCodigoRateio').pesquisa_serverside(
        [`#txtCodigoRateio`],
        ['CODIGO'],
        ['DESCRICAO'],
        '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Classe Gerencial',
        async () => { await buscaDadosRateio(pegaChave('#txtCodigoRateio'), $('#txtTipoRateio').val(), tipoValor); });

    $('#txtCodigoRateio').autocompleta(1,
        `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`,
        null,
        null,
        null,
        async () => { setTimeout(async function () { await buscaDadosRateio(pegaChave('#txtCodigoRateio'), $('#txtTipoRateio').val(), tipoValor); }, 500) });

    $('#btnLimpaCodigoRateio').on('click', function () {
        $('#txtCodigoRateio').val('');
        if ($.fn.DataTable.isDataTable('#tabelaContas')) {
            $('#tabelaContas').DataTable().destroy();
            $('#tabelaContas').empty();
        };
        if ($.fn.DataTable.isDataTable('#tabelaCentroCusto')) {
            $('#tabelaCentroCusto').DataTable().destroy();
            $('#tabelaCentroCusto').empty();
        };
    });

    $('#modal-rateio').on('shown.bs.modal', async function () {
        $.LoadingOverlay('show');
        const tipo = $('#txtTipoRateio').val();
        const codigoRateio = $('#txtCodigoRateio').val();
        if (codigoRateio != '') {
            switch (tipo) {
                case '':
                    break;
                case 'M':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'MATERIAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'VF';
                    break;
                case 'P':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'PRODUTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'VF';
                    break;
                case 'S':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'SERVICO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'VF';
                    break;
                case 'C':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'VF';
                    break;
                case 'GM':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'GRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'VF';
                    break;
                case 'N':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'NAT_CONTA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'NAT_CONTA';
                    break;
                case 'CT':
                    insereValor('#txtCodigoRateio', codigoRateio, { tabela: 'CONTA_CONT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: codigoRateio });
                    tipoValor = 'CONTA_CONT';
                    break;
                default:
                    break;
            };
        }

        await buscaDadosRateio(codigoRateio, tipo, tipoValor);
        $.LoadingOverlay('hide');
    });

    async function buscaDadosRateio(codigo, tipo, tipoVal) {
        try {
            const response = await requisicao('GET', '/sisplan/rateiocontabil/v1/buscadados?&', `CODIGO=${codigo}&TIPO=${tipo}&TIPO_VAL=${tipoVal}`, 600000);
            if (!response) {
                return;
            }

            const data = await response.json();
            if (response.status != 200) {
                msgErro(data.mensagem);
                return;
            }

            await adicionaDadosConta(data[0].ARRAY_CONTAS);
            await adicionaDadosCentroCusto(data[0].ARRAY_CENTROSCUSTO);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    };

    async function adicionaDadosConta(data) {

        try {

            function retornaInputConta(row, data) {
                let info = data.CONTA != '' ? '[' + data.CONTA + '] - ' + data.DESCRICAO : '';

                return `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate"
                            id="txtContaContaRateio_${row}" name="txtContaContaRateio_${row}" value="${info}" required placeholder="Conta">
                        <div class="input-group-append">
                            <button class="btn bg-danger" id="btnContaContaRateio_${row}" name="btnContaContaRateio_${row}"
                                data-button="absolute" type="button"><i
                                    class="m-0 p-0 fas fa-search"></i></button>
                        </div>
                    </div>`;
            };

            function retornaInputPercConta(row, data) {
                return `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate maskDecimais"
                            id="txtPercContaRateio_${row}" name="txtPercContaRateio_${row}" value="${data.PERC}" required placeholder="0,00">
                    </div>`;
            };

            function retornaBotaoSel(meta, data) {
                let marcado = '';
                if (data.SEL == 'S') {
                    marcado = 'checked';
                }

                return `<div class="icheck-primary" style="max-width: 20px">
                      <input type="checkbox" ${marcado} id="checkConta_row_${meta.row}" class="campoSelConta">
                      <label for="checkConta_row_${meta.row}"></label>
                    </div>`
            };

            if ($.fn.DataTable.isDataTable('#tabelaContas')) {
                $('#tabelaContas').DataTable().destroy();
                $('#tabelaContas').empty();
            }

            if (data.length == 1) {
                if (data[0].CONTA == '0') {
                    data[0].DESCRICAO = 'NÃO UTILIZA CONTA';
                }
            }

            const cols = [
                {
                    data: 'SEL',
                    title: `<div class="form-group icheck-primary m-0 p-0 d-flex align-items-center" id="containerSelTodosConta">
                            <input type="checkbox" class="input-default focus form-control validate" id="cbSelecionarTodosConta" name="cbSelecionarTodosConta">
                            <label for="cbSelecionarTodosConta" style="width: 45px">Sel</label>
                        </div>`,
                    width: '5%'
                },
                {
                    data: 'CONTA',
                    title: 'Conta',
                    width: '85%'
                },
                {
                    data: 'PERC',
                    title: 'Percentual',
                    width: '10%'
                }];

            $("#tabelaContas").DataTable({
                order: false,
                sort: true,
                paging: false,
                destroy: true,
                lengthChange: false,
                searching: false,
                info: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: data,
                columns: cols,
                columnDefs: [
                    {
                        targets: [0],
                        render: function (row, type, data, meta) {
                            return retornaBotaoSel(meta, data);
                        }
                    },
                    {
                        targets: [1],
                        render: function (row, type, data, meta) {
                            return retornaInputConta(meta.row, data);
                        }
                    },
                    {
                        targets: [2],
                        render: function (row, type, data, meta) {
                            return retornaInputPercConta(meta.row, data);
                        }
                    }
                ],
                rowCallback: async function (row, data) {

                    function atualizaValoresPesquisa() {
                        const data = $('#tabelaContas').DataTable().row(row._DT_RowIndex).data();
                        const novaConta = pegaChave(`#txtContaContaRateio_${row._DT_RowIndex}`);

                        const dataEx = $('#tabelaContas').DataTable().data().toArray();
                        const findIndex = [];
                        dataEx.forEach((e, i) => { if (e.CONTA == novaConta && i != row._DT_RowIndex) { findIndex.push(i) } });

                        if (findIndex.length > 0) {
                            msgErro(`Conta já informada, impossível continuar.`, () => { $(`#txtContaContaRateio_${row._DT_RowIndex}`).focus(); }, () => { $(`#txtContaContaRateio_${row._DT_RowIndex}`).focus(); });
                            if (data.CONTA != '') {
                                insereValor(`#txtContaContaRateio_${row._DT_RowIndex}`, data.CONTA, data.DESCRICAO);
                            } else {
                                $(`#txtContaContaRateio_${row._DT_RowIndex}`).val('');
                            }
                            return;
                        }

                        const contaAntiga = data.CONTA;
                        data.CONTA = novaConta;
                        data.DESCRICAO = pegaDescricao(`#txtContaContaRateio_${row._DT_RowIndex}`);
                        data.PERC = $(`#txtPercContaRateio_${row._DT_RowIndex}`).val();

                        $('#tabelaContas').DataTable().row(row._DT_RowIndex).data(data).draw(false);

                        const novosDadosCC = [];

                        $('#tabelaCentroCusto').DataTable().column(1).search(``, true, false).draw(false);

                        $('#tabelaCentroCusto').DataTable().rows().every(function () {
                            const data2 = this.data();
                            const index2 = this.index();

                            if (data2.CONTA == contaAntiga) {
                                data2.CONTA = data.CONTA;
                            };

                            novosDadosCC.push({
                                SEL: data2.SEL,
                                CONTA: data2.CONTA,
                                CODIGO: data2.CODIGO,
                                DESCRICAO: data2.DESCRICAO,
                                PERC: $(`#txtPercCentroCustoRateio_${index2}`).val()
                            });
                        });

                        adicionaDadosCentroCusto(novosDadosCC, row._DT_RowIndex);
                        filtraTabela();
                    }

                    $(`#checkConta_row_${row._DT_RowIndex}`).off('change');

                    $(`#checkConta_row_${row._DT_RowIndex}`).on('change', function () {
                        let d = $('#tabelaContas').DataTable().row(row._DT_RowIndex).data();

                        if ($(this).prop('checked')) {
                            d.SEL = 'S';
                        } else {
                            d.SEL = 'N';
                        }

                        $('#tabelaContas').DataTable().row(row._DT_RowIndex).data(d).draw(false);
                    });

                    $(`#txtContaContaRateio_${row._DT_RowIndex}`).off('focusout');
                    $(`#txtContaContaRateio_${row._DT_RowIndex}`).on('focusout', async function () {
                        const data = $('#tabelaContas').DataTable().row(row._DT_RowIndex).data();
                        if ($(this).val() == '' && data.CONTA != '') {
                            insereValor(`#txtContaContaRateio_${row._DT_RowIndex}`, data.CONTA, data.DESCRICAO);
                        } else if ($(this).val() == '0') {
                            data.CONTA = '0';
                            data.DESCRICAO = 'NÃO UTILIZA CONTA';
                            data.PERC = 100;
                            adicionaDadosConta([data]);
                            $('#tabelaCentroCusto').DataTable().rows().remove().draw(false);
                            $($('#tabelaContas tbody tr')[0]).trigger('click');
                        }
                    });

                    $(`#txtContaContaRateio_${row._DT_RowIndex}`).on('input', async function () {
                        const data = $('#tabelaContas').DataTable().row(row._DT_RowIndex).data();
                        if ($(this).val() != '') {
                            if (($(this).val() != '0') && ($(this).val() != `[${data.CONTA}] - ${data.DESCRICAO}`)) {
                                $(`#txtContaContaRateio_${row._DT_RowIndex}`).focus();
                                if (data.CONTA != '') {
                                    insereValor(`#txtContaContaRateio_${row._DT_RowIndex}`, data.CONTA, data.DESCRICAO);
                                } else {
                                    $(this).val('');
                                }
                                return;
                            }
                        }
                    });

                    $(`#btnContaContaRateio_${row._DT_RowIndex}`).pesquisa_serverside(
                        [`#txtContaContaRateio_${row._DT_RowIndex}`],
                        ['CODIGO'],
                        ['DESCRICAO'],
                        '{"tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}',
                        'Pesquisa de Conta',
                        atualizaValoresPesquisa);
                },
            }).draw(false);

            $('#cbSelecionarTodosConta').on('change', function () {
                if ($('#cbSelecionarTodosConta').prop('checked')) {
                    $('.campoSelConta').prop('checked', true);
                } else {
                    $('.campoSelConta').prop('checked', false);
                }
                $('.campoSelConta').trigger('change');
            });

            $('#tabelaContas thead th').each(function () {
                $(this)[0].style.verticalAlign = 'top';
            });

            if ($('#tabelaContas').DataTable().data().length > 0) {
                $($('#tabelaContas thead tr th')[0]).css('width', '50px');
                $('#tabelaContas thead tr th label').css('width', '30px');
            }

            $('#tabelaContas tbody').unbind('click');
            $('#tabelaContas tbody').on('click', 'tr', function () {
                if ($('#tabelaContas').DataTable().data().length > 0) {
                    $('#tabelaContas').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                    filtraTabela();
                }
            });

            adicionaMascaraCampos();
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    };

    $('#btnExcluirConta').on('click', function () {
        const valida = $('#tabelaContas').DataTable().rows(function (idx, data, node) {
            return data.SEL == 'S';
        }).data();

        if (valida.length == 0) {
            msgErro('Nenhum registro selecionado, favor verificar.');
            return;
        }

        msgAlerta('Deseja excluir os registros selecionados?', () => { }, () => { }, () => { excluiContaRateio() }, () => { });
    });

    function excluiContaRateio() {
        try {
            const novosDados = [];
            const novosDadosCC = [];

            $('#tabelaContas').DataTable().rows().every(function () {
                const data = this.data();
                const index = this.index();

                if (data.SEL != 'S') {
                    novosDados.push({
                        SEL: data.SEL,
                        CONTA: data.CONTA,
                        DESCRICAO: data.DESCRICAO,
                        PERC: $(`#txtPercContaRateio_${index}`).val()
                    });

                    $('#tabelaCentroCusto').DataTable().column(1).search(``, true, false).draw(false);

                    $('#tabelaCentroCusto').DataTable().rows().every(function () {
                        const data2 = this.data();
                        const index2 = this.index();

                        if (data2.CONTA == data.CONTA) {
                            novosDadosCC.push({
                                SEL: data2.SEL,
                                CONTA: data2.CONTA,
                                CODIGO: data2.CODIGO,
                                DESCRICAO: data2.DESCRICAO,
                                PERC: $(`#txtPercCentroCustoRateio_${index2}`).val()
                            });
                        };
                    });

                };
            });

            adicionaDadosConta(novosDados);
            adicionaDadosCentroCusto(novosDadosCC, 0);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível realizar a exclusão: ${e}`);
        }
    }

    async function adicionaDadosCentroCusto(data, indice = 0) {
        try {

            function retornaInputCentroCusto(row, data) {
                let info = data.CODIGO != '' ? '[' + data.CODIGO + '] - ' + data.DESCRICAO : '';

                return `<div class="input-group col-12 mx-0 px-0">
                            <input type="text" class="input-default focus form-control validate"
                                id="txtCentroCustoRateio_${row}" name="txtCentroCustoRateio_${row}" value="${info}" required placeholder="Centro de custo">
                            <div class="input-group-append">
                                <button class="btn bg-danger" id="btnCentroCustoRateio_${row}" name="btnCentroCustoRateio_${row}"
                                    data-button="absolute" type="button"><i
                                        class="m-0 p-0 fas fa-search"></i></button>
                            </div>
                        </div>`;
            };

            function retornaInputPercCentroCusto(row, data) {
                return `<div class="input-group col-12 mx-0 px-0">
                            <input type="text" class="input-default focus form-control validate maskDecimais"
                                id="txtPercCentroCustoRateio_${row}" name="txtPercCentroCustoRateio_${row}" value="${data.PERC}" required placeholder="0,00">
                        </div>`;
            };

            function retornaBotaoSel(meta, data) {
                let marcado = '';
                if (data.SEL == 'S') {
                    marcado = 'checked';
                }

                return `<div class="icheck-primary" style="max-width: 20px">
                      <input type="checkbox" ${marcado} id="checkCentroCusto_row_${meta.row}" class="campoSelCentroCusto">
                      <label for="checkCentroCusto_row_${meta.row}"></label>
                    </div>`

            };
            if ($.fn.DataTable.isDataTable('#tabelaCentroCusto')) {
                $('#tabelaCentroCusto').DataTable().destroy();
                $('#tabelaCentroCusto').empty();
            }

            const cols = [
                {
                    data: 'SEL',
                    title: `<div class="form-group icheck-primary m-0 p-0 d-flex align-items-center" id="containerSelTodosCentroCusto">
                            <input type="checkbox" class="input-default focus form-control validate" id="cbSelecionarTodosCentroCusto" name="cbSelecionarTodosCentroCusto">
                            <label for="cbSelecionarTodosCentroCusto" style="width: 45px">Sel</label>
                        </div>`,
                    width: '5%'
                },
                {
                    data: 'CONTA',
                    title: 'Conta',
                    width: '0%'
                },
                {
                    data: 'CODIGO',
                    title: 'Centro de Custo',
                    width: '90%'
                },
                {
                    data: 'PERC',
                    title: 'Percentual',
                    width: '10%'
                }];

            $("#tabelaCentroCusto").DataTable({
                order: false,
                sort: true,
                paging: false,
                destroy: true,
                lengthChange: false,
                info: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: data,
                columns: cols,
                columnDefs: [
                    {
                        targets: [0],
                        render: function (row, type, data, meta) {
                            return retornaBotaoSel(meta, data);
                        }
                    },
                    {
                        targets: [1],
                        visible: false
                    },
                    {
                        targets: [2],
                        render: function (row, type, data, meta) {
                            return retornaInputCentroCusto(meta.row, data);
                        }
                    },
                    {
                        targets: [3],
                        render: function (row, type, data, meta) {
                            return retornaInputPercCentroCusto(meta.row, data);
                        }
                    }
                ],
                rowCallback: async function (row, data) {

                    function atualizaValoresPesquisa() {
                        const data = $('#tabelaCentroCusto').DataTable().row(row._DT_RowIndex).data();

                        const novoCodigo = pegaChave(`#txtCentroCustoRateio_${row._DT_RowIndex}`);

                        const dataEx = $('#tabelaCentroCusto').DataTable().data().toArray();
                        const conta = $('#tabelaContas').DataTable().row($('tr.selected')).data().CONTA ?? '';

                        const findIndex = [];
                        dataEx.forEach((e, i) => { if (e.CONTA == conta && e.CODIGO == novoCodigo && i != row._DT_RowIndex) { findIndex.push(i) } });

                        if (findIndex.length > 0) {
                            msgErro(`Centro de custo já informado, impossível continuar.`, () => { $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).focus(); }, () => { $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).focus(); });
                            if (data.CODIGO != '') {
                                insereValor(`#txtCentroCustoRateio_${row._DT_RowIndex}`, data.CODIGO, data.DESCRICAO);
                            } else {
                                $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).val('');
                            }
                            return;
                        }

                        data.CODIGO = novoCodigo;
                        data.DESCRICAO = pegaDescricao(`#txtCentroCustoRateio_${row._DT_RowIndex}`);
                        data.PERC = $(`#txtPercCentroCustoRateio_${row._DT_RowIndex}`).val();

                        $('#tabelaCentroCusto').DataTable().row(row._DT_RowIndex).data(data).draw(false);
                    }

                    $(`#checkCentroCusto_row_${row._DT_RowIndex}`).off('change');

                    $(`#checkCentroCusto_row_${row._DT_RowIndex}`).on('change', function () {
                        let d = $('#tabelaCentroCusto').DataTable().row(row._DT_RowIndex).data();

                        d.CONTA = d.CONTA;
                        d.CODIGO = pegaChave(`#txtCentroCustoRateio_${row._DT_RowIndex}`);
                        d.DESCRICAO = pegaDescricao(`#txtCentroCustoRateio_${row._DT_RowIndex}`);
                        d.PERC = parseFloat($(`#txtPercCentroCustoRateio_${row._DT_RowIndex}`).val()) ?? 0;

                        if ($(this).prop('checked')) {
                            d.SEL = 'S';
                        } else {
                            d.SEL = 'N';
                        }

                        $('#tabelaCentroCusto').DataTable().row(row._DT_RowIndex).data(d).draw(false);
                    });

                    $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).off('focusout');

                    $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).on('focusout', function () {
                        const data = $('#tabelaCentroCusto').DataTable().row(row._DT_RowIndex).data();
                        if ($(this).val() == '' && data.CODIGO != '') {
                            insereValor(`#txtCentroCustoRateio_${row._DT_RowIndex}`, data.CODIGO, data.DESCRICAO);
                        }
                    });

                    $(`#btnCentroCustoRateio_${row._DT_RowIndex}`).pesquisa_serverside(
                        [`#txtCentroCustoRateio_${row._DT_RowIndex}`],
                        ['CODIGO'],
                        ['DESCRICAO'],
                        '{"tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Centro de Custo',
                        atualizaValoresPesquisa);

                    $(`#txtCentroCustoRateio_${row._DT_RowIndex}`).autocompleta(1,
                        `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`,
                        null,
                        null,
                        null,
                        () => { setTimeout(function () { atualizaValoresPesquisa() }, 1500) }
                    );
                    adicionaMascaraCampos();
                },
            }).draw(false);

            $('#cbSelecionarTodosCentroCusto').on('change', function () {
                if ($('#cbSelecionarTodosCentroCusto').prop('checked')) {
                    $('.campoSelCentroCusto').prop('checked', true);
                } else {
                    $('.campoSelCentroCusto').prop('checked', false);
                }
                $('.campoSelCentroCusto').trigger('change');
            });

            $('#tabelaCentroCusto thead th').each(function () {
                $(this)[0].style.verticalAlign = 'top';
            });

            if ($('#tabelaCentroCusto').DataTable().data().length > 0) {
                $($('#tabelaCentroCusto thead tr th')[0]).css('width', '50px');
                $('#tabelaCentroCusto thead tr th label').css('width', '30px');
            }
            $($('#tabelaContas tbody tr')[indice]).trigger('click');
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    };

    function adicionaMascaraCampos() {
        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimaisParametro').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == "") {
                $(this).val('0.00');
            }
        });
    };

    $('#btnExcluirCentroCusto').on('click', function () {
        const valida = $('#tabelaCentroCusto').DataTable().rows(function (idx, data, node) {
            return data.SEL == 'S';
        }).data();

        if (valida.length == 0) {
            msgErro('Nenhum registro selecionado, favor verificar.');
            return;
        }

        msgAlerta('Deseja excluir os registros selecionados?', () => { }, () => { }, () => { excluiCentroCustoRateio() }, () => { });
    });

    function excluiCentroCustoRateio() {
        try {
            const novosDados = [];

            $('#tabelaCentroCusto').DataTable().rows().every(function () {
                const data = this.data();
                const index = this.index();

                $('#tabelaCentroCusto').DataTable().column(1).search(``, true, false).draw(false);

                if (data.SEL != 'S') {
                    novosDados.push({
                        SEL: data.SEL,
                        CODIGO: data.CODIGO,
                        DESCRICAO: data.DESCRICAO,
                        CONTA: data.CONTA,
                        PERC: $(`#txtPercCentroCustoRateio_${index}`).val()
                    });
                };
            });

            adicionaDadosCentroCusto(novosDados, $('#tabelaContas').DataTable().row($('tr.selected')).index() ?? 0);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível realizar a exclusão: ${e}`);
        }
    }

    function filtraTabela() {
        const conta = $('#tabelaContas').DataTable().row($('tr.selected')).data().CONTA ?? '';
        $('#tabelaCentroCusto').DataTable().column(1).search(`^${conta}$|^$`, true, false).draw(false);
    };

    $('#btnAdicionarConta').on('click', function () {
        const data = $('#tabelaContas').DataTable().data().toArray();
        if (data.find(e => e.CONTA == '' || e.CONTA == '0')) {
            return;
        }
        adicionaConta();
    });

    $('#btnAdicionarCentroCusto').on('click', function () {
        const conta = $('#tabelaContas').DataTable().row($('tr.selected')).data().CONTA ?? '';
        if (conta == '') {
            msgErro('É necessário informar uma conta para adicionar um centro de custo, favor verificar.');
            return;
        }
        const data = $('#tabelaCentroCusto').DataTable().data().toArray();
        if (data.find(e => e.CODIGO == '' && e.CONTA == conta)) {
            return;
        }
        adicionaCentroCusto();
    });

    function adicionaConta() {
        try {
            let data = $('#tabelaContas').DataTable().data();

            data = data.map((e, i) => {
                e.SEL = e.SEL;
                e.CONTA = e.CONTA;
                e.DESCRICAO = e.DESCRICAO;
                e.PERC = $(`#txtPercContaRateio_${i}`).val()
                return e;
            });

            data.push({
                SEL: '',
                CONTA: '',
                DESCRICAO: '',
                PERC: 0
            });

            adicionaDadosConta(data);

            $($('#tabelaContas tbody tr')[$('#tabelaContas').DataTable().rows().count() - 1]).trigger('click');
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível adicionar o registro: ${e}`);
        }
    };

    function adicionaCentroCusto() {
        try {

            let data = $('#tabelaCentroCusto').DataTable().data();
            $('#tabelaCentroCusto').DataTable().column(1).search(``, true, false).draw(false);

            data = data.map((e, i) => {
                e.SEL = e.SEL;
                e.CODIGO = e.CODIGO;
                e.DESCRICAO = e.DESCRICAO;
                e.CONTA = e.CONTA;
                e.PERC = $(`#txtPercCentroCustoRateio_${i}`).val()

                return e;
            });

            data.push({
                SEL: '',
                CODIGO: '',
                DESCRICAO: '',
                CONTA: ($('#tabelaContas').DataTable().row($('tr.selected')).data()).CONTA ?? '',
                PERC: 0
            });

            adicionaDadosCentroCusto(data, $('#tabelaContas').DataTable().row($('tr.selected')).index() ?? 0);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível adicionar o registro: ${e}`);
        }
    }

    $('#btnCancelarRateio').on('click', function () {
        msgAlerta('Deseja cancelar as alterações?', () => { }, () => { }, () => { $('#modal-rateio').modal('hide') });
    });

    $('#modal-rateio').on('hidden.bs.modal', function () {
        $('#txtCodigoRateio').val('');
        $('#txtTipoRateio').val('');
        tipoValor = '';
        if ($.fn.DataTable.isDataTable('#tabelaContas')) {
            $('#tabelaContas').DataTable().destroy();
            $('#tabelaContas').empty();
        };
        if ($.fn.DataTable.isDataTable('#tabelaCentroCusto')) {
            $('#tabelaCentroCusto').DataTable().destroy();
            $('#tabelaCentroCusto').empty();
        };
    });

    $('#btnGravarRateio').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            if ($('#tabelaContas').DataTable().data().length == 0) {
                msgErro('Não existe nenhum dado a ser gravado.');
                return;
            }
            msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => { await gravaDados() });
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function gravaDados() {
        try {

            $('#tabelaCentroCusto').DataTable().column(1).search(``, true, false).draw(false);

            let dataContas = $('#tabelaContas').DataTable().data().toArray();
            let dataCC = $('#tabelaCentroCusto').DataTable().data().toArray();

            dataContas = dataContas.map((e, i) => {
                e.PERC = $(`#txtPercContaRateio_${i}`).val();
                return e;
            });

            dataCC = dataCC.map((e, i) => {
                e.PERC = $(`#txtPercCentroCustoRateio_${i}`).val();
                return e;
            });

            const obj = {};

            obj.CODIGO = pegaChave('#txtCodigoRateio');
            obj.TIPO = $('#txtTipoRateio').val();
            obj.TIPO_VAL = tipoValor;
            obj.ARRAYCONTAS = dataContas;
            obj.ARRAYCENTROSCUSTO = dataCC;

            let response = await requisicao("POST", `/Sisplan/rateiocontabil/V1/gravadados?`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem, () => { $($('#tabelaContas tbody tr')[0]).trigger('click'); }, () => { $($('#tabelaContas tbody tr')[0]).trigger('click'); });
                return;
            }

            toastr.success("Cadastro efetuado com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    buscaDadosRateio(pegaChave('#txtCodigoRateio'), $('#txtTipoRateio').val(), tipoValor);
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        }
    }

    $('#btnExcluirRateio').on('click', async function () {
        msgAlerta('Deseja excluir toda a configuração de rateio?', () => { }, () => { }, async () => { await excluiDados() });
    });

    async function excluiDados() {
        $.LoadingOverlay('hide');
        try {
            try {
                const response = await requisicao("DELETE", "/Sisplan/rateiocontabil/V1/excluidados?&", `CODIGO=${pegaChave('#txtCodigoRateio')}&TIPO=${$('#txtTipoRateio').val()}&TIPO_VAL=${tipoValor}`);

                if (!response) {
                    throw '';
                }

                if (response.status != 200) {
                    const jsonStr = await response.json();
                    throw msgAlerta(jsonStr.mensagem);
                };

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        buscaDadosRateio(pegaChave('#txtCodigoRateio'), $('#txtTipoRateio').val(), tipoValor);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (e) {
                console.log(e);
                msgErro(`Não foi possível realizar a exclusão: ${e}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

});