$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma nova Aplicação do PCP.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAlteracaoPedidoB2B',
        popover: {
          title: 'Tabela Pedidos B2B',
          description: 'Aqui estão os dados dos Pedidos B2B cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.alteracaob2b == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, alteracaob2b: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAlteracaoPedidoB2B').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.alteracaob2b ?? ['EMPRESA']);
  })

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, alteracaob2b: novasColunas }))

      $('#tabelaAlteracaoPedidoB2B').DataTable().columns().visible(true);

      $('#tabelaAlteracaoPedidoB2B').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const parametrosB2B = await BuscaParametrosPedidoB2B();
  let sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];

  await preencheOrdenacaoTela('RelAltPedidoB2B');
  retornaHintRelatorio('btnImprimir', 'RelAltPedidoB2B')

  setarDataAtual('txtDataEmiDe', true);
  setarDataAtual('txtDataFaturaDe', true);

  await consultarDados();

  addPesquisaAutocompleta();

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimiralteracaopedidob2b?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelAltPedidoB2B&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAltPedidoB2B');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelAltPedidoB2B');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  // $('#txtSituacao').on('focusout', async function () {
  //   const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', pegaChave(this));
  //   $('#cbNaoLancaCc').prop('checked', contaCor.GERA_CONTACOR == 'S');
  // });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $(`#btnConsultar`).on('click', async function () {
    await consultarDados();
  });

  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-alterar">Alterar</button>     ' +
      '</div>';
    return retorno;
  };

  $('#tabelaAlteracaoPedidoB2B').on('click', '#btn-alterar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAlteracaoPedidoB2B').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('ALTPEDIDOSB2B', data.PEDIDO);
      if (registroLiberado) {
        window.location.href = `altpedidob2b/${data.PEDIDO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = getCookie("cod_usuario");
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuario=${codusuario}&tela=${tela}`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const permissaoUsuarioLogado = await permissaoAcessos("ALTPEDIDOSB2B");

  $('#tabelaAlteracaoPedidoB2B').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAlteracaoPedidoB2B').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('ALTPEDIDOSB2B', data.PEDIDO);
      if (registroLiberado) {
        window.location.href = `altpedidob2b/${data.PEDIDO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function consultarDados() {
    try {

      // if (sCodrepUsuario == '') {
      //   msgAlerta('Usuário não pertence a um squad e sem representante vinculado ao cadastro de usuário!');
      //   return;
      // }

      $.LoadingOverlay('show');
      let dataSetCols = [];
      let separador = "' - '";
      const where = await retornaWhereFiltros();

      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO PEDIDO',
          `PEDIDO.CODCLI|| ${separador}||ENTIDADE.NOME CLIENTE`,
          'PEDIDO.DT_EMISSAO',
          'PEDIDO.DT_FATURA PREV_FATURA',
          'PEDIDO.ENTREGA PREV_ENTREGA',
          'SITPROD.DESCRICAO STATUS',
          'TIPO.DESCRICAO TIPO_VENDA',
          'SUM((PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_F) * PED_ITEN.PRECO) VALOR',
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: `PED_ITEN.NUMERO = PEDIDO.NUMERO` },
          { tabela: 'ENTIDADE', condicao: `PEDIDO.CODCLI = ENTIDADE.CODCLI` },
          { tabela: 'SITPROD', condicao: `SITPROD.CODIGO = PEDIDO.STATUS` },
          { tabela: 'TIPO', condicao: `PEDIDO.ID_TIPO = TIPO.ID_TIPO` },
          { tabela: 'PRODUTO', condicao: `PRODUTO.CODIGO = PED_ITEN.CODIGO` },
        ],
        where: [`1=1 ${where}`],
        groupBy: [
          "PEDIDO.NUMERO",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "PEDIDO.DT_EMISSAO",
          "SITPROD.DESCRICAO",
          "TIPO.DESCRICAO",
          "PEDIDO.ENTREGA",
          "PEDIDO.DT_FATURA"
        ],
        orderBy: ['PEDIDO.DT_EMISSAO ASC']
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!')
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      dataSetCols[0].render = function (data, type, row) {
        return retornaBotaoOpcoes(row.PEDIDO);
      }

      criaTabelaCardsAcesso('tabelaAlteracaoPedidoB2B', dataSetCols, jsonStr, [2, 3, 4], [7]);
      $('.sorting_asc').trigger('click')

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaAlteracaoPedidoB2B_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaAlteracaoPedidoB2B_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
    
      $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
      $('#buttonExcel').prop('title', 'Exportar');
    
      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });
    
      $('#buttonExcel').on('click', async function () {
        const filtros = await retornaFiltros();
        const url = `/sisplan/impressao/v1/alteracaopedidob2b?`;
    
        await exportaCSV(url, filtros, false, null, 'Relatório da aba alteração pedido B2B.', '#tabelaAlteracaoPedidoB2B');
      })

      $('#tabelaAlteracaoPedidoB2B').DataTable().columns().every(function () {
        if ((colunasInvisiveis.alteracaob2b).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  };

  function criaTabelaCardsAcesso(sId, columns, data, arrData, arrDinheiro) {
    $('#' + sId).DataTable({
      filter: false,
      info: true,
      destroy: true,
      autoWidth: true,
      colReorder: true,
      paging: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar (geral): ",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último"
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente"
        }
      },
      data: data,
      columns: columns,
      columnDefs: [
        {
          render: function (data, type, row) {
            let isIE = function () {
              return /MSIE|Edge/i.test(navigator.userAgent);
            };
            let x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;
          },
          targets: arrData,
        },
        {
          render: function (data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2
            });
          },
          targets: arrDinheiro,
        },
      ]
    });
  }


  async function retornaWhereFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());

    const usuarioSisplan = getCookie('cod_usuario') === '0000'
    let where = '';
    where = " AND (SITPROD.BLOQ_PED_B2B IS NULL OR SITPROD.BLOQ_PED_B2B <> 'S')";
    where += pegaChave('#txtListaPedidos') != '' ? ` AND PEDIDO.NUMERO IN (${$('#txtListaPedidos').val()})` : '';
    where += pegaChave('#txtClienteConsulta') != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtClienteConsulta')}'` : '';
    where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
    where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
    where += pegaChave('#txtStatusConsulta') != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatusConsulta')}'` : '';
    where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
    where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
    where += pegaChave('#txtTipoVendaConsulta') != '' ? ` AND TIPO.ID_TIPO = '${pegaChave('#txtTipoVendaConsulta')}'` : '';
    where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
    where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
    where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
    where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` : pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
    where += ` AND PEDIDO.EMP_ID IN (${empresasFiltradasFormatada})`

    if (usuarioSisplan) {
      if (pegaChave('#txtRepresentanteConsulta') != '') {
        where += pegaChave('#txtRepresentanteConsulta') != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentanteConsulta')}'` : '';
      }
    } else {
      where += ` AND PEDIDO.CODREP IN (${sCodrepUsuario})`
    }

    if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
    }
    if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
    }
    if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
    }
    if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
    }

    return where
  }

  function addPesquisaAutocompleta() {
    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedidoConsulta"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI", "PED_CLI" ], "where":["EMP_ID IN (${sEmpID})"]}`, "Pesquisa Pedido");

    $('#btn-limpa-PedidoConsulta').on('click', function () {
      $('#txtListaPedidos').val('');
    });

    $("#txtClienteConsulta").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#btn-ClienteConsulta").pesquisa_serverside(["#txtClienteConsulta"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Cliente");
    $('#btn-limpa-ClienteConsulta').on('click', function () { $('#txtClienteConsulta').val(''); });

    $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
    $('#btn-limpa-condicao').on('click', function () {
      $('#txtCondicaoDePagamento').val('');
      $('#txtNrParcelas').val('1');
    });

    $("#txtRepresentanteConsulta").autocompleta(2, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"]}`);
    $("#btn-RepresentanteConsulta").pesquisa_serverside(["#txtRepresentanteConsulta"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ]}`, "Pesquisa Representante");
    $('#btn-limpa-RepresentanteConsulta').on('click', function () { $('#txtRepresentanteConsulta').val(''); });

    $("#txtTabPrecoConsulta").autocompleta(2, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO.REGIAO CHAVE, REGIAO.DESCRICAO"]}`);
    $("#btn-TabPrecoConsulta").pesquisa_serverside(["#txtTabPrecoConsulta"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ]}`, "Pesquisa Tabela de Preço");
    $('#btn-limpa-TabPrecoConsulta').on('click', function () { $('#txtTabPrecoConsulta').val(''); });

    $("#txtColecaoConsulta").autocompleta(2, `JSON={ "tabela":"COLECAO", "camposSelect":["COLECAO.CODIGO CHAVE, COLECAO.DESCRICAO"]}`);
    $("#btn-ColecaoConsulta").pesquisa_serverside(["#txtColecaoConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Coleção");
    $('#btn-limpa-ColecaoConsulta').on('click', function () { $('#txtColecaoConsulta').val(''); });

    $("#txtGrupoPedConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["GRUPO_PED.CODIGO CHAVE, GRUPO_PED.DESCRICAO"]}`);
    $("#btn-GrupoPedConsulta").pesquisa_serverside(["#txtGrupoPedConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Pedido");
    $('#btn-limpa-GrupoPedConsulta').on('click', function () { $('#txtGrupoPedConsulta').val(''); });

    $("#txtGrupoProdConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["GRUPO_PA.CODIGO CHAVE, GRUPO_PA.DESCRICAO"]}`);
    $("#btn-GrupoProdConsulta").pesquisa_serverside(["#txtGrupoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Produto");
    $('#btn-limpa-GrupoProdConsulta').on('click', function () { $('#txtGrupoProdConsulta').val(''); });

    $("#txtTipoProdConsulta").autocompleta(2, `JSON={ "tabela":"CAD_TIPO_PROD", "camposSelect":["CAD_TIPO_PROD.CODIGO CHAVE, CAD_TIPO_PROD.DESCRICAO"]}`);
    $("#btn-TipoProdConsulta").pesquisa_serverside(["#txtTipoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CAD_TIPO_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Tipo Produto");
    $('#btn-limpa-TipoProdConsulta').on('click', function () { $('#txtTipoProdConsulta').val(''); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Moeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-Historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-ClasseGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-Situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-Banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $("#btn-limpa-Conta").on("click", function () { $("#txtConta").val(""); });

    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });

    $('#txtStatusConsulta').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-StatusConsulta').pesquisa('#txtStatusConsulta', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-StatusConsulta').on('click', function () { $('#txtStatusConsulta').val('') });

    $('#txtTipoVendaConsulta').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-TipoVendaConsulta').pesquisa('#txtTipoVendaConsulta', 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo', 'TIPO');
    $('#btn-limpa-TipoVendaConsulta').on('click', function () { $('#txtTipoVendaConsulta').val('') });
  };

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtPedidoConsulta').val('');
    $('#txtListaPedidos').val('');
    $('#txtClienteConsulta').val('');
    $('#txtRepresentanteConsulta').val('');
    $('#txtTabPrecoConsulta').val('');
    $('#txtColecaoConsulta').val('');
    $('#txtGrupoPedConsulta').val('');
    $('#txtGrupoProdConsulta').val('');
    $('#txtTipoProdConsulta').val('');
    $('#txtTipoVendaConsulta').val('');
    $("#txtDataEmiDe").val("1200-01-01");
    $("#txtDataEntregaDe").val("1200-01-01");
    $("#txtDataFaturaDe").val("1200-01-01");
    $("#txtDataSaidaDe").val("1200-01-01");
    $("#txtDataEmiAte").val("2500-12-01");
    $("#txtDataEntregaAte").val("2500-12-01");
    $("#txtDataFaturaAte").val("2500-12-01");
    $("#txtDataSaidaAte").val("2500-12-01");
    $('#txtBloqFinConsulta').val('');
    $('#txtBloqComConsulta').val('');
    $('#txtSituacaoConsulta').val('');
    $('#txtStatusConsulta').val('');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());

    const retorno =
      `PEDIDO=${$('#txtListaPedidos').val()}` +
      `&CLIENTE=${pegaChave('#txtClienteConsulta')}` +
      `&REPRESENTANTE=${pegaChave('#txtRepresentanteConsulta')}` +
      `&STATUS=${pegaChave('#txtStatusConsulta')}` +
      `&TABPRECO=${pegaChave('#txtTabPrecoConsulta')}` +
      `&COLECAO=${pegaChave('#txtColecaoConsulta')}` +
      `&GRUPOPEDIDO=${pegaChave('#txtGrupoPedConsulta')}` +
      `&GRUPOPRODUTO=${pegaChave('#txtGrupoProdConsulta')}` +
      `&TIPOPRODUTO=${pegaChave('#txtTipoProdConsulta')}` +
      `&TIPOVENDA=${pegaChave('#txtTipoVendaConsulta')}` +
      `&EMISSAODE=${$('#txtDataEmiDe').val()}` +
      `&EMISSAOATE=${$('#txtDataEmiAte').val()}` +
      `&ENTREGADE=${$('#txtDataEntregaDe').val()}` +
      `&ENTREGAATE=${$('#txtDataEntregaAte').val()}` +
      `&FATURADE=${$('#txtDataFaturaDe').val()}` +
      `&FATURAATE=${$('#txtDataFaturaAte').val()}` +
      `&SAIDADE=${$('#txtDataSaidaDe').val()}` +
      `&SAIDAATE=${$('#txtDataSaidaAte').val()}` +
      `&BLOQFINANCEIRO=${$('#txtBloqFinConsulta').val()}` +
      `&BLOQCOMERCIAL=${$('#txtBloqComConsulta').val()}` +
      `&SITUACAO=${$('#txtSituacaoConsulta').val()}` +
      `&EMPRESAS_FILTRO=${empresasFiltradasFormatada}`
    return retorno;
  }

  $('#txtPedidoConsulta').on('blur', function () {
    let pedido = $('#txtPedidoConsulta').val();
    if (pedido.includes("[")) {
      pedido = pegaChave($('#txtPedidoConsulta'));
    } else {
      pedido = $('#txtPedidoConsulta').val();
    }
    pedido = pedido.replace('\w', '');
    const listaPedidos = $('#txtListaPedidos').val();
    if (pedido == '') {
      return;
    }
    $('#txtListaPedidos').val((listaPedidos == '') ? `'${pedido}'` : `${listaPedidos},'${pedido}'`);
    $('#txtPedidoConsulta').val('');
    $('#txtPedidoConsulta').focus();
  });
});
