$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#divTabelaConsumos',
        popover: {
          title: 'Consumos',
          description: 'Aqui se encontram os consumos da ordem de produção informada.',
          position: 'top'
        }
      },
      {
        element: '#txtBarra',
        popover: {
          title: 'Barra',
          description: 'Aqui é possível fazer a baixa bipando uma barra de material.',
          position: 'top'
        }
      },
      {
        element: '#tabLotes',
        popover: {
          title: 'Estoque/Reserva',
          description: 'Aqui se encontram os lotes em estoque/reserva disponíveis.',
          position: 'top'
        }
      },
      {
        element: '#tabBaixas',
        popover: {
          title: 'Baixas',
          description: 'Aqui se encontram as baixas realizadas para a ordem de produção informada.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  componenteFiltro('deposito', false, false);
  componenteFiltro('qualidade', false, false);
  componenteFiltro('cliente', false, false);
  componenteFiltro('parte', true, true);
  componenteFiltro('aplicacao', true, true);
  componenteFiltro('grupoMA', true, true, 'Grupo');
  componenteFiltro('subGrupo', true, true);
  componenteFiltro('setor', true, true);
  componenteFiltro('ordemProducao', false, false, 'OF');
  componenteFiltro('tipoMov', false, false, 'TipoBaixa');
  // controle de itens
  // componenteFiltro('material', false, false, 'CodigoCI');
  componenteFiltro('cor', false, false, 'CorCI');
  componenteFiltro('deposito', false, false, 'DepositoCI');
  componenteFiltro('aplicacao', false, false, 'AplicacaoCI');
  componenteFiltro('setor', false, false, 'SetorCI');
  componenteFiltro('parte', false, false, 'ParteCI');

  $('#txtCodigoCI').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO, UNIDADE"], "where": [] }`, ['#txtUnidadeCI'], ['UNIDADE'], ['UNIDADE'], undefined, [true]);
  $('#btnCodigoCI').pesquisa_serverside(['#txtCodigoCI', '#txtUnidadeCI'], ['CODIGO', 'UNIDADE'], ['DESCRICAO', 'UNIDADE'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE" ], "where": null}', 'Pesquisa Material', undefined, [false, true]);
  $('#btnLimpaCodigoCI').on('click', function () {
    $('#txtCodigoCI').val('');
    $('#txtUnidadeCI').val('');
  });

  if (screen.height < 1080) {
    $('#tabControleItens').css('max-height', '250px');
  } else {
    $('#tabControleItens').css('max-height', '400px');
  }

  $('#txtOF, #txtDeposito').on('blur', async function () {
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    try {
      if (numero != '' && deposito != '') {
        $.LoadingOverlay('show');

        await buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor);
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#txtParte, #txtAplicacao, #txtGrupo, #txtSubGrupo, #txtSetor').on('change', function () {
    $('#txtOF').trigger('blur');
  })

  async function buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor) {
    let response = await requisicao('GET', '/Sisplan/baixaconsumos/V1/buscadados?', `&NUMERO=${numero}&&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}`, null);

    if (!response) {
      return;
    }

    let data = await response.json();
    if (response.status != 200) {
      msgErro(data.mensagem);
    }

    criaTabelaConsumos(data.CONSUMOS);
    criaTabelaEstoqueReserva(data.ESTOQUE_RESERVA);
    criaTabelaBaixas(data.BAIXAS);
    $('#txtPrecoSped').val(data.PRECO_SPED);
    if (data.FINALIZADO) {
      $('#btnGravar').removeClass('d-none');
      $('#btnEstornar').removeClass('d-none');
      $('#btnControleItens').removeClass('d-none');
      $('#btnGravar').prop('disabled', true);
      $('#btnEstornar').prop('disabled', true);
      $('#btnControleItens').prop('disabled', true);
      $('#btnFinalizar').addClass('d-none');
      $('#btnReabrir').removeClass('d-none');
      msgErro('Baixa de consumos já finalizada para essa OF.');
    } else {
      $('#btnGravar').removeClass('d-none');
      $('#btnEstornar').removeClass('d-none');
      $('#btnControleItens').removeClass('d-none');
      $('#btnGravar').prop('disabled', false);
      $('#btnEstornar').prop('disabled', false);
      $('#btnControleItens').prop('disabled', false);
      $('#btnFinalizar').removeClass('d-none');
      $('#btnReabrir').addClass('d-none');
    }
  }

  $('#txtPrecoSped').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  function adicionaMascaraCampos() {
    $('.apenasFloat').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 4,
    });

    $('.apenasInteiros').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function criaTabelaConsumos(info) {
    function carregaInput(valor, indices) {
      return `<input type="text" id="txtBaixar_${indices.row}"
              class="input-default focus form-control apenasFloat text-right classBaixar"
              style="min-width: 15ch; max-width: 20ch" value="${valor}">`;
    }

    if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
      $('#tabelaConsumos').DataTable().destroy();
      $('#tabelaConsumos').empty();
    }

    const cols = [
      {
        data: 'ID_CONSUMO',
        title: 'Id'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição'
      },
      {
        data: 'UNIDADE',
        title: 'Unidade'
      },
      {
        data: 'COR',
        title: 'Cor'
      },
      {
        data: 'DESC_COR',
        title: 'Desc. Cor'
      },
      {
        data: 'QTDE',
        title: 'Qtde'
      },
      {
        data: 'CONS_ORIG',
        title: 'Consumo Original'
      },
      {
        data: 'CONSUMO',
        title: 'Consumo'
      },
      {
        data: 'BAIXADO',
        title: 'Baixado'
      },
      {
        data: 'SALDO',
        title: 'Saldo'
      },
      {
        data: 'BAIXAR',
        title: 'Baixar'
      },
      {
        data: 'TOTAL_RESERVA',
        title: 'Total Reserva'
      },
      {
        data: 'ESTOQUE',
        title: 'Estoque'
      },
      {
        data: 'RESERVA',
        title: 'Reserva'
      },
      {
        data: 'APLICACAO',
        title: 'Aplicação'
      },
      {
        data: 'DESC_APLICACAO',
        title: 'Desc. Aplicação'
      },
      {
        data: 'SETOR',
        title: 'Setor'
      },
      {
        data: 'DESC_SETOR',
        title: 'Desc. Setor'
      },
      {
        data: 'DEPOSITO',
        title: 'Depósito'
      },
      {
        data: 'LOTE',
        title: 'Lote'
      },
      {
        data: 'PARTE',
        title: 'Parte'
      }];

    $("#tabelaConsumos").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [
        {
          targets: [11],
          render: function (data, type, row, meta) {
            return carregaInput(data, meta);
          }
        },
        {
          targets: [6, 7, 8, 9, 10, 12, 13, 14],
          render: function (data) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4);
          }
        }],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    $('#tabelaConsumos tbody').unbind('click');
    $('#tabelaConsumos tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaConsumos').DataTable().data().length > 0) {
        $('#tabelaConsumos').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        filtraEstReserva($('#tabelaConsumos').DataTable().row($(this)).data());
      }
    });

    $('.classBaixar').on('keydown', async function (e) {
      if (e.which == 13) {
        e.preventDefault();
        $(this).trigger('blur');
      }
    });

    $('.classBaixar').on('blur', async function () {
      const id_consumo = $('#tabelaConsumos').DataTable().row($('tr.selected')).data().ID_CONSUMO;
      const qtde_baixada = $('#tabelaConsumos').DataTable().row($('tr.selected')).data().BAIXADO;
      const dataEst = $('#tabelaEstReserva').DataTable().data().toArray();
      const qtde = $(this).val();
      const valida = dataEst.find(function (e) { if (e.ID_CONSUMO == id_consumo && parseFloat(e.CONSUMO) == parseFloat(qtde)) { return } })
      if (valida) {
        return;
      }
      const row = $('#tabelaConsumos').DataTable().$('tr.selected');
      await recalculaQtdeNova(id_consumo,
        dataEst,
        qtde,
        qtde_baixada);
      $(row).trigger('click');
    });
  }

  function filtraEstReserva(data) {
    $('#tabelaEstReserva').DataTable().column(1).search(`^${data.ID_CONSUMO}$|^$`, true, false).draw(false);
  }

  function criaTabelaEstoqueReserva(info) {
    function retornaBotaoSel(meta, data) {
      let marcado = '';
      if (data.SEL == 'S') {
        marcado = 'checked';
      }

      return `<div class="icheck-primary" style="max-width: 20px">
            <input type="checkbox" ${marcado} id="cbSel_${meta.row}" class="cbSel">
            <label for="cbSel_${meta.row}"></label>
          </div>`
    };

    if ($.fn.DataTable.isDataTable('#tabelaEstReserva')) {
      $('#tabelaEstReserva').DataTable().destroy();
      $('#tabelaEstReserva').empty();
    }

    const cols = [
      {
        data: 'SEL',
        title: 'Sel'
      },
      {
        data: 'ID_CONSUMO',
        title: 'Id'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'COR',
        title: 'Cor'
      },
      {
        data: 'DEPOSITO',
        title: 'Depósito'
      },
      {
        data: 'BARRA',
        title: 'Barra'
      },
      {
        data: 'LOTE',
        title: 'Lote'
      },
      {
        data: 'QUALIDADE',
        title: 'Qualidade'
      },
      {
        data: 'QTDE',
        title: 'Estoque'
      },
      {
        data: 'UTILIZADO',
        title: 'Utilizado'
      },
      {
        data: 'RESERV_TOTAL',
        title: 'Reserva Total'
      },
      {
        data: 'RESERVADO',
        title: 'Reservado'
      },
      {
        data: 'SALDO_RESERV',
        title: 'Disponível'
      },
      {
        data: 'CONSUMO',
        title: 'Consumo'
      },
      {
        data: 'SALDO',
        title: 'Saldo'
      },
      {
        data: 'QTDE_B',
        title: 'Baixar'
      },
      {
        data: 'LOCAL',
        title: 'Local'
      },
      {
        data: 'DT_ENTRADA',
        title: 'Data Entrada'
      },
      {
        data: 'OBS',
        title: 'Obs'
      }];

    $("#tabelaEstReserva").DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: true,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [{
        targets: [1],
        visible: false
      },
      {
        targets: [0],
        render: function (data, type, row, meta) {
          return retornaBotaoSel(meta, row);
        }
      },
      {
        targets: [8, 9, 10, 11, 12, 13, 14, 15],
        render: function (data, type, row, meta) {
          if (!data) {
            return parseFloat(0).toFixed(4);
          }
          return parseFloat(data).toFixed(4)
        }
      },
      {
        targets: [17],
        type: "date-br",
        render(data) {
          if (!data) {
            return '';
          }
          return new Intl.DateTimeFormat("pt-BR").format(
            new Date(`${data.split(" ")[0]} 23:59:59`)
          );
        },
      }
      ],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    if ($('#tabelaConsumos').DataTable().data().length > 0) {
      $($('#tabelaConsumos tr')[1]).trigger('click');
    }
    adicionaMascaraCampos();
  }

  $('#tabelaEstReserva').on('change', '.cbSel', async function () {
    const row = $('#tabelaConsumos').DataTable().$('tr.selected');
    await recalculaQtdeSel($('#tabelaEstReserva').DataTable().row($(this).parents('tr')).data(),
      $('#tabelaEstReserva').DataTable().data().toArray(),
      this,
      $('#tabelaConsumos').DataTable().row($('tr.selected')).data().BAIXADO);
    $(row).trigger('click');
  });

  async function recalculaQtdeNova(id_consumo, data, qtdeNova, qtdeBaixada) {
    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/recalculaqtdenova?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${id_consumo}&QTDE_NOVA=${qtdeNova.replace('.', ',')}&QTDE_BAIXADA=${String(qtdeBaixada).replace('.', ',')}`);

    if (!response) {
      return;
    }

    let json = await response.json();
    if (response.status != 200) {
      msgErro(json.mensagem);
      $(instance).prop('checked', false);
      return;
    }

    criaTabelaEstoqueReserva(json);
  }

  async function recalculaQtdeSel(data_selected, data, instance, qtde_bai) {

    // let qtdeNova = $($('#tabelaConsumos').DataTable().row($('tr.selected')).node()).find('.classBaixar').val();
    // qtdeNova = parseFloat(qtdeNova);

    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/recalculaqtdesel?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${data_selected.ID_CONSUMO}&CODIGO=${data_selected.CODIGO}&COR=${data_selected.COR}&LOTE=${data_selected.LOTE}&ACAO=${$(instance).prop('checked')}&QTDE_BAIXADA=${String(qtde_bai).replace('.', ',')}`);

    if (!response) {
      return;
    }

    let json = await response.json();
    if (response.status != 200) {
      msgErro(json.mensagem);
      $(instance).prop('checked', false);
      return;
    }

    criaTabelaEstoqueReserva(json);
  }

  $('#btnFinalizar').on('click', async function (e) {
    e.preventDefault();
    if ($('#txtOF').val() == '') {
      msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
      return;
    }

    if ($('#txtDeposito').val() == '') {
      msgErro('Depósito não informado, impossível continuar.', () => { $('#txtDeposito').focus() }, () => { $('#txtDeposito').focus() });
      return;
    }

    if ($('#txtQualidade').val() == '') {
      msgErro('Qualidade não informada, impossível continuar.', () => { $('#txtQualidade').focus() }, () => { $('#txtQualidade').focus() });
      return;
    }

    msgAlerta('Deseja finalizar a baixa de consumos dessa OF?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await FinalizaBaixa(); } finally { $.LoadingOverlay('hide') } });
  });

  async function FinalizaBaixa() {
    try {
      const obj = {
        NUMERO: pegaChave('#txtOF'),
        DEPOSITO: pegaChave('#txtDeposito'),
        QUALIDADE: pegaChave('#txtQualidade'),
        PRECO_SPED: $('#txtPrecoSped').val(),
        ITENS: $('#tabelaConsumos').DataTable().data().toArray()
      }

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/finalizabaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSON=${encodeURIComponent(JSON.stringify(obj))}`);
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() { $('#txtOF').trigger('blur') },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível finalizar a baixa de consumos: ${e}`);
    }
  }

  $('#btnReabrir').on('click', async function (e) {
    e.preventDefault();

    if ($('#txtOF').val() == '') {
      msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
      return;
    }

    if ($('#txtDeposito').val() == '') {
      msgErro('Depósito não informado, impossível continuar.', () => { $('#txtDeposito').focus() }, () => { $('#txtDeposito').focus() });
      return;
    }

    if ($('#txtQualidade').val() == '') {
      msgErro('Qualidade não informada, impossível continuar.', () => { $('#txtQualidade').focus() }, () => { $('#txtQualidade').focus() });
      return;
    }

    msgAlerta('Deseja reabrir a baixa de consumos dessa OF?', () => { }, () => { }, async function () { $.LoadingOverlay('show'); try { await ReabreBaixa(); } finally { $.LoadingOverlay('hide') } })
  });

  async function ReabreBaixa() {
    try {
      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/reabrebaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&NUMERO=${pegaChave('#txtOF')}`);
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() { $('#txtOF').trigger('blur') },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível reabrir a baixa de consumos: ${e}`);
    }
  }

  $('#btnGravar').on('click', async function (e) {
    e.preventDefault();
    try {
      msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await gravaBaixaConsumos() } finally { $.LoadingOverlay('hide') } })
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
    }
  });

  async function gravaBaixaConsumos() {
    function retornaConsumos() {
      return $('#tabelaConsumos').DataTable().data().toArray().map(function (e, i) {
        return {
          ID_CONSUMO: e.ID_CONSUMO,
          CODIGO: e.CODIGO,
          COR: e.COR,
          APLICACAO: e.APLICACAO,
          DEPOSITO: e.DEPOSITO,
          LOTE: e.LOTE,
          BAIXAR: $(`#txtBaixar_${i}`).val(),
          SETOR: e.SETOR,
          PARTE: e.PARTE
        }
      })
    }

    const obj = {
      NUMERO: pegaChave('#txtOF'),
      DEPOSITO: pegaChave('#txtDeposito'),
      QUALIDADE: pegaChave('#txtQualidade'),
      PRECO_SPED: $('#txtPrecoSped').val(),
      CLIENTE: pegaChave('#txtCliente'),
      TIPO_BAIXA: pegaChave('#txtTipoBaixa'),
      MOVIMENTO: $('#txtMovimento').val(),
      ITENS: retornaConsumos(),
      LOTES: $('#tabelaEstReserva').DataTable().data().toArray()
    }

    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSON=${encodeURIComponent(JSON.stringify(obj))}`);
    if (!response) {
      return;
    }

    if (response.status != 200) {
      let json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() { window.location.href = `${BASE_URI}/baixa_consumos` },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
  }

  function criaTabelaBaixas(info) {

    if ($.fn.DataTable.isDataTable('#tabelaBaixas')) {
      $('#tabelaBaixas').DataTable().destroy();
      $('#tabelaBaixas').empty();
    }

    const cols = [
      {
        data: 'ID_CONSUMO',
        title: 'Id'
      },
      {
        data: 'ORDEM',
        title: 'Ordem'
      },
      {
        data: 'LANCAMENTO',
        title: 'Lançamento'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'COR',
        title: 'Cor'
      },
      {
        data: 'DESC_COR',
        title: 'Desc. Cor'
      },
      {
        data: 'DEPOSITO',
        title: 'Depósito'
      },
      {
        data: 'LOTE',
        title: 'Lote'
      },
      {
        data: 'QTDE',
        title: 'Quantidade'
      },
      {
        data: 'DT_MOVTO',
        title: 'Data Mov'
      },
      {
        data: 'PRECO',
        title: 'Preço'
      },
      {
        data: 'ESTOQUE',
        title: 'Estoque'
      },
      {
        data: 'MOV',
        title: 'Mov'
      },
      {
        data: 'DESC_MOV',
        title: 'Descrição Mov'
      },
      {
        data: 'TIPO',
        title: 'Tipo'
      },
      {
        data: 'DESC_TIPO',
        title: 'Desc. Tipo'
      },
      {
        data: 'QUALIDADE',
        title: 'Qualidade'
      }];

    $("#tabelaBaixas").DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [{
        targets: [8, 10, 11],
        render: function (data, type, row, meta) {
          if (!data) {
            return parseFloat(0).toFixed(4);
          }
          return parseFloat(data).toFixed(4)
        }
      },
      {
        targets: [9],
        type: "date-br",
        render(data) {
          if (!data) {
            return '';
          }
          return new Intl.DateTimeFormat("pt-BR").format(
            new Date(`${data.split(" ")[0]} 23:59:59`)
          );
        },
      }],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    $('#tabelaBaixas tbody').unbind('click');
    $('#tabelaBaixas tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaBaixas').DataTable().data().length > 0) {
        $('#tabelaBaixas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        filtraEstReserva($('#tabelaBaixas').DataTable().row($(this)).data());
      }
    });
  }

  $('#btnEstornar').on('click', async function (e) {
    e.preventDefault();
    try {
      if ($('#tabelaBaixas').DataTable().data().length == 0) {
        msgErro('Não existem lançamentos. Impossível continuar.');
        return;
      }

      const data = $('#tabelaBaixas').DataTable().row($('tr.selected')).data();
      if (!data) {
        msgErro('Nenhum lançamento selecionado. Impossível continuar.');
        return;
      }

      msgAlerta('Deseja realmente estornar o lançamento selecionado?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await estornaBaixa(data) } finally { $.LoadingOverlay('hide') } });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar o estorno: ${e}`);
    } finally {
    }
  })

  async function estornaBaixa(row) {
    const data = $('#tabelaBaixas').DataTable().data().toArray();
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    if (numero != '' && deposito != '') {

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/estornabaixa?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
        `&DATA=${encodeURIComponent(JSON.stringify(data))}&ID_CONSUMO=${row.ID_CONSUMO}&LANCAMENTO=${row.LANCAMENTO}&ORDEM=${row.ORDEM}&NUMERO=${numero}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      criaTabelaConsumos(json.CONSUMOS);
      criaTabelaEstoqueReserva(json.ESTOQUE_RESERVA);
      criaTabelaBaixas(json.BAIXAS);
      $('#txtPrecoSped').val(data.PRECO_SPED);

      toastr.success("Lançamento estornado com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } else {
      msgErro('Número e/ou depósito inválido(s). Impossível continuar.');
      return;
    }
  }

  // function deepCopy(obj) {
  //   if (typeof obj !== 'object' || obj === null) {
  //     return obj;
  //   }

  //   if (Array.isArray(obj)) {
  //     return obj.map(deepCopy);
  //   }

  //   const newObj = {};
  //   for (const key in obj) {
  //     if (obj.hasOwnProperty(key)) {
  //       newObj[key] = deepCopy(obj[key]);
  //     }
  //   }

  //   return newObj;
  // }

  $('#txtBarra').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#btnConfirmarBarra').trigger('click');
    }
  });

  $('#btnConfirmarBarra').on('click', async function (e) {
    e.preventDefault();
    const barra = $('#txtBarra').val();
    if (barra == '') {
      msgErro('Nenhuma barra informada. Impossível continuar.', () => { }, () => { $('#txtBarra').focus() }, () => { $('#txtBarra').focus() });
      return;
    }
    $.LoadingOverlay('show');
    try {
      const deposito = pegaChave('#txtDeposito');
      const cliente = pegaChave('#txtCliente');
      const numero = pegaChave('#txtOF');
      const qualidade = pegaChave('#txtQualidade');
      const tipoBaixa = pegaChave('#txtTipoBaixa');
      const parte = await formataListas($('#txtParte').val().toString());
      const aplicacao = await formataListas($('#txtAplicacao').val().toString());
      const grupo = await formataListas($('#txtGrupo').val().toString());
      const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
      const setor = await formataListas($('#txtSetor').val().toString());

      await leBarraConsumo(deposito, cliente, numero, barra, qualidade, tipoBaixa, parte, aplicacao, grupo, subgrupo, setor);
    } finally {
      $.LoadingOverlay('hide');
      $('#txtBarra').val('');
    }
  })

  async function leBarraConsumo(deposito, cliente, numero, barra, qualidade, tipoBaixa, parte, aplicacao, grupo, subgrupo, setor) {
    try {
      const dados = { ITENS: retornaConsumos() };

      let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/lebarra?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
        `&DATA=${encodeURIComponent(JSON.stringify(dados))}&NUMERO=${numero}&DEPOSITO=${deposito}&CLIENTE=${cliente}&BARRA=${barra}&QUALIDADE=${qualidade}&TIPO_BAIXA=${tipoBaixa}&PARTE=${parte}&APLICACAO=${aplicacao}&GRUPO=${grupo}&SUBGRUPO=${subgrupo}&SETOR=${setor}`);

      if (!response) {
        return;
      }

      let json = await response.json();
      if (response.status != 200) {
        msgErro(json.mensagem);
        return;
      }

      criaTabelaConsumos(json.CONSUMOS);
      criaTabelaEstoqueReserva(json.ESTOQUE_RESERVA);
      criaTabelaBaixas(json.BAIXAS);
      $('#txtPrecoSped').val(json.PRECO_SPED);

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível ler a barra: ${e}`, () => { $('#txtBarra').val(''); $('#txtBarra').focus() }, () => { $('#txtBarra').val(''); $('#txtBarra').focus() });
    }
  }

  function retornaConsumos() {
    return $('#tabelaConsumos').DataTable().data().toArray().map(function (e, i) {
      return {
        codigo: e.CODIGO,
        descricao: e.DESCRICAO,
        unidade: e.UNIDADE,
        cor: e.COR,
        descCor: e.DESC_COR,
        quantidade: e.QTDE,
        consumoOriginal: e.CONS_ORIG,
        consumo: e.CONSUMO,
        baixado: e.BAIXADO,
        saldo: e.SALDO,
        baixar: $(`#txtBaixar_${i}`).val(),
        estoque: e.ESTOQUE,
        lote: e.LOTE,
        deposito: e.DEPOSITO,
        reserva: e.RESERVA,
        totalReserva: e.TOTAL_RESERVA,
        codApl: e.APLICACAO,
        descApl: e.DESC_APLICACAO,
        setor: e.SETOR,
        descSetor: e.DESC_SETOR,
        parte: e.PARTE,
        idConsumo: e.ID_CONSUMO
      }
    })
  }

  $('#btnControleItens').on('click', function (e) {
    e.preventDefault();
    if ($('#txtOF').val() == '') {
      msgErro('OF não informada, impossível continuar.', () => { $('#txtOF').focus() }, () => { $('#txtOF').focus() });
      return;
    }
    $('#modal-controle-itens').modal('show');
    criaTabelaControleItens($('#tabelaConsumos').DataTable().data().toArray());
    $('.classCI').prop('disabled', true);
  })

  function criaTabelaControleItens(info) {

    if ($.fn.DataTable.isDataTable('#tabelaControleItens')) {
      $('#tabelaControleItens').DataTable().destroy();
      $('#tabelaControleItens').empty();
    }

    const cols = [
      {
        data: 'ID_CONSUMO',
        title: 'Id'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição'
      },
      {
        data: 'UNIDADE',
        title: 'Unidade'
      },
      {
        data: 'COR',
        title: 'Cor'
      },
      {
        data: 'DESC_COR',
        title: 'Desc. Cor'
      },
      {
        data: 'QTDE',
        title: 'Qtde'
      },
      {
        data: 'CONS_ORIG',
        title: 'Consumo Original'
      },
      {
        data: 'CONSUMO',
        title: 'Consumo'
      },
      {
        data: 'BAIXADO',
        title: 'Baixado'
      },
      {
        data: 'SALDO',
        title: 'Saldo'
      },
      {
        data: 'BAIXAR',
        title: 'Baixar'
      },
      {
        data: 'TOTAL_RESERVA',
        title: 'Total Reserva'
      },
      {
        data: 'ESTOQUE',
        title: 'Estoque'
      },
      {
        data: 'RESERVA',
        title: 'Reserva'
      },
      {
        data: 'APLICACAO',
        title: 'Aplicação'
      },
      {
        data: 'DESC_APLICACAO',
        title: 'Desc. Aplicação'
      },
      {
        data: 'SETOR',
        title: 'Setor'
      },
      {
        data: 'DESC_SETOR',
        title: 'Desc. Setor'
      },
      {
        data: 'DEPOSITO',
        title: 'Depósito'
      },
      {
        data: 'LOTE',
        title: 'Lote'
      },
      {
        data: 'PARTE',
        title: 'Parte'
      }];

    $("#tabelaControleItens").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [
        {
          targets: [6, 7, 8, 9, 10, 11, 12, 13, 14],
          render: function (data) {
            if (!data) {
              return parseFloat(0).toFixed(4);
            }
            return parseFloat(data).toFixed(4);
          }
        }],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    $('#tabelaControleItens tbody').unbind('click');
    $('#tabelaControleItens tbody').on('click', 'tr', async function (e) {
      if ($('#tabelaControleItens').DataTable().data().length > 0) {
        $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        preencheDadosControleItens($('#tabelaControleItens').DataTable().row($('tr.selected')).data());
      }
    });

    if ($('#tabelaControleItens').DataTable().data().length > 0) {
      $($('#tabelaControleItens tr')[1]).trigger('click');
    }
  }

  function preencheDadosControleItens(data) {
    insereValor('#txtIdCI', data.ID_CONSUMO);
    insereValor('#txtCodigoCI', data.CODIGO, data.DESCRICAO);
    insereValor('#txtCorCI', data.COR, data.DESC_COR);
    insereValor('#txtAplicacaoCI', data.APLICACAO, data.DESC_APLICACAO);
    insereValor('#txtSetorCI', data.SETOR, data.DESC_SETOR);
    insereValor('#txtParteCI', data.PARTE, { tabela: 'TIPO_APL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.PARTE });
    insereValor('#txtUnidadeCI', data.UNIDADE);
    insereValor('#txtConsumoCI', data.CONSUMO);
    insereValor('#txtConsumoOrigCI', data.CONS_ORIG);
    insereValor('#txtBaixadoCI', data.BAIXADO);
    insereValor('#txtConsumoUniCI', '0');
  }

  $('#btnAlterarCI').on('click', function () {
    $('#txtConsumoUniCI').prop('disabled', true);
    habilitaEdicaoCI();
    $('#txtCodigoCI').prop('disabled', true);
    $('#btnCodigoCI').prop('disabled', true);
    $('#btnLimpaCodigoCI').prop('disabled', true);
    $('#txtCorCI').prop('disabled', true);
    $('#btnCorCI').prop('disabled', true);
    $('#btnLimpaCorCI').prop('disabled', true);
  })

  function habilitaEdicaoCI() {
    $('.classCI').prop('disabled', false);
    $('#btnConfirmarCI').removeClass('d-none');
    $('#btnDesistirCI').removeClass('d-none');
    $('#btnIncluirCI').addClass('d-none');
    $('#btnAlterarCI').addClass('d-none');
    $('#btnExcluirCI').addClass('d-none');
  }

  $('#btnDesistirCI').on('click', function () {
    desabilitaEdicaoCI();
    if ($('#tabelaControleItens').DataTable().data().length > 0) {
      $($('#tabelaControleItens tr')[1]).trigger('click');
    }
  })

  function desabilitaEdicaoCI() {
    $('#txtConsumoUniCI').prop('disabled', true);
    $('.classCI').prop('disabled', true);
    $('#btnConfirmarCI').addClass('d-none');
    $('#btnDesistirCI').addClass('d-none');
    $('#btnIncluirCI').removeClass('d-none');
    $('#btnAlterarCI').removeClass('d-none');
    $('#btnExcluirCI').removeClass('d-none');
  }

  $('#btnIncluirCI').on('click', function () {
    $('#txtConsumoUniCI').prop('disabled', false);
    $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
    limpaCamposCI();
    habilitaEdicaoCI();
  })

  function limpaCamposCI() {
    $('#txtIdCI').val('0');
    $('#txtCodigoCI').val('');
    $('#txtCorCI').val('');
    $('#txtDepositoCI').val('');
    $('#txtLoteCI').val('');
    $('#txtAplicacaoCI').val('');
    $('#txtSetorCI').val('');
    $('#txtParteCI').val('');
    $('#txtUnidadeCI').val('');
    $('#txtConsumoCI').val('0');
    $('#txtConsumoOrigCI').val('0');
    $('#txtBaixadoCI').val('0');
    $('#txtConsumoUniCI').val('0');
  }

  $('#btnConfirmarCI').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const obj = {
        NUMERO: pegaChave('#txtOF'),
        ID_CONSUMO: $('#txtIdCI').val(),
        CODIGO: pegaChave('#txtCodigoCI'),
        DESCRICAO: pegaChave('#txtDescricaoCI'),
        UNIDADE: $('#txtUnidade').val(),
        COR: pegaChave('#txtCorCI'),
        DESC_COR: pegaDescricao('#txtCorCI'),
        QTDE: $('#txtConsumoUniCI').val(),
        CONSUMO: $('#txtConsumoCI').val(),
        BAIXADO: $('#txtBaixadoCI').val(),
        CONS_ORIG: $('#txtConsumoOrigCI').val(),
        APLICACAO: pegaChave('#txtAplicacaoCI'),
        DESC_APLICACAO: pegaDescricao('#txtAplicacaoCI'),
        SETOR: pegaChave('#txtSetorCI'),
        DESC_SETOR: pegaDescricao('#txtSetorCI'),
        DEPOSITO: pegaChave('#txtDepositoCI'),
        LOTE: $('#txtLoteCI').val(),
        PARTE: pegaChave('#txtParteCI')
      }

      await insereRegistroControleItens(obj);
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gravar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function insereRegistroControleItens(data) {
    let response = await requisicao("POST", `/Sisplan/baixaconsumos/V1/controleitens?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
      `&DATA=${encodeURIComponent(JSON.stringify(data))}`);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      let json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    await atualizaDadosControleItens();

    toastr.success("Dados gravados com sucesso!", "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 800,
      fadeOut: 800,
      onHidden() {
        desabilitaEdicaoCI();
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
  }

  $('#btnExcluirCI').on('click', async function () {
    msgAlerta('Deseja realmente excluir esse registro?', () => { }, () => { }, async () => { $.LoadingOverlay('show'); try { await excluirRegistroCI() } finally { $.LoadingOverlay('hide') } });
  })

  async function excluirRegistroCI() {
    try {
      const data = $('#tabelaControleItens').DataTable().row($('tr.selected')).data();

      if (data.length == 0) {
        msgErro('Nenhum registro selecionado. Impossível continuar.');
        return;
      }

      let response = await requisicao("DELETE", `/Sisplan/baixaconsumos/V1/controleitens?&CODUSUARIO=${getCookie('cod_usuario')}`,
        `&NUMERO=${pegaChave('#txtOF')}&CODIGO=${data.CODIGO}&COR=${data.COR}&CONSUMO=${String(data.CONSUMO).replace('.', ',')}&ID_CONSUMO=${data.ID_CONSUMO}&BAIXADO=${String(data.BAIXADO).replace('.', ',')}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let json = await response.json();
        msgErro(json.mensagem);
        return;
      }

      await atualizaDadosControleItens();

      toastr.success("Registro excluído com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 800,
        fadeOut: 800,
        onHidden() {
          desabilitaEdicaoCI();
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível excluir o registro: ${e}`);
    }
  }

  async function atualizaDadosControleItens() {
    const numero = pegaChave('#txtOF');
    const deposito = pegaChave('#txtDeposito');
    const qualidade = pegaChave('#txtQualidade');
    const parte = await formataListas($('#txtParte').val().toString());
    const aplicacao = await formataListas($('#txtAplicacao').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    try {
      if (numero != '' && deposito != '') {
        $.LoadingOverlay('show');

        await buscaDados(numero, qualidade, deposito, parte, aplicacao, grupo, subgrupo, setor);
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      criaTabelaControleItens($('#tabelaConsumos').DataTable().data().toArray());
      $.LoadingOverlay('hide');
    }
  }

  $('#btnFecharCI').on('click', function () {
    $('#modal-controle-itens').modal('hide');
  })
});