/* eslint-disable prefer-destructuring */
async function avancarPag() {
    if ($("#txtNome").val() == '') {
        $("#txtNome").val(' ');
    }
    if ($("#txtCNPJ").val() == '') {
        $("#txtCNPJ").val(' ');
    }
    if ($("#txtRG").val() == '') {
        $("#txtRG").val(' ');
    }
    if ($("#txtCNH").val() == '') {
        $("#txtCNH").val(' ');
    }
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const titulosTransportadora = [
        { title: "Codigo", data: "CODIGO" },
        { title: "Nome", data: "NOME" },
    ];

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let motorista = parametros[parametros.length - 1];

    let contaFs = 1;

    $("#checkAtivo").attr("checked", true);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADMOTORISTA', getCookie('usuario'), String(motorista));
        window.location.href = `${BASE_URI}/cadmotorista`;
    });

    $(document).ready(function () {

        let currentFs; let nextFs; let previousFs;
        let opacity;

        $(".next").click(function () {

            contaFs += 1;

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
            }

            $("#tabelaTransportadora").DataTable().columns.adjust().draw(false);
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
                txtBanco: {
                    required: true,
                },
                txtAgencia: {
                    required: true,
                },
                txtConta: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida.",
                },
                txtBanco: {
                    required: "Informe um banco válido."
                },
                txtAgencia: {
                    required: "Informe uma agência válida."
                },
                txtConta: {
                    required: "Informe uma conta válida."
                }

            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $(".previous").click(function () {

            contaFs -= 1;

            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });

        $(".submit").click(function () {
            return false;
        });
    });

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCNPJ").length > 11) {
        $("#txtCNPJ").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $("#txtCNPJ").on('change', function () {
        let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
        if (validaCNPJ != false) {
            $("#txtCNPJ").val(validaCNPJ);
        }
    });

    $('#txtCodigo').prop('disabled', true);

    $(`#btnCep`).pesquisa_serverside([`#txtCep`], ["CADCEP.CEP"], ["CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CIDADE.NOME", "CIDADE.COD_UF", "CADCEP.NOMCEP"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": null}', 'Pesquisa de CEP');
    $('#btnLimpaCep').on('click', function () { $('#txtCep').val('') })


    $('#txtAddTransportadora').autocompleta(4, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
    $('#btnAddTransportadora').pesquisa('#txtAddTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo", "nome"]}`, 'Pesquisa Transportadora', 'tabtran');
    $('#btnLimpaTransportadora').on('click', function () {
        $('#txtAddTransportadora').val('');
    });

    if (motorista != '' && motorista != 'create') {
        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        if (await liberarRegistro('CADMOTORISTA', motorista) == false) {
            window.location.href = '../cadmotorista';
        } else {
            carregaDados(motorista);
        }
    } else {
        $('#txtCodigo').val(await RetornaProximo("MOTORISTA", "MOTORISTA", "CODIGO", 6))
    }

    async function carregaDados(motorista) {
        try {
            $.LoadingOverlay("show");
            try {

                let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                if (validaCNPJ != false) {
                    $("#txtCNPJ").val(validaCNPJ);
                }

                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"MOTORISTA", 
                "camposSelect":["MOTORISTA.CODIGO, MOTORISTA.NOME, MOTORISTA.CPF, MOTORISTA.RG, MOTORISTA.CNH",
                                "MOTORISTA.VALIDADE_CNH, VALIDADE_TOX, MOTORISTA.TELEFONE, MOTORISTA.CELULAR, MOTORISTA.NEXTEL",
                                "MOTORISTA.CEP_END, CIDADE.NOME CIDADE_END, CIDADE.COD_UF ESTADO_END, MOTORISTA.ESTADO_RG, MOTORISTA.RUA_END", 
                                "MOTORISTA.REFERENCIA1, MOTORISTA.NUM_END, MOTORISTA.REFERENCIA2, MOTORISTA.OP_PROD_QUIMICO, MOTORISTA.ATIVO"], 
                                "leftJoin": [
                                    {"tabela": "CADCEP", "condicao": "MOTORISTA.CEP_END = CADCEP.CEP"},
                                    {"tabela": "CIDADE", "condicao": "CADCEP.CODMUN  = CIDADE.CODIGO"}], 
                "where": ["MOTORISTA.CODIGO = '${motorista}'"]}
                `, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtNome').val(jsonStr.RESULT[0][0].NOME);
                $('#txtCNPJ').val(jsonStr.RESULT[0][0].CPF);
                $('#txtRG').val(jsonStr.RESULT[0][0].RG);
                $('#txtCNH').val(jsonStr.RESULT[0][0].CNH);
                $('#dtValidadeCNH').val(jsonStr.RESULT[0][0].VALIDADE_CNH);
                $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                $('#dtValidadeTox').val(jsonStr.RESULT[0][0].VALIDADE_TOX);
                $('#txtNextel').val(jsonStr.RESULT[0][0].NEXTEL);
                $('#txtCelular').val(jsonStr.RESULT[0][0].CELULAR);
                insereValor('#txtCep', jsonStr.RESULT[0][0].CEP_END, jsonStr.RESULT[0][0].CIDADE_END)
                $('#txtEstado').val(jsonStr.RESULT[0][0].ESTADO_RG);
                $('#txtRua').val(jsonStr.RESULT[0][0].RUA_END);
                $('#txtNumero').val(jsonStr.RESULT[0][0].NUM_END);
                $('#txtReferencia1').val(jsonStr.RESULT[0][0].REFERENCIA1);
                $('#txtReferencia2').val(jsonStr.RESULT[0][0].REFERENCIA2);

                if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                    $('#checkAtivo').prop('checked', true);
                };

                preencheTabelaTransportadora(motorista)
            } catch (error) {
                console.error(error);
                msgAlerta(`Não foi possível buscar os dados do motorista.`);
            };
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function preencheTabelaTransportadora(pCodigo) {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MOTOR_TRANSP",
                  "camposSelect":["MOTOR_TRANSP.MOTORISTA, MOTOR_TRANSP.TRANSPORTADORA CODIGO, TABTRAN.NOME NOME"],
                  "leftJoin": [
                    {"tabela": "TABTRAN", "condicao": "TABTRAN.CODIGO = MOTOR_TRANSP.TRANSPORTADORA"}],
                  "where": ["MOTOR_TRANSP.MOTORISTA = '${pCodigo}'"]}`, null);

        if (!response) {
            return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return;
        }

        if (!jsonStr) {
            return
        }

        // let dados = jsonStr.RESULT[0].map(async (item) => {
        //     $('#tabelaTransportadora').DataTable().row.add({
        //         CODIGO: item.TRANSPORTADORA,
        //         NOME: (await buscaValor('TABTRAN', 'NOME', 'CODIGO', item.TRANSPORTADORA)).NOME
        //     }).draw(false);
        // });

        $('#tabelaTransportadora').DataTable({
            paging: false,
            filter: false,
            info: false,
            order: true,
            destroy: true,
            scrollY: '150px',
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columns: titulosTransportadora,
            data: jsonStr.RESULT[0],
            columnDefs: [
                {
                    targets: [0],
                    render: function (data, type, row) {
                        return '<div style="text-align:start;"> ' +
                            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
                            '      ' + data + ' ' +
                            '    </button> ' +
                            '    <div class="dropdown-menu"> ' +
                            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
                            '</div>';
                    },
                },
            ]
        });
    }

    $("#gravar").click(
        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                if (validaCNPJ != false) {
                    $("#txtCNPJ").val(validaCNPJ);
                }

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    if ($('#txtNome').val() === '') {
                        msgAlerta(`Necessário informar um nome.`);
                    }

                    if ($('#txtRG').val() === '') {
                        msgAlerta(`Necessário informar um RG.`);
                    }

                    if ($('#txtCNH').val() === '') {
                        msgAlerta(`Necessário informar uma CNH.`);
                    }

                    motorista = {
                        codigo: $('#txtCodigo').val(),
                        cnh: $('#txtCNH').val(),
                        cpf: $('#txtCNPJ').val(),
                        nome: $('#txtNome').val(),
                        rg: $('#txtRG').val(),
                        telefone: $('#txtTelefone').val(),
                        validadeCnh: !$('#dtValidadeCNH').val() ? '1899-01-01' : $('#dtValidadeCNH').val(),
                        celular: $('#txtCelular').val(),
                        cepEnd: pegaChave('#txtCep'),
                        estadoRg: $('#txtEstado').val(),
                        nextel: $('#txtNextel').val(),
                        referencia1: $('#txtReferencia1').val(),
                        referencia2: $('#txtReferencia2').val(),
                        ruaEnd: $('#txtRua').val(),
                        numEnd: $('#txtNumero').val(),
                        ativo: $('#checkAtivo').prop('checked') ? 'S' : 'N',
                        validadeTox: !$('#dtValidadeTox').val() ? '1899-01-01' : $('#dtValidadeTox').val(),
                        transportadora: buscaDadosTransportadora()
                    }

                    let response = await requisicao('POST', '/sisplan/cadastros/v1/motorista?', '', `JSON=${JSON.stringify(motorista)}`, 15000);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        $.LoadingOverlay("hide");
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Motorista: ${motorista.codigo}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/cadmotorista`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgAlerta(`Não foi possível gravar os dados do motorista`);
            }

        });

    $('#account').on('click', function () {
        if (motorista != 'create') {
            if (contaFs == 2) {
                $('#voltar2').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (motorista != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
        }
    });

    $('#btnAdicionarTransportadora').on('click', async function () {
        const obj = {
            CODIGO: pegaChave('#txtAddTransportadora'),
            NOME: pegaDescricao('#txtAddTransportadora'),
        }
        if (($.fn.DataTable.isDataTable('#tabelaTransportadora')) && ($("#tabelaTransportadora").DataTable().data().count() > 0)) {
            $('#tabelaTransportadora').DataTable().rows().data().toArray().filter((item) => {
                let codigoTabela = item.CODIGO ? item.CODIGO.match(/\d+/)[0] : null;
                let codigoInput = pegaChave('#txtAddTransportadora');
                if (codigoTabela == codigoInput) {
                    throw msgAlerta(`Não pode inserir duas vezes a mesma transportadora (${codigoInput}), verifique!`);
                }
            });

            if (!$('#txtAddTransportadora').val()) {
                throw msgAlerta('Código da transportadora não preenchido, impossível continuar!')
            }

            $('#tabelaTransportadora')
                .DataTable()
                .row
                .add(obj).draw(false);

            $('#txtAddTransportadora').val('');
            return;
        };

        $("#tabelaTransportadora").DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: titulosTransportadora,
            data: [obj],
            columnDefs: [
                {
                    targets: [0],
                    render: function (data, type, row) {
                        return '<div style="text-align:start;"> ' +
                            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
                            '      ' + data + ' ' +
                            '    </button> ' +
                            '    <div class="dropdown-menu"> ' +
                            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
                            '</div>';
                    },
                },
            ]
        });

        $('#txtAddTransportadora').val('');
    });

    function buscaDadosTransportadora() {
        let dados = [];
        if ($.fn.DataTable.isDataTable('#tabelaTransportadora')) {
            const tabelaTransportadora = $('#tabelaTransportadora').DataTable().rows().data().toArray();

            dados = tabelaTransportadora.map((item) => ({
                motorista: $('#txtCodigo').val(),
                transportadora: item.CODIGO ? item.CODIGO.match(/\d+/)[0] : '',
            }))
        }

        return dados
    }

    $('#tabelaTransportadora').on('click', '#btn-excluir', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabelaTransportadora").DataTable().row($(this).parents("tr"));
            data.remove().draw(false);
        });
    });


});