$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Código',
                    description: "Aqui, adicionamos o codigo do cilindro.",
                    position: 'top'
                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descricao',
                    description: 'Aqui, adicionamos o Descricao do cilindro.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#gravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o cadastro do cilindro.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    async function aplicaMascara() {
        $('.campoValor').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });

        $('.campoInteger').on('input', function (e) {
            let valorAtual = $(this).val();

            let novoValor = valorAtual.replace(/\D/g, '');

            if (novoValor != valorAtual) {
                $(this).val(novoValor);
            }
        });
    }

    aplicaMascara()
    await addFiltros()
    setarDataAtual('txtCadastro')
    setarDataAtual('txtData')

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let cilindro = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CILINDRO', getCookie('usuario'), cilindro);
        window.location.href = `${BASE_URI}/cilindro`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'CILINDRO', 'CODIGO', 6)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaCilindros').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        filter: false,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
        "autoWidth": true,
        "columns": [{
            "data": "SEQ"
        },
        {
            "data": "AREACOBERTURA"
        },
        {
            "data": "LARGURAEXTERNA"
        },
        {
            "data": "LARGURAUTIL"
        },
        {
            "data": "MESH"
        },
        ]
    });

    $('#txtQtdeCilindros').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            const qtdeCilindros = $(this).val()
            $('#tabelaCilindros').DataTable().clear().draw()

            for (let i = 0; i < qtdeCilindros; i++) {
                const obj = {
                    SEQ: i + 1,
                    AREACOBERTURA: `<input type="text" style="width: 10em;" maxlength="8" value="" class="input-default focus form-control campoValor txtAreaCoberturaTable" name="txtAreaCoberturaTable">`,
                    LARGURAEXTERNA: `<input type="text" style="width: 10em;" maxlength="8" value="" class="input-default focus form-control campoValor txtLarguraExternaTable" name="txtLarguraExternaTable">`,
                    LARGURAUTIL: `<input type="text" style="width: 10em;" maxlength="8" value="" class="input-default focus form-control campoValor txtLarguraUtilTable" name="txtLarguraUtilTable">`,
                    MESH: `<input type="text" style="width: 10em;" value="" class="input-default focus form-control campoInteger txtMeshTable" name="txtMeshTable">`
                }

                $('#tabelaCilindros').DataTable().row.add(obj).draw(false);
            }

            aplicaMascara()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
                txtCodigo: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe um nome válido."
                },
                txtCodigo: {
                    required: "Informe um codigo válido."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (cilindro != '' && cilindro != 'create') {

        if (await liberarRegistro('CILINDRO', cilindro) == false) {
            window.location.href = '../cilindro';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CILINDRO", 
                    "camposSelect":["CODIGO", "CODIGO2", "DESCRICAO", "ATIVO", "USA_FIO_TINTO",
                                    "DATA_CAD", "DT_TROCA_AGULHA", "DATA_DIG", "DATA_GRAV", "CLIENTE",
                                    "GRAVADORA", "ID_ESTAMPA", "ID_DEPOSITO", "ID_LOCAL", "MEDIDA_RAPORT",
                                    "AREA_COBERTURA", "CUSTO", "CUSTO_GRAV", "QTDE_CILINDRO", "DATA_DESGRAV",
                                    "OBS"], 
                    "where": ["CODIGO = '${cilindro}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtCodigo2').val(jsonStr.RESULT[0][0].CODIGO2);
                    $('#cbAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S');
                    $('#cbUtilizaFioTinto').prop('checked', jsonStr.RESULT[0][0].USA_FIO_TINTO == 'S');
                    $('#txtCadastro').val(jsonStr.RESULT[0][0].DATA_CAD);
                    $('#txtUltTrocaAgulha').val(jsonStr.RESULT[0][0].DT_TROCA_AGULHA);
                    $('#txtData').val(jsonStr.RESULT[0][0].DATA_DIG);
                    $('#txtGravado').val(jsonStr.RESULT[0][0].DATA_GRAV);
                    if (jsonStr.RESULT[0][0].CLIENTE) {
                        insereValor('#txtCliente', jsonStr.RESULT[0][0].CLIENTE, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].CLIENTE });
                    }
                    if (jsonStr.RESULT[0][0].GRAVADORA) {
                        insereValor('#txtGravadora', jsonStr.RESULT[0][0].GRAVADORA, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].GRAVADORA });
                    }
                    if (jsonStr.RESULT[0][0].ID_ESTAMPA) {
                        insereValor('#txtEstampa', jsonStr.RESULT[0][0].ID_ESTAMPA, { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'ID_COR', valorWhere: jsonStr.RESULT[0][0].ID_ESTAMPA });
                    }
                    if (jsonStr.RESULT[0][0].ID_DEPOSITO) {
                        insereValor('#txtDeposito', jsonStr.RESULT[0][0].ID_DEPOSITO, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'ID', valorWhere: jsonStr.RESULT[0][0].ID_DEPOSITO });
                    }
                    if (jsonStr.RESULT[0][0].ID_LOCAL) {
                        insereValor('#txtLocal', jsonStr.RESULT[0][0].ID_LOCAL, { tabela: 'CAD_LOC_ESTOQ', campoBusca: 'DESCRICAO', campoWhere: 'ID', valorWhere: jsonStr.RESULT[0][0].ID_LOCAL });
                    }
                    $('#txtMedidaRaport').val(jsonStr.RESULT[0][0].MEDIDA_RAPORT);
                    $('#txtAreaCobertura').val(jsonStr.RESULT[0][0].AREA_COBERTURA);
                    $('#txtCusto').val(jsonStr.RESULT[0][0].CUSTO);
                    $('#txtCustoGravacao').val(jsonStr.RESULT[0][0].CUSTO_GRAV);
                    $('#txtQtdeCilindros').val(jsonStr.RESULT[0][0].QTDE_CILINDRO);
                    $('#txtDesgravado').val(jsonStr.RESULT[0][0].DATA_DESGRAV);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);

                    await buscaClasses(cilindro)
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do país: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    async function buscaClasses(cilindro) {
        const pesquisaParam = {
            tabela: 'CILINDRO_ESTAMPA',
            camposSelect: ['SEQ_CILINDRO', 'AREA_COBERTURA', 'LARGURA_EXTERNA', 'LARGURA_UTIL', 'QTDE_MESH'],
            where: [`CODIGO_CILINDRO = '${cilindro}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));        

        jsonStr.map(item => {
            const obj = {
                SEQ: item.SEQ_CILINDRO,
                AREACOBERTURA: `<input type="text" style="width: 10em;" maxlength="8" value="${item.AREA_COBERTURA}" class="input-default focus form-control campoValor txtAreaCoberturaTable" name="txtAreaCoberturaTable">`,
                LARGURAEXTERNA: `<input type="text" style="width: 10em;" maxlength="8" value="${item.LARGURA_EXTERNA}" class="input-default focus form-control campoValor txtLarguraExternaTable" name="txtLarguraExternaTable">`,
                LARGURAUTIL: `<input type="text" style="width: 10em;" maxlength="8" value="${item.LARGURA_UTIL}" class="input-default focus form-control campoValor txtLarguraUtilTable" name="txtLarguraUtilTable">`,
                MESH: `<input type="text" style="width: 10em;" value="${item.QTDE_MESH}" class="input-default focus form-control campoInteger txtMeshTable" name="txtMeshTable">`
            }
    
            $('#tabelaCilindros').DataTable().row.add(obj).draw(false);
        });

        aplicaMascara()
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    const codigo = $('#txtCodigo').val()
                    const descricao = $('#txtDescricao').val()
                    const cadastro = $('#txtCadastro').val()
                    const qtdeCilindros = $('#txtQtdeCilindros').val()
                    const arrayCilindros = []

                    if (codigo == '') {
                        throw new Error('Código do Cilindro não informado, impossível Continuar!')
                    }

                    if (descricao == '') {
                        throw new Error('Descrição do Cilindro não informado, impossível Continuar!')
                    }
                    if (cadastro == '') {
                        throw new Error('Data de Cadastro do Cilindro não informado, impossível Continuar!')
                    }
                    if (qtdeCilindros == '' || qtdeCilindros <= 0) {
                        throw new Error('Qtde de Cilindros não informado, impossível Continuar!')
                    }

                    for (let i = 0; i < $('#tabelaCilindros').DataTable().data().toArray().length; i++) {
                        const item = $('#tabelaCilindros').DataTable().data().toArray()[i];
                        const sCodigo = await RetornaProximo('CODIGO', 'CILINDRO_ESTAMPA', 'CODIGO', 7)

                        const obj = {
                            CODIGO: sCodigo,
                            SEQ: item.SEQ,
                            AREACOBERTURA: $('.txtAreaCoberturaTable')[i].value,
                            LARGURAEXTERNA: $('.txtLarguraExternaTable')[i].value,
                            LARGURAUTIL: $('.txtLarguraUtilTable')[i].value,
                            MESH: $('.txtMeshTable')[i].value
                        }

                        arrayCilindros.push(obj)
                    }

                    let classe = {};

                    classe.CODIGO = codigo
                    classe.CODIGO2 = $('#txtCodigo2').val();
                    classe.DESCRICAO = descricao
                    classe.ATIVO = $('#cbAtivo').is(':checked') ? 'S' : 'N';
                    classe.USAFIOTINTO = $('#cbUtilizaFioTinto').is(':checked') ? 'S' : 'N';
                    classe.DATACAD = cadastro
                    classe.DTTROCAAGULHA = $('#txtUltTrocaAgulha').val() == '' ? '1200-01-01' : $('#txtUltTrocaAgulha').val();
                    classe.DATADIG = $('#txtData').val() == '' ? '1200-01-01' : $('#txtData').val();
                    classe.DATAGRAV = $('#txtGravado').val() == '' ? '1200-01-01' : $('#txtGravado').val();
                    classe.CLIENTE = pegaChave('#txtCliente');
                    classe.GRAVADORA = pegaChave('#txtGravadora');
                    classe.IDESTAMPA = $('#txtEstampa').val() == '' ? '-1' : pegaChave('#txtEstampa');
                    classe.IDDEPOSITO = $('#txtDeposito').val() == '' ? '-1' : pegaChave('#txtDeposito');
                    classe.IDLOCAL = $('#txtLocal').val() == '' ? '-1' : pegaChave('#txtLocal');
                    classe.MEDIDARAPORT = $('#txtMedidaRaport').val();
                    classe.AREACOBERTURA = $('#txtAreaCobertura').val();
                    classe.CUSTO = $('#txtCusto').val();
                    classe.CUSTOGRAV = $('#txtCustoGrav').val();
                    classe.QTDECILINDRO = qtdeCilindros;
                    classe.DATADESGRAV = $('#txtDesgravado').val() == '' ? '1200-01-01' : $('#txtDesgravado').val();
                    classe.OBS = $('#txtObs').val();
                    classe.CILINDROESTAMPA = arrayCilindros;


                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/cilindro?', `JSON=${encodeURIComponent(JSON.stringify(classe))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/cilindro`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    msgAlerta(error.message)
                    $.LoadingOverlay("hide");
                }
            }
        });

    async function addFiltros() {
        componenteFiltro('cliente', false, false)
        componenteFiltro('cliente', false, false, 'Gravadora')
        componenteFiltro('cor', false, false, 'Estampa')

        $('#txtDeposito').autocompleta(2, `JSON={ "tabela": "DEPOSITO", "camposSelect": ["ID CHAVE", "DESCRICAO DESCRICAO"], "where": [] }`);
        $('#btnDeposito').pesquisa('#txtDeposito', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "DEPOSITO", "camposSelect": ["ID", "DESCRICAO"] }`, `Pesquisa de Deposito`, 'DEPOSITO');
        $('#btnLimpaDeposito').on('click', function () {
            $('#txtDeposito').val('');
        });

        $('#txtEstampa').autocompleta(2, `JSON={ "tabela": "CADCOR", "camposSelect": ["ID_COR CHAVE", "DESCRICAO DESCRICAO"], "where": [] }`);
        $('#btnEstampa').pesquisa('#txtEstampa', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "CADCOR", "camposSelect": ["ID_COR ID", "DESCRICAO"] }`, `Pesquisa de Estampa`, 'CADCOR');
        $('#btnLimpaEstampa').on('click', function () {
            $('#txtEstampa').val('');
        });

        $('#txtLocal').autocompleta(2, `JSON={ "tabela": "CAD_LOC_ESTOQ", "camposSelect": ["ID CHAVE", "DESCRICAO DESCRICAO"], "where": [] }`);
        $('#btnLocal').pesquisa('#txtLocal', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "CAD_LOC_ESTOQ", "camposSelect": ["ID", "DESCRICAO"] }`, `Pesquisa de Local`, 'CAD_LOC_ESTOQ');
        $('#btnLimpaLocal').on('click', function () {
            $('#txtLocal').val('');
        });
    }
});