$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta das notas.',
                    position: 'right'
                }
            },
            {
                element: '#btn-novoPagar',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para dar entrada em uma nota fiscal.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaEntradaNF_wrapper',
                popover: {
                    title: 'Tabela NFs',
                    description: 'Aqui estão as notas fiscais.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});


$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("ENTRADA_NF");

    $('#txtNotaFiscalPesquisa').pesquisa_variosServerside(1, `{"tabela":"NOTA_ENTRA", 
                                                       "camposSelect":[ "NOTA_ENTRA.NOTAFISCAL", "ENTIDADE.NOME"], 
                                                       "leftJoin": [{"tabela": "ENTIDADE", "condicao": "NOTA_ENTRA.CREDOR = ENTIDADE.CODCLI"}], 
                                                       "where": ["NOTA_ENTRA.EMP_ID = '${getCookie('emp_id')}'"]}`, 'NOTAFISCAL', 'NOME');

    $('#txtFornecedorPesquisa').pesquisa_variosServerside(1, `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'CODCLI', 'NOME');

    $('#txtProdutoPesquisa').pesquisa_variosServerside(1, `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": []}`, 'CODIGO', 'DESCRICAO');

    $('#btnNotaFiscalPesquisa').pesquisa_serversideSel('#txtNotaFiscalPesquisa', `{"tabela": "NOTA_ENTRA",
          "camposSelect": ["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE", "NOTA_ENTRA.CREDOR", "ENTIDADE.NOME", "NOTA_ENTRA.EMP_ID"], 
          "leftJoin": [{"tabela": "ENTIDADE", "condicao": "NOTA_ENTRA.CREDOR = ENTIDADE.CODCLI"}], 
          "where": ["NOTA_ENTRA.EMP_ID='${getCookie('emp_id')}'"]}`, 'Pesquisa Notas de Entrada');

    $('#btnFornecedorPesquisa').pesquisa_serversideSel('#txtFornecedorPesquisa', `{"tabela": "ENTIDADE",
          "camposSelect": ["CODCLI", "NOME"], 
          "where": ["ATIVO = 'S'"]}`,
        'Pesquisa de Fornecedor');

    $('#btnProdutoPesquisa').pesquisa_serversideSel('#txtProdutoPesquisa', `{"tabela": "PRODUTO",
          "camposSelect": ["CODIGO", "DESCRICAO"], 
          "where": []}`,
        'Pesquisa de Produto');

    $('#btnLimpaNotaFiscalPesquisa').on('click', function () {
        $('#txtNotaFiscalPesquisa').empty().trigger('change')
    });

    $('#btnLimpaFornecedorPesquisa').on('click', function () {
        $('#txtFornecedorPesquisa').empty().trigger('change')
    });

    $('#btnLimpaProdutoPesquisa').on('click', function () {
        $('#txtProdutoPesquisa').empty().trigger('change')
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtNotaFiscalPesquisa').empty().trigger('change');
        $('#txtFornecedorPesquisa').empty().trigger('change');
        $('#txtProdutoPesquisa').empty().trigger('change');
        $('#txtDataEmissaoDe').val('1200-01-01');
        $('#txtDataEmissaoAte').val('2500-12-01');
        $('#txtDataEntradaDe').val('1200-01-01');
        $('#txtDataEntradaAte').val('2500-12-01');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btn-novoPagar').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "entrada_nf/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaPrincipal').dblclick('tr', async function () {
        $('#modal-movimentacao').modal('show');
    });

    const FormatoDtNovo = 'DD/MM/YYYY';

    async function buscaNota() {
        let urlRequisicao = `/sisplan/entradanf/v1/EntradaNF?`;
        let notafiscal = await formataListas($('#txtNotaFiscalPesquisa').val().toString());
        let credor = await formataListas($('#txtFornecedorPesquisa').val().toString());
        let produto = await formataListas($('#txtProdutoPesquisa').val().toString());
        let dtemissaode = $('#txtDataEmissaoDe').val();
        let dtemissaoate = $('#txtDataEmissaoAte').val();
        let dtentradade = $('#txtDataEntradaDe').val();
        let dtentradaate = $('#txtDataEntradaAte').val();
        let paramsRequisicao = `DT_EMISSAOI=${dtemissaode}&DT_EMISSAOF=${dtemissaoate}&DT_ENTRADAI=${dtentradade}&DT_ENTRADAF=${dtentradaate}&NOTAFISCAL=${notafiscal}&FORNECEDOR=${credor}&CODIGO=${produto}`;

        try {
            let response = await requisicao('GET', urlRequisicao, paramsRequisicao, null, 10000);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let jsonStr = await response.json();
            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        }
    }

    function retornaBotaoOpcoes(data) {
        let retorno = '<div style="text-align:left;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu" style="min-width: 2rem;"> ' +
            '    <a id="btn-editar" class="dropdown-item" href="#">Editar</a>' +
            '    <a id="btn-excluir" class="dropdown-item" href="#">Excluir</a>' +
            `    <a id="btn-imprimir" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout EntradaNF.FR3"' : 'title="Imprimir"'} class="dropdown-item" href="#">Imprimir</a>` +
            '    </div>' +
            '  </div>' +
            '</div>';

        return retorno
    };

    $('#tabelaEntradaNF').on('click', 'td', function () {
        selecionarLinhaTabela('#tabelaEntradaNF', 'checkEntrada', this);
    });

    $('#btnConsultar').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let jsonStr = await buscaNota();

                for (let i = 0; i < jsonStr.length; i++) {
                    jsonStr[i].DT_ORDENACAO = jsonStr[i].DT_EMISSAO.replaceAll('-', '');
                }

                let table = $('#tabelaEntradaNF').DataTable({
                    destroy: true,
                    "language": {
                        "sEmptyTable": "Nenhum registro encontrado",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhum registro encontrado",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }
                    },
                    "order": [[0, "desc"]],
                    "autoWidth": true,
                    "data": jsonStr,
                    "columns": [
                        {
                            "data": 'DT_ORDENACAO'
                        },
                        {
                            "data": 'NOTAFISCAL'
                        },
                        {
                            "data": 'CREDOR'
                        },
                        {
                            "data": 'NOME'
                        },
                        {
                            "data": 'DT_EMISSAO'
                        },
                        {
                            "data": 'DT_ENTRADA'
                        },
                        {
                            "data": 'SERIE'
                        },
                        {
                            "data": 'TIPO'
                        },
                        {
                            "data": 'LANCAMENTO'
                        },
                    ],
                    "columnDefs": [
                        {
                            "visible": false,
                            "targets": 0
                        },
                        {
                            "type": 'date-br',
                            "render": function (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            },
                            "targets": 4,
                        },
                        {
                            "type": 'date-br',
                            "render": function (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            },
                            "targets": 5,
                        },
                        // {
                        //     "render": $.fn.dataTable.render.moment(FormatoDtNovo),
                        //     "targets": 4,
                        // },
                        // {
                        //     "render": $.fn.dataTable.render.moment(FormatoDtNovo),
                        //     "targets": 5,
                        // },
                        {
                            targets: [1], render: function (data, type, row) {
                                return retornaBotaoOpcoes(data);
                            }
                        }
                    ]
                });

                $('#tabelaEntradaNF').on('click', '#btn-editar', async function () {
                    if (permissaoUsuarioLogado.ALTERA == 'S') {
                        try {
                            let data = table.row($(this).parents('tr')).data();

                            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"pagto", 
                        "camposSelect":["pagto.num_ap"], 
                        "innerJoin": [{"tabela": "pagto1", 
                        "condicao": "(pagto1.num_ap = pagto.num_ap) and (pagto1.docto = pagto.dupli)"}], 
                        "where": ["pagto.lancamento = ${data.LANCAMENTO}"], "limit": 10000}`, null);

                            if (!response) {
                                $.LoadingOverlay("hide");
                                return;
                            }

                            let jsonString = await response.json();
                            if (response.status != 200) {
                                $.LoadingOverlay("hide");
                                msgErro(jsonString.RESULT[0].mensagem);
                                return;
                            }

                            if (jsonString.RESULT[0].length == 0) {
                                nota = {};
                                nota.NOTAFISCAL = data.NOTAFISCAL;
                                nota.TIPO = data.TIPO;
                                nota.SERIE = data.SERIE;
                                nota.CREDOR = data.CREDOR;

                                window.location.href = `entrada_nf/${btoa(JSON.stringify(nota))}`;
                            } else {
                                msgAlerta('Duplicatas desta nota contém baixas, caso necessária alteração, favor estornar baixas.');
                            }
                        } catch (error) {
                            console.error(error);
                        }

                    } else {
                        msgAlertaSemConfirmacao("Sem permissão para alterar!");
                    }
                });

            } catch (error) {
                console.error(error);
            }

        } finally {
            $('#modal-filtros').modal('hide');
            $.LoadingOverlay('hide');
        }
    });

    $('#tabelaEntradaNF').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            try {
                $.LoadingOverlay('show');
                let table = $('#tabelaEntradaNF').DataTable();
                let data = table.row($(this).parents('tr')).data();
                data.EXCLUSAO = true;
                try {
                    let response = await requisicao('DELETE', '/Sisplan/EntradaNF/v1/EntradaNF?', `JSON=${encodeURIComponent(JSON.stringify(data))}&CHAVE_NFE=${data.CHAVE_NFE}`, null);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    toastr.success(
                        'Nota Fiscal excluida com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    console.error(error);
                    msgErro(`Erro ao excluir o registro.${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
                $('#btnConsultar').trigger('click');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $('#tabelaEntradaNF').on('click', '#btn-imprimir', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const data = $('#tabelaEntradaNF').DataTable().row($(this).parents('tr')).data();
                const lancamentoNF = data.LANCAMENTO;
                const serieNF = data.SERIE;
                const credorNF = data.CREDOR;
                const notafiscalNF = data.NOTAFISCAL;
                const dt_emissaoNF = data.DT_EMISSAO;
                const dt_entradaNF = data.DT_ENTRADA;
                let paramsRequisicao = `LANCAMENTO=${lancamentoNF}&SERIE=${serieNF}&DT_EMISSAO=${dt_emissaoNF}&DT_ENTRADA=${dt_entradaNF}&NOTAFISCAL=${notafiscalNF}&CREDOR=${credorNF}`;
                const url = `/sisplan/impressao/v1/entradanfe?${paramsRequisicao}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('EntradaNF');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, '');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    retornaHintRelatorio('btnImprimeAcessoNfe', 'relAcessoEntradaNfe')

    $('#btnImprimeAcessoNfe').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                let notafiscal = await formataListas($('#txtNotaFiscalPesquisa').val().toString());
                let credor = await formataListas($('#txtFornecedorPesquisa').val().toString());
                let produto = await formataListas($('#txtProdutoPesquisa').val().toString());
                let dtemissaode = $('#txtDataEmissaoDe').val();
                let dtemissaoate = $('#txtDataEmissaoAte').val();
                let dtentradade = $('#txtDataEntradaDe').val();
                let dtentradaate = $('#txtDataEntradaAte').val();
                let paramsRequisicao = `DT_EMISSAOI=${dtemissaode}&DT_EMISSAOF=${dtemissaoate}&DT_ENTRADAI=${dtentradade}&DT_ENTRADAF=${dtentradaate}&NOTAFISCAL=${notafiscal}&FORNECEDOR=${credor}&CODIGO=${produto}`;
                const url = `/sisplan/impressao/v1/imprimirrelacessoentradanfe?${paramsRequisicao}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('relAcessoEntradaNfe');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'relAcessoEntradaNfe');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnConsultar').trigger('click');
});