$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let data = parametros[parametros.length - 1];
  if (data != "create") {
    $('#txtId').val(data);
    await buscaDados(data);
  }

  $('#btnToken').on('click', async function () {
    try {
      const session = $('#txtNomeDispositivo').val();
      const secretKey = 'SECURETOKENBYSISPLANSISTEMAS';
      const response = await requisicao_wpp('POST', `/api/${session}/${secretKey}/generate-token`, '');
      if (!response) {
        return;
      }
      if (![200, 201].includes(response.status)) {
        msgErro('Erro ao gerar token, tente novamente.');
        return;
      }
      const jsonStr = await response.json();
      $('#txtToken').val(jsonStr.token);
    } catch (error) {
      msgErro('Erro ao gerar token, tente novamente.');
      console.error(error);
    }
  });

  $('#btnConectar').on('click', async function () {
    try {
      const session = $('#txtNomeDispositivo').val();
      const token = $('#txtToken').val();
      const response = await requisicao_wpp('POST', `/api/${session}/start-session`, '', JSON.stringify({
        webhook: null,
        waitQrCode: true
      }), null, token);
      if (!response) {
        return;
      }
      if (![200, 201].includes(response.status)) {
        msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
        return;
      }
      const jsonStr = await response.json();
      if (jsonStr.status == 'CONNECTED') {
        msgAlerta('Dispositivo já conectado.');
        return;
      }
      if (jsonStr.qrcode && jsonStr.qrcode != '' && jsonStr.qrcode != 'null' && jsonStr.qrcode != null) {
        const qrCode = jsonStr.qrcode.indexOf('data:image') >= 0 ? jsonStr.qrcode : 'data:image/png;base64,'+jsonStr.qrcode; 
        $('#qrcode').attr('src', `${qrCode}`);
        $('#qrcode').removeClass('d-none');
      } else {
        msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
        return;
      }
    } catch (error) {
      msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
      console.error(error);
    }
  });

  $('#btnTesteWpp').on('click', async function () {
    try {
      const sessao = $('#txtNomeDispositivo').val();
      const token = $('#txtToken').val();
      const response = await requisicao_wpp('GET', `/api/${sessao}/check-connection-session`, '', '', null, token);

      if (!response) {
        msgAlerta('Para testar o envio de mensagens pelo whatsapp precisa ler o QRCode primeiro! Favor tentar novamente.');
        return;
      };

      if (![200, 201].includes(response.status)) {
        msgAlerta('Para testar o envio de mensagens pelo whatsapp precisa ler o QRCode primeiro! Favor tentar novamente.');
        return;
      };

      const jsonStr = await response.json();

      if (jsonStr.message != 'Connected') {
        msgAlerta('Para testar o envio de mensagens pelo whatsapp precisa ler o QRCode primeiro! Favor tentar novamente.');
        return;
      };

      $('#modalTestaEnvio').modal('show');

      $('#btn-limpa-numero').on('click', function () {
        $('#txtNumeroEnvio').val('');
      });

    } catch (error) {
      msgAlerta('Não foi possível fazer o teste de conexão, tente novamente.');
      console.error(error);
    }
  });

  $('#btnEnviaTeste').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      let numero = $('#txtNumeroEnvio').val();
      let existe55 = false;

      const sessao = $('#txtNomeDispositivo').val();
      const token = $('#txtToken').val();

      if (numero.indexOf('55') != -1) {
        existe55 = true;
      } else {
        numero = '55' + numero;
      }

      const mensagemObjeto = {
        phone: numero,
        message: 'Teste feito com sucesso!',
        isGroup: false
      };

      const response_envio = await requisicao_wpp('POST', `/api/${sessao}/send-message`, '', JSON.stringify(mensagemObjeto), null, token);

      if (!response_envio) {
        msgAlerta('Erro ao testar o envio de mensagem via WhatsApp, tente novamente ou reconecte o aparalho!');
        return;
      };

      if (![200, 201].includes(response_envio.status)) {
        msgAlerta('Erro ao testar o envio de mensagem via WhatsApp, verifique se o número realmente existe e tente novamente! Caso erro persistir, reconecte o aparelho.');
        return;
      };

      const jsonStr = await response_envio.json();

      if (jsonStr.status != 'success') {
        msgAlerta('Erro ao testar o envio de mensagem via WhatsApp, verifique se o número realmente existe e tente novamente! Caso erro persistir, reconecte o aparelho.');
        return;
      };

      msgSucesso('Envio de mensagem de teste feito com sucesso! WhatsApp ativo e funcionando...');

      $('#modalTestaEnvio').modal('hide');

      $('#txtNumeroEnvio').val('');
    } catch (error) {
      msgAlerta('Não foi possível fazer o envio de teste, tente novamente.');

      $('#txtNumeroEnvio').val('');

      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    };
  });

  async function buscaDados(id) {
    try {
      $.LoadingOverlay('show');
      const pesquisa = {
        tabela: "WHATSAPPWEB",
        camposSelect: ["ID", "NOME", "TELEFONE", "TOKEN"],
        where: [`ID = '${id}'`]
      }

      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON=${JSON.stringify(pesquisa)}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      const dados = jsonStr.RESULT[0][0];
      $('#txtId').val(dados.ID);
      $('#txtNomeDispositivo').val(dados.NOME);
      $('#txtTelefone').val(dados.TELEFONE);
      $('#txtToken').val(dados.TOKEN);

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function validaGravacao() {
    const bNomeValido = $('#txtNomeDispositivo').val() != '';
    const bTelefone = $('#txtTelefone').val() != '';
    const bToken = $('#txtToken').val() != '';

    return bNomeValido && bTelefone && bToken;
  }

  async function gravaDados() {
    const url = `/sisplan/config_whatsapp/v1/salvar?`;
    if (!validaGravacao()) {
      msgAlerta('Campos não preenchidos, verifique.');
      return;
    }
    msgAlerta(`Tem certeza que deseja gravar as Configurações de WhatsApp?`, async function () {
      try {
        try {
          $.LoadingOverlay("show");
          const objeto = {
            id: $('#txtId').val() != '' ? $('#txtId').val() : 99999,
            nome: $('#txtNomeDispositivo').val(),
            telefone: $('#txtTelefone').val(),
            token: $('#txtToken').val()
          }
          const response = await requisicao("POST", url, "", JSON.stringify(objeto), 120000);

          if (!response) {
            msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
            return;
          }

          // let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
            return;
          }
          toastr
            .success("Gravação efetuada com sucesso", "Confirmação", {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              async onHidden() {
                window.location.href = `${BASE_URI}/config_whatsapp`;
              },
            })
            .css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px",
            });

        } catch (error) {
          console.error(error);
          msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
          return;
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    });
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/config_whatsapp`;
  });

  $('#btnGravar').on('click', function () {
    gravaDados();
  });

  $('#txtNomeDispositivo').focus();


});
