$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let data = parametros[parametros.length - 1];
  let tipo = '';

  if (!await usuarioMasterOuSupervisor()) {
    $('#divLancManuais').hide();
  };

  $('#msformPagar').validate({
    debug: false,
    ignore: "",
    rules: {
      txtFornecedorPagar: {
        required: true,
      },
      txtClasseGerencialPagar: {
        required: true,
      },
      txtHistoricoPagar: {
        required: true,
      },
      txtSituacaoPagar: {
        required: true,
      },
      txtBancoPagar: {
        required: true,
      },
      txtContaPagar: {
        required: true,
      }
    },
    messages: {
      txtFornecedorPagar: {
        required: "Informe um fornecedor.",
      },
      txtClasseGerencialPagar: {
        required: "Informe uma classe gerencial."
      },
      txtHistoricoPagar: {
        required: "Informe um histórico."
      },
      txtSituacaoPagar: {
        required: "Informe uma situação."
      },
      txtBancoPagar: {
        required: "Informe um banco."
      },
      txtContaPagar: {
        required: "Informe uma conta."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  const listaMoedasEmpresa = await retornaMoedasEmpresa();
  const bUsaECF = await CopiaParametro('VENDA', 8);
  const bLancaPagarSaida = await CopiaParametro('VENDA', 88) == '1';

  pesquisaLancaPagar();

  if (data != "create") {
    data = atob(data);
    const dados = JSON.parse(data);
    $('#txtPeriodo').val(dados.periodo);
    insereValor('#txtCaixa', dados.caixa, dados.desc_caixa);
    insereValor('#txtUsuario', dados.usuario, dados.nome);
    $('#txtCaixa').prop('disabled', 'disabled');
    $('#txtPeriodo').prop('disabled', 'disabled');
    $('#btnCaixa').prop('disabled', 'disabled');
    $('#btn-Limpa-caixa').prop('disabled', 'disabled');
    if (($('#txtCaixa').val() != '') && ($('#txtPeriodo').val() != '')) {
      await buscaMoedasData();
    }
    habilitaSangriSuprimento(true)
  } else {
    setarDataAtual('txtPeriodo');
    preencheUsuarioLogado();
    $('#txtCaixa').prop('disabled', false);
    $('#txtPeriodo').prop('disabled', false);
  }

  await retornaMoedas();

  $('#txtCaixa').autocompleta(1, `JSON={ 
    "tabela":"CAIXA_LOJA", 
    "camposSelect":[ "CAIXA_LOJA.codigo chave", "CAIXA_LOJA.descricao"], 
    "innerjoin": [{"tabela" : "VENDA_CAIXA", "condicao" : "VENDA_CAIXA.NRCAIXA = CAIXA_LOJA.CODIGO"}],
    "where": ["VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'"]
  }`);

  $('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={
    "tabela":"CAIXA_LOJA", 
    "camposSelect":[ "CAIXA_LOJA.CODIGO", "CAIXA_LOJA.DESCRICAO"], 
    "innerjoin": [{"tabela" : "VENDA_CAIXA", "condicao" : "VENDA_CAIXA.NRCAIXA = CAIXA_LOJA.CODIGO"}], 
    "where": ["CAIXA_LOJA.CODIGO <> '9999'", "VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'"]
  }`, 'Pesquisa Caixa', 'CAIXA_LOJA');

  $('#btn-Limpa-caixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#btnSangria').on('click', async function () {
    $('#txtSangria').val('0.0');
    const moeda = await buscaMoedaDinheiro();
    insereValor('#txtMoedaSangria', moeda.CODMOE, moeda.DESCRICAO);
    $("#txtObservacaoSangria").val("");
  });

  $('#btnDesistirPagar').on('click', async function () {
    $('#modalPagarSaidaManual').modal('hide');
  });

  $('#btnSuprimento').on('click', async function () {
    $('#txtSuprimento').val('0.0');
    const moeda = await buscaMoedaDinheiro();
    insereValor('#txtMoedaSuprimento', moeda.CODMOE, moeda.DESCRICAO);
  });

  $('#txtSuprimento').maskMoney({
    decimal: ',',
    thousands: '.',
    precision: 2,
    allowZero: true,
    defaultZero: true,
    reversed: true
  });

  $('#txtSangria').maskMoney({
    decimal: ',',
    thousands: '.',
    precision: 2,
    allowZero: true,
    defaultZero: true
  });

  $('#btnConfirmaSangria').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const valor = parseFloat($('#txtSangria').val().replace('.', '').replace(',', '.'));

        if ($('#txtMoedaSangria').val() == '') {
          msgAlerta('Moeda não pode estar vazia!');
          return;
        }

        if (!valor > 0) {
          msgAlerta('Valor da Sangria precisa ser maior que 0');
          return;
        }

        // if (bLancaPagarSaida) {
        //   tipo = 'sangria';
        //   await carregaValoresPadroes();
        //   $('#modalPagarSaidaManual').modal('show');
        // } else {
        await lancaSangria();
        // }
      } catch (error) {
        msgErro('Não foi possivel cadastrar a sangria');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function lancaSangria() {
    const caixa = pegaChave('#txtCaixa');
    const valor = parseFloat($('#txtSangria').val().replace('.', '').replace(',', '.'));
    const data = $('#txtPeriodo').val();
    const observacao = $("#txtObservacaoSangria").val();

    if ((bUsaECF != 0) && (valor > 0)) {
      if (await SangriaCupom(String(valor).replaceAll('.', ','))) {
        await InsereSangriaCaixa(valor, data, caixa, observacao);
      } else {
        msgErro('Não foi possível realizar Sangria na impressora fiscal.');
        return;
      }
    } else {
      if (valor > 0) {
        await InsereSangriaCaixa(valor, data, caixa, observacao);
      } else {
        msgAlerta('Valor da Sangria precisa ser maior que 0')
      }
    }
    await buscaMoedasData();
  }

  //retirado replace pois ao confirmar a sangria, dizia que o valor tinha que ser acima de 0

  $('#btnConfirmaSuprimento').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const caixa = pegaChave('#txtCaixa');
        const valor = parseFloat($('#txtSuprimento').val().replace('.', '').replace(',', '.'));
        const data = $('#txtPeriodo').val();

        if ($('#txtMoedaSuprimento').val() == '') {
          msgAlerta('Moeda não pode estar vazia!');
          return;
        }

        if ((bUsaECF != 0) && (valor > 0)) {
          if (await SuprimentoCupom(String(valor).replaceAll('.', ','))) {
            await InsereSuprimentoCaixa(valor, data, caixa);
          } else {
            msgErro('Não foi possível realizar Suprimento na impressora fiscal.');
            return;
          }
        } else {
          if (valor > 0) {
            await InsereSuprimentoCaixa(valor, data, caixa);
          } else {
            msgAlerta('Valor do Suprimento precisa ser maior que 0.');
          }
        }
        await buscaMoedasData();
      } catch (error) {
        msgErro('Não foi possivel cadastrar o Suprimento');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtValor').maskMoney({
    decimal: ',',
    thousands: '.',
    precision: 2,
    allowZero: true,
    defaultZero: true
  });

  function preencheUsuarioLogado() {
    const codUsuario = getCookie('cod_usuario');
    const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
    insereValor('#txtUsuario', codUsuario, nomeUsuario);
  }

  async function buscaMoedasData() {
    try {
      $.LoadingOverlay('show');
      const data = $('#txtPeriodo').val();
      const caixa = pegaChave('#txtCaixa');
      const empId = getCookie('emp_id');
      const moedasMovimentacao = await retornaMoedasMovimentacoes();
      const pesquisa = {
        tabela: "MOEDA",
        camposSelect: ["MOEDA.CODMOE MOEDA", "MOEDA.DESCRICAO",
          `(SELECT CONF_CAIXA.VALOR 
          FROM [CONF_CAIXA] CONF_CAIXA 
          WHERE CONF_CAIXA.CODMOE = MOEDA.CODMOE 
          AND CONF_CAIXA.PERIODO = '${data}'
          AND CONF_CAIXA.EMP_ID = ${empId}
          AND CONF_CAIXA.CAIXA = '${caixa}') VALOR_CONTAGEM`
        ],
        where: [],
        orderBy: ["MOEDA.CODMOE", "MOEDA.DESCRICAO"]
      }

      if (moedasMovimentacao && moedasMovimentacao.length > 0) {
        pesquisa.where.push(`MOEDA.CODMOE IN (${moedasMovimentacao})`);
      }

      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON=${JSON.stringify(pesquisa)}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaMoedas").DataTable({
        destroy: true,
        lengthChange: false,
        filter: false,
        order: false,
        paginate: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "MOEDA",
          },
          {
            data: "DESCRICAO",
          },
          {
            data: "VALOR_CONTAGEM",
            render: function (data, type, row, meta) {
              return '<div class="group-default">' +
                '<div class="relative">' +
                '<input type="text" id="val_contagem_' + [meta.row] + '_row_' + [meta.col] +
                `" class="input-default focus form-control validate valContagem" value="${row.VALOR_CONTAGEM}"> ` +
                '</div>' +
                '</div>';
            }
          }
        ]
      });

      $(".valContagem").inputmask("numeric", {
        min: 0,
        max: 99999999,
        positionCaretOnClick: "select"
      });

      $($('.valContagem')[0]).focus();

      await buscaDados();

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#txtCaixa, #txtPeriodo').on('blur', async function () {
    habilitaSangriSuprimento(false);
    if (($('#txtCaixa').val() != '') && ($('#txtPeriodo').val() != '')) {
      await buscaMoedasData();
      habilitaSangriSuprimento(true);
    }
  });

  $("#txtTroco").inputmask("numeric", {
    min: 0,
    max: 99999999,
    positionCaretOnClick: "select"
  });

  $('#btnConfirmarPagar').click(async function () {
    $('#btnConfirmarPagar').prop('disabled', true);
    try {
      let validator = $("#msformPagar").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        if (tipo == 'sangria') {
          await lancaSangria();
          $('#modalPagarSaidaManual').modal('hide');
        } else if (tipo == 'lancamentoManual') {
          await lancamentoManual(pegaChave('#txtCaixa'));
          $('#modalPagarSaidaManual').modal('hide');
        }
      } else {
        msgAlerta('Necessário informar os campos obrigatórios.');
      }
    } finally {
      $('#btnConfirmarPagar').prop('disabled', false);
    }
  });

  $('#btnIncluir').click(async function () {
    const caixa = pegaChave('#txtCaixa');
    if (caixa == "") {
      msgAlerta("Caixa não informado");
      return;
    }

    if ((bLancaPagarSaida) && ($('#rgOperacao').val() == 'S')) {
      tipo = 'lancamentoManual';
      await carregaValoresPadroes();
      $('#modalPagarSaidaManual').modal('show');
    } else {
      await lancamentoManual(caixa);
    }
  });

  async function lancamentoManual(caixa) {
    try {
      $.LoadingOverlay("show");
      $('#txtValor').val();
      let obj = {
        moeda: Number($('#rgMoeda').val()),
        valor: parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')),
        descricao: `${$('#txtObs').val()}`,
        tipo: `${$('#rgOperacao').val()}`,
        nrcaixa: caixa,
        data: $('#txtPeriodo').val() + 'T00:00:00Z',
        dt_fechamento: $('#txtPeriodo').val() + 'T00:00:00Z',
        duplicata: '',
        lancamento: 0,
        manual: 'S',
      }

      const objPagar = {
        VALOR: parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')),
        VALOR_ORIG: parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')),
        STATUS: 'DUPL',
        OBS: `${$('#txtObs').val()}. AP gerada através de lançamento manual do caixa ${caixa}`,
        EMP_ID: getCookie('emp_id'),
        CODCRE: pegaChave('#txtFornecedorPagar'),
        SITUACAO: pegaChave('#txtSituacaoPagar'),
        NUM_OS: pegaChave('#txtClasseGerencialPagar'),
        BANCO: pegaChave('#txtBancoPagar'),
        CONTA: pegaChave('#txtContaPagar'),
        HISTORICO: pegaChave('#txtHistoricoPagar'),
        MOEDA: Number($('#rgMoeda').val())
      };

      // if ((obj.tipo == 'S') && (!validaValorSaida(obj.moeda, obj.valor))) {
      //   msgAlerta('Valor de saída é maior que o saldo para essa moeda, impossível continuar.');  
      //   $.LoadingOverlay('hide'); 
      //   return;
      // }

      const jsonVendas = encodeURIComponent(JSON.stringify(obj));
      const jsonPagar = bLancaPagarSaida ? encodeURIComponent(JSON.stringify(objPagar)) : '';

      let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
        `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtPeriodo').val()}&MANUAL=True`, `JSON=${jsonVendas}&JSONPAGAR=${jsonPagar}`);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $('#txtObs').val('');
      $('#txtValor').val('');
      $('#rgMoeda').val('3');
      $('#rgOperacao').val('E');

      toastr.success(
        'Lançamento manual gravado com sucesso',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden: async function () {
          await buscaMoedasData();
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

      await buscaMoedasData();

      $.LoadingOverlay("hide");
    } catch (error) {
      console.log(error);
      $.LoadingOverlay("hide");
    }
  }

  function validaGravacao() {
    const bPeriodoValido = $('#txtPeriodo').val() != '';
    const bCaixaValido = pegaChave('#txtCaixa') != '';
    const bUsuario = pegaChave('#txtUsuario') != '';
    const valoresInformados = $('.valContagem').map((idx, comp) => {
      return +$($('.valContagem')[idx]).val()
    })
      .toArray()
      .filter(valor => valor > 0).length > 0

    return bPeriodoValido && bCaixaValido && bUsuario && valoresInformados;
  }

  async function retornaMoedasMovimentacoes() {
    try {
      const data = $('#txtPeriodo').val();
      const caixa = pegaChave('#txtCaixa');
      const response = await requisicao("GET", "/Sisplan/vendas/V1/retornamovimentacoes?", `caixa=${caixa}&data=${data}`, null);
      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }
      return jsonStr.map(dados => dados.CODMOE);
    } catch (error) {
      console.error(error);
    }
  }

  function montaObjeto() {
    const dados = $('#tabelaMoedas').DataTable().data().toArray();
    const empId = getCookie('emp_id');
    const codUsuario = getCookie('cod_usuario');
    const objeto = dados.map((dado, index) => {
      if ($($('.valContagem')[index]).val() != '') {
        return {
          CAIXA: pegaChave('#txtCaixa'),
          CODMOE: dado.MOEDA,
          EMP_ID: empId,
          PERIODO: $('#txtPeriodo').val(),
          STATUS: 'A',
          USUARIO: codUsuario,
          VALOR: +$($('.valContagem')[index]).val()
        }
      }
    }).filter(dado => dado);
    return {
      listaConfCaixa: objeto
    }
  }

  async function gravaDados() {
    const url = `/sisplan/conf_caixa/v1/salvar?`;
    if (!validaGravacao()) {
      msgAlerta('Campos não preenchidos, verifique.');
      return;
    }
    msgAlerta(`Tem certeza que deseja gravar a contagem de caixa?`, async function () {
      try {
        try {
          $.LoadingOverlay("show");
          if (await fecharCaixa()) {
            const objeto = montaObjeto();
            const response = await requisicao("POST", url, "", JSON.stringify(objeto), 120000);

            if (!response) {
              msgErro("Não foi possível gravar a contagem de caixa, tente novamente.");
              return;
            }

            // let jsonStr = await response.json();
            if (response.status != 200) {
              msgErro("Não foi possível gravar a contagem de caixa, tente novamente.");
              return;
            }
            toastr
              .success("Gravação efetuada com sucesso", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                  error: "alert-error",
                  info: "alert-info",
                  success: "alert-success",
                  warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                  window.location.href = `${BASE_URI}/contagem_caixa`;
                },
              })
              .css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
              });
          }

        } catch (error) {
          console.error(error);
          msgErro("Não foi possível gravar a contagem de caixa, tente novamente.");
          return;
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    });
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/contagem_caixa`;
  });

  $('#btnGravar').on('click', async function () {
    await gravaDados();
  });

  $('#txtPeriodo').focus();

  async function retornaMoedas() {
    try {
      $.LoadingOverlay("show");
      var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
        'JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "orderBy": ["CODMOE"]}', null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr['RESULT'][0].mensagem);
        return;
      }

      for (const moeda of jsonStr['RESULT'][0]) {
        var opcao = new Option(`${moeda.CODMOE + ' - ' + moeda.DESCRICAO}`, `${moeda.CODMOE}`);
        /// jquerify the DOM object 'o' so we can use the html method
        $(opcao).html(`${moeda.CODMOE + ' - ' + moeda.DESCRICAO}`);
        $("#rgMoeda").append(opcao);
      }
      $.LoadingOverlay("hide");
    } catch (error) {
      $.LoadingOverlay("hide");
      console.log(error);
      msgErro('Não foi possível buscar as empresas cadastradas.');
    }
  }

  async function buscaDados() {
    try {
      $.LoadingOverlay("show");
      const caixa = pegaChave('#txtCaixa');
      const response = await requisicao('GET', '/sisplan/vendas/v1/fechamentocaixa?',
        `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtPeriodo').val()}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.mensagem);
        return;
      }

      criaDataTable(jsonStr[0], jsonStr[1], jsonStr[2]);

      $.LoadingOverlay("hide");
    } catch (error) {
      console.log(error);
      $.LoadingOverlay("hide");
    }
  }

  async function criaDataTable(data, data2, data3) {
    let dataSetCols = [];
    let datasetCols2 = [];
    let datasetCols3 = [];

    data2 = data2.filter(tipo => tipo.TIPO != 'V'); //usado para o usuário não ter acesso aos lançamentos referente a venda

    dataSetCols.push({
      "data": "CODIGO"
    });
    dataSetCols.push({
      "data": "DESCRICAO"
    });
    dataSetCols.push({
      "data": "CONDICAO"
    });
    dataSetCols.push({
      "data": "SALDO_ANTERIOR"
    });
    dataSetCols.push({
      "data": "ENTRADAS"
    });
    dataSetCols.push({
      "data": "SAIDAS"
    });
    dataSetCols.push({
      "data": "SALDO_ATUAL"
    });
    dataSetCols.push({
      "data": "TROCO"
    });

    dataSetCols.push({
      "data": "A_RETIRAR"
    });
    dataSetCols.push({
      "data": "SALDO_FINAL"
    });

    dataSetCols[7].render = function (data, type, row) {
      if ((row['DESCRICAO'].toUpperCase().split(' ')[0] == 'DINHEIRO')) {
        return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate txt${row['DESCRICAO'].toUpperCase().split(' ')[0]}" style="min-width:100px; height: 30px;" min="0">`
      } else {
        return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate troco_off" style="min-width:100px; height: 30px;" readonly>`
      }
    }

    datasetCols2.push({
      "data": "CODMOE"
    });
    datasetCols2.push({
      "data": "DESCMOE"
    });
    datasetCols2.push({
      "data": "VALOR"
    });
    datasetCols2.push({
      "data": "JUROS"
    });
    datasetCols2.push({
      "data": "VALOR_ORIG"
    });
    datasetCols2.push({
      "data": "DT_VENCTO"
    });
    datasetCols2.push({
      "data": "DESCTIPO"
    });
    datasetCols2.push({
      "data": "DUPLICATA"
    });
    datasetCols2.push({
      "data": "DESCRICAO"
    });
    datasetCols2.push({
      "data": "ORDEM"
    });
    datasetCols2.push({
      "data": null
    });
    datasetCols2[10].render = function (data, type, row) {
      let tipo = row['TIPO'];
      return retornaBotaoOpcoes(tipo);
    };

    datasetCols3.push({
      "data": "VENDA",
      "title": "Venda"
    });
    datasetCols3.push({
      "data": "MOEDA",
      "title": "Moeda"
    });
    datasetCols3.push({
      "data": "DESC_MOEDA",
      "title": "Desc Moeda"
    });
    datasetCols3.push({
      "data": "CONDICAO",
      "title": "Condição"
    });
    datasetCols3.push({
      "data": "QUANTIDADE",
      "title": "Quantidade"
    });
    datasetCols3.push({
      "data": "VALOR_VENDA",
      "title": "Valor Venda"
    });
    datasetCols3.push({
      "data": "VALOR",
      "title": "Valor"
    });
    datasetCols3.push({
      "data": "DESCONTO",
      "title": "Desconto"
    });

    let table3 = $('#tabelaVendasGrid').DataTable({
      searching: false,
      paging: false,
      info: false,
      destroy: true,
      ordering: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "autoWidth": true,
      "data": data3,
      "columns": datasetCols3,
      "columnDefs": [{
        "render": function (data) {
          return parseFloat(data ?? 0).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        },
        "targets": [5, 6, 7],
      }]
    });

    $('#tabVendas').trigger('click');

    const colunasNumericas = [3, 4, 5, 6, 8, 9]

    let table = $('#tabelaVendas').DataTable({
      bSort: false,
      searching: false,
      paging: false,
      info: false,
      destroy: true,

      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "columnDefs": [{
        "render": function (data) {
          return parseFloat(data ?? 0).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        },
        "targets": colunasNumericas,
      }],
      "autoWidth": true,
      "data": data,
      "columns": dataSetCols,
    });

    $('#tabelaVendas tbody').on('change', 'tr', function (e) {
      var rowArray = table.row(this).data();

      if (rowArray) {
        if ($(`#txtMoeda-${rowArray['CODIGO']}`).val() < 0) {
          msgAlerta('Valor informado negativo');
          $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
        }

        if ((parseFloat($(`#txtMoeda-${rowArray['CODIGO']}`).val()) > rowArray['SALDO_ATUAL']) && (
          rowArray['SALDO_ATUAL'] > 0)) {
          msgAlerta('Valor informado superior ao saldo atual');
          $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
        }

        rowArray['TROCO'] = Number($(`#txtMoeda-${rowArray['CODIGO']}`).val());
        rowArray['A_RETIRAR'] = rowArray['SALDO_ATUAL'] - rowArray['TROCO'];
        rowArray['A_RETIRAR'] = Number(rowArray['A_RETIRAR'].toFixed(2));

        rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_ATUAL'] - rowArray['A_RETIRAR']);
        rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_FINAL'].toFixed(2));

        table.row(this).invalidate();
        $(function () {
          $('.txtDINHEIRO').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
          });
        })
      }
    });

    $(function () {
      $('.txtDINHEIRO').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });
    })

    $('#tabelaManual').DataTable({
      bSort: false,
      searching: false,
      paging: false,
      info: false,
      destroy: true,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "autoWidth": true,
      "data": data2,
      "columns": datasetCols2,
      "columnDefs": [{
        "type": 'date-br',
        "render": function (data) {
          if (data != undefined) {
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;
          } else {
            return ''
          }
        },
        "targets": 5,
      },
      {
        "render": function (data) {
          return parseFloat(data ?? 0).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        },
        "targets": [2, 3, 4],
      }]
    });

    $('.reciboLancamentoManual').unbind('click');
    $('.reciboLancamentoManual').on('click', async function () {
      try {
        $.LoadingOverlay('show');
        try {
          const table = $('#tabelaManual').DataTable();
          const data = table.row($(this).parents('tr')).data();
          const caixa = pegaChave('#txtCaixa');
          const dataDe = $('#txtPeriodo').val();
          const lancamento = data.LANCAMENTO;
          const ordem = data.ORDEM;
          const tipo = data.TIPO;

          const url = `/sisplan/impressao/v1/recibocaixa?NRCAIXA=${caixa}&TIPO=${tipo}&ORDEM=${ordem}&DATA=${dataDe}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('ReciboCaixa');
          const arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'ReciboCaixa');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível emetir recibo', error)
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    });


    $('.estornarLancamentoManual').unbind('click');
    $('.estornarLancamentoManual').on('click', async function () {
      try {
        $.LoadingOverlay('show');
        try {
          let table = $('#tabelaManual').DataTable();
          let data = table.row($(this).parents('tr')).data();
          var caixa = pegaChave('#txtCaixa');
          let dataDe = $('#txtPeriodo').val();
          let lancamento = data.LANCAMENTO;
          let ordem = data.ORDEM;
          let tipo = data.TIPO;
          let response;
          let jsonStr;

          response = await requisicao('DELETE', '/Sisplan/vendas/V1/Estornar?',
            `CAIXA=${caixa}&DATA=${dataDe}&ORDEM=${ordem}&LANCAMENTO=${lancamento}&TIPO=${tipo}`, null
          );

          if (!response) {
            return;
          }

          if (response.status != 200) {
            jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return false;
          }

          toastr.success(
            'Lançamento manual estornado com sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden: async function () {
              await buscaMoedasData();
            }
          }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível estornar venda', error)
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    });
    setTimeout(() => {
      $('#tabLancManuais').trigger('click');
    }, 200);
  }

  function retornaBotaoOpcoes(tipo) {
    if (tipo != 'V') {
      return '<div style="text-align:center;"> ' +
        '   <div class="dropdown"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      Opções' +
        '    </button> ' +
        '    <div class="dropdown-menu" style="min-width: 2rem;"> ' +
        '    <a class="dropdown-item estornarLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Estornar</a>' +
        '    <a class="dropdown-item reciboLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Emitir Recibo</a>' +
        '    </div>' +
        '  </div>' +
        '</div>';
    } else {
      return '<div style="text-align:center;"> ' +
        '   <div class="dropdown"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" disabled> ' +
        '      Opções' +
        '    </button> ' +
        '  </div>' +
        '</div>';
    }
  };

  async function fecharCaixa() {
    let caixa = pegaChave('#txtCaixa');
    const troco = pegaValor('#txtTroco');
    if (caixa == "") {
      msgAlerta("Caixa não informado");
      return;
    }

    try {
      $.LoadingOverlay("show");

      if (troco > 0) {
        alteraTroco(troco);
      }

      let jsonVendas = JSON.stringify($('#tabelaVendas').DataTable().rows({
        search: 'applied'
      }).data().toArray());

      let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
        `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtPeriodo').val()}`, `JSON=${jsonVendas}`);
      if (!response) {
        $.LoadingOverlay("hide");
        return false;
      }

      if (response.status != 200) {
        let jsonStr = await response.json()
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return false;
      }
      return true;
      $.LoadingOverlay("hide");
    } catch (error) {
      console.log(error);
      $.LoadingOverlay("hide");
    }
  }

  function alteraTroco(valor) {
    const dados = $('#tabelaVendas').DataTable().rows().data().toArray();
    const indice = dados.findIndex((item) =>
      item.DESCRICAO == 'DINHEIRO'
    );

    if (indice != -1) {
      let data_old = $('#tabelaVendas').DataTable().row(indice).data();
      data_old.TROCO = valor.replace('.', ',');
      $('#tabelaVendas').DataTable().row(indice).data(data_old).draw(false);
    }
  }

  async function usuarioMasterOuSupervisor() {
    try {
      const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

      return usuario[0].TIPO != 0;

    } catch (error) {
      console.error(error);
    }
  }

  function habilitaSangriSuprimento(bHabilita) {
    $('#btnSangria').prop('disabled', !bHabilita);
    $('#btnSuprimento').prop('disabled', !bHabilita);
  }

  async function buscaMoedaDinheiro() {
    let moeda;
    if (listaMoedasEmpresa.length > 0) {
      where = `CODMOE IN (${listaMoedasEmpresa.toString()})`;
      const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
        `JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": ["${where} AND DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]'"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        moeda = {
          DESCRICAO: '',
          CODMOE: ''
        };
        return moeda;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr['RESULT'][0].mensagem);
        moeda = {
          DESCRICAO: '',
          CODMOE: ''
        };
        return moeda;
      }
      moeda = jsonStr['RESULT'][0][0];
    } else {
      moeda = await buscaValor('MOEDA', ['DESCRICAO', 'CODMOE'], 'DESCRICAO', 'DINHEIRO');
    }
    return moeda;
  }

  async function SangriaCupom(valor) {
    const _url = '/cupom/sangria?';
    try {
      var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
      if (!response) {
        return false;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        return false;
      } else {
        if (jsonStr.status == 0) {
          return true;
        } else {
          return false;
        }
      }
    } catch (error) {
      console.error(error);
      return false;
    }
  }

  async function InsereSangriaCaixa(valor, data, caixa, observacao) {
    var Sangria = new Object();

    Sangria.VALOR = parseFloat(valor);
    Sangria.DESCRICAO = 'SANGRIA ' + observacao;
    Sangria.TIPO = 'S';
    Sangria.MOEDA = pegaChave($('#txtMoedaSangria'));
    Sangria.DATA = data;
    Sangria.NRCAIXA = caixa;
    Sangria.OPERACAO = 'S';
    // const objPagar = {
    //   VALOR: parseFloat($('#txtSangria').val().replace('.', '').replace(',', '.')),
    //   VALOR_ORIG: parseFloat($('#txtSangria').val().replace('.', '').replace(',', '.')),
    //   STATUS: 'DUPL',
    //   OBS: `AP gerada através de sangria do caixa ${caixa}`,
    //   EMP_ID: getCookie('emp_id'),
    //   CODCRE: pegaChave('#txtFornecedorPagar'),
    //   SITUACAO: pegaChave('#txtSituacaoPagar'),
    //   NUM_OS: pegaChave('#txtClasseGerencialPagar'),
    //   BANCO: pegaChave('#txtBancoPagar'),
    //   CONTA: pegaChave('#txtContaPagar'),
    //   HISTORICO: pegaChave('#txtHistoricoPagar'),
    //   MOEDA: Number(pegaChave('#txtMoedaSangria'))
    // }
    // const jsonPagar = encodeURIComponent(JSON.stringify(objPagar));

    try {
      let response = await requisicao('POST', '/sisplan/vendas/v1/Sangria?',
        `JSON=${encodeURIComponent(JSON.stringify(Sangria))}`);
      if (!response) {
        return
      }
      let jsonStr = await response.json()

      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem);
        return;
      }
      toastr.success(
        'Sangria Cadastrada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden: function () {
          $("#btnConsultar").trigger("click");
          $('.bd-sangria-modal-sm').modal('hide');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });;
    } catch (error) {
      console.error(error);
      msgErro('Erro ao inserir sangria.');
      return;
    }
  }

  async function SuprimentoCupom(valor) {
    const _url = '/cupom/suprimento?';
    try {
      var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
      if (!response) {
        return false;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        return false
      } else {
        if (jsonStr.status == 0) {
          return true;
        } else {
          return false;
        }
      }
    } catch (error) {
      console.error(error);
      return false;
    }
  }

  async function InsereSuprimentoCaixa(valor, data, caixa) {
    var Suprimento = new Object();

    Suprimento.VALOR = parseFloat(valor);
    Suprimento.DESCRICAO = 'SUPRIMENTO';
    Suprimento.TIPO = 'E';
    Suprimento.MOEDA = pegaChave($('#txtMoedaSuprimento'));
    Suprimento.DATA = data;
    Suprimento.NRCAIXA = caixa;
    Suprimento.OPERACAO = 'U';
    try {
      let response = await requisicao('POST', '/sisplan/vendas/v1/Suprimento?',
        `JSON=${encodeURIComponent(JSON.stringify(Suprimento))}`);

      if (!response) {
        return
      }
      let jsonStr = await response.json()

      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem);
        return;
      }

      toastr.success(
        'Suprimento Cadastrada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden: function () {
          $("#btnConsultar").trigger("click");
          $('.bd-suprimento-modal-sm').modal('hide');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });;

    } catch (error) {
      console.error(error);
      msgErro('Erro ao inserir o Suprimento.');
      return;
    }
  }

  function pesquisaLancaPagar() {
    $('#txtFornecedorPagar').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": null }`);
    $('#btnFornecedorPagar').pesquisa_serverside(['#txtFornecedorPagar'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa Fornecedor');
    $('#btnLimpaFornecedorPagar').on('click', function () { $('#txtFornecedorPagar').val('') });

    $('#txtClasseGerencialPagar').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", 
    "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], 
    "where": null }
    `);
    $('#btnClasseGerencialPagar').pesquisa_serverside(['#txtClasseGerencialPagar'], ['CODIGO'], ['DESCRICAO'],
      `{
      "tabela":"CLASSE_GER", 
      "camposSelect":[ "CODIGO", "DESCRICAO" ], 
        "where": null
      }`,
      'Pesquisa Classe Gerencial'
    );
    $('#btnLimpaClasseGerencialPagar').on('click', function () { $('#txtClasseGerencialPagar').val('') });

    $('#txtHistoricoPagar').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": null }`);
    $('#btnHistoricoPagar').pesquisa_serverside(['#txtHistoricoPagar'], ['HISTORICO'], ['DESCRICAO'], `{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa Histórico');
    $('#btnLimpaHistoricoPagar').on('click', function () { $('#txtHistoricoPagar').val('') });

    $('#txtSituacaoPagar').autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
    $('#btnSituacaoPagar').pesquisa_serverside(['#txtSituacaoPagar'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa Situação');
    $('#btnLimpaSituacaoPagar').on('click', function () { $('#txtSituacaoPagar').val('') });

    $('#txtBancoPagar').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": null }`);
    $('#btnBancoPagar').pesquisa_serverside(['#txtBancoPagar'], ['BANCO'], ['NOME_BANCO'], `{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa Banco');
    $('#btnLimpaBancoPagar').on('click', function () { $('#txtBancoPagar').val('') });

    $('#txtContaPagar').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": null }`);
    $('#btnContaPagar').pesquisa_serverside(['#txtContaPagar'], ['CONTA'], ['DESCRICAO'], `{"tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa Conta');
    $('#btnLimpaContaPagar').on('click', function () { $('#txtContaPagar').val('') });
  }

  async function carregaValoresPadroes() {
    $.LoadingOverlay("show");
    try {
      const pesquisa = {
        camposSelect: ['CAMPO', 'VALOR'],
        tabela: 'TABPADRAO',
        where: [`TABPADRAO.TABELA = 'PAGTO'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      jsonStr.map(async item => {
        switch (item.CAMPO) {
          case 'FORNECEDOR': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtFornecedorPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }

          case 'CLASSE_GERENCIA': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtClasseGerencialPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }

          case 'HISTORICO': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtHistoricoPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }

          case 'SITUACAO_CODIGO': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtSituacaoPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }

          case 'BANCO': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtBancoPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }

          case 'CONTA': {
            if (item.VALOR !== '' && item.VALOR !== null) {
              insereValor('#txtContaPagar', item.VALOR, 'VALOR PADRÃO');
            }
            break;
          }
        }
      });
    } catch (error) {
      console.log(`Erro na função carregaValoresPadroes. ${error}`);
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
