$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta das FALs.',
          position: 'right'
        }
      },
      {
        element: '#tabelaServTingimento',
        popover: {
          title: 'Tabela Serviço de Tingimento',
          description: 'Aqui estão todas as FALs cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("SERVTINGIMENTO");

  addPesquisaAutocompleta();
  await consultaServTingimento();

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaServTingimento(true);
    $('#modal-filtros').modal('hide');
  });

  async function consultaServTingimento() {
    try {
      $.LoadingOverlay("show");

      const codigo = pegaChave('#txtFal') != '' ? ` AND FAL.NUMERO = '${pegaChave('#txtFal')}'` : '';
      const status = pegaValor('#rgStatus') != '' ? ` AND (FAL.STATUS = '${pegaValor('#rgStatus')}')` : '';
      const dtIni = pegaValor('#txtDataInicio') != '' ? ` AND (FAL.DATA_INI >= '${pegaValor('#txtDataInicio')}')` : '';
      const dtFim = pegaValor('#txtDataFim') != '' ? ` AND (FAL.DATA_INI <= '${pegaValor('#txtDataFim')}')` : '';
      const lote = pegaValor('#txtLote') != '' ? ` AND (FAL.NUMERO IN (SELECT FAL FROM [FAL_ITEN] WHERE LOTE = '${pegaValor('#txtLote')}'))` : '';
      const cliente = pegaChave('#txtCliente') != '' ? ` AND FAL.CLIENTE = '${pegaChave('#txtCliente')}'` : '';

      const pesquisaParam = {
        tabela: 'FAL',
        camposSelect: [
          'FAL.NUMERO',
          'FAL.CLIENTE',
          'ENTIDADE.NOME',
          'FAL.STATUS',
          'FASE.TIPO FASES',
          'FAL.DATA_INI EMISSAO',
          'FAL.DATA_FIN ENTREGA',
          'SUM(FAL_ITEN.PESO) TOTAL'
        ],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = FAL.CLIENTE' },
          { tabela: 'FAL_ITEN', condicao: 'FAL_ITEN.FAL = FAL.NUMERO' },
          { tabela: 'EMPRESA', condicao: `EMPRESA.EMP_ID = ${getCookie('emp_id')}` },
          { tabela: 'FASE', condicao: `FASE.CODIGO = FAL.FASE_ATUAL` }
        ],
        groupBy: [
          'FAL.NUMERO',
          'FAL.CLIENTE',
          'ENTIDADE.NOME',
          'FAL.STATUS',
          'FASE.TIPO',
          'FAL.DATA_INI',
          'FAL.DATA_FIN'
        ],
        where: [`1=1 ${codigo} ${dtIni} ${dtFim} ${lote} ${cliente} ${pegaValor('#rgStatus') != 'P' ? status : ` AND ((FAL.STATUS = '${pegaValor('#rgStatus')}') OR (FAL.STATUS = 'PA'))`} AND ENTIDADE.CODREP = '${getCookie('cod_usuario')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.');
        $.LoadingOverlay("hide");
        return;
      }

      const dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaServTingimento').DataTable({
        destroy: true,
        filter: true,
        language: retornaLangDataTable(),
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        order: [[0, 'desc']],
        columnDefs: [
          {
            render: funcBotaoOpcoes,
            targets: [0]
          },
          {
            render: funcRetornaStatus,
            targets: [3],
          },
          {
            render: funcRetornaFase,
            targets: [4],
          },
          {
            render: funcFormataData,
            targets: [5, 6],
          }
        ]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    }
  }

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "servtingimento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaServTingimento').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this)).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-imprimir', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimirtingimentoindividual?`;

      const filtros = `NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelTingimentoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelTingimentoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function funcFormataData(data, type, row) {
    if (!data) {
      return 'NÃO ESPECIFICADO'
    }
    x = data.slice(0, 10).split('-');
    return `${x[2]}/${x[1]}/${x[0]}`;
  };

  function funcRetornaStatus(data, type, row) {
    if (!data) {
      return 'NÃO ACEITO'
    }
    if (data == 'N') {
      return 'NÃO ACEITO'
    }
    if (data == 'A') {
      return 'ACEITO'
    }
    if (data == 'R') {
      return 'RECEBIDO'
    }
    if (data == 'P') {
      return 'EM PROGRESSO'
    }
    return data;
  };

  function funcRetornaFase(data, type, row) {
    if (!data) {
      return 'DESCONHECIDO'
    }
    if (data == 'N') {
      return 'OUTROS'
    }
    if (data == 'TERMO') {
      return 'TERMOFIXAR'
    }
    if (data == 'RAMA') {
      return 'ACABAMENTO'
    }
    if (data == 'EST') {
      return 'ESTAMPARIA'
    }
    if (data == 'TING') {
      return 'TINGIMENTO'
    }
    return data;
  };

  function funcBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      `    <button class="dropdown-item" type="button" id="btn-imprimir" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelTingimentoIndividual.FR3"' : 'title="Imprimir"'}>Imprimir</button>    ` +
      '</div>';
    return retorno;
  };

  function addPesquisaAutocompleta() {
    $('#txtFal').autocompleta(1, `JSON={ "tabela":"FAL", "camposSelect":[ "NUMERO CHAVE", "CLIENTE DESCRICAO"], "where": ["CLIENTE IN (SELECT CODCLI FROM [ENTIDADE] WHERE CODREP = '${getCookie('cod_usuario')}')"]}`);
    $('#btnConsultaFal').pesquisa('#txtFal', 'NUMERO', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"FAL", "camposSelect":[ "NUMERO", "CLIENTE"], "where": ["CLIENTE IN (SELECT CODCLI FROM [ENTIDADE] WHERE CODREP = '${getCookie('cod_usuario')}')"]}`, 'Pesquisa FAL', 'FAL');
    $('#btnLimpaFal').on('click', function () {
      $('#txtFal').val('');
    });
    $('#btnLimparFiltros').on('click', function () {
      $('#txtFal').val('');
      $('#rgStatus').val('').change();
      $('#txtDataInicio').val('');
      $('#txtDataFim').val('');
      $('#txtLote').val('');
    });

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["CODREP = '${getCookie('cod_usuario')}'"] }`);
    $('#btnConsultaCliente').pesquisa_serverside(["#txtCliente"], ["CODCLI"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["CODREP = '${getCookie('cod_usuario')}'"]}`, "Pesquisa Cliente");
    $('#btnLimpaCliente').on('click', function () {
      $('#txtCliente').val('');
    });
  };

  function retornaLangDataTable() {
    return {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  };

  function retornaFiltros() {
    const codigo = pegaChave('#txtFal')
    const status = pegaValor('#rgStatus')
    const dtIni = pegaValor('#txtDataInicio')
    const dtFim = pegaValor('#txtDataFim')
    const lote = pegaValor('#txtLote')
    const cliente = pegaChave('#txtCliente')

    return `NUMERO=${codigo}` +
      `&STATUS=${status}` +
      `&DTINI=${dtIni}` +
      `&DTFIM=${dtFim}` +
      `&LOTE=${lote}` +
      `&CLIENTE=${cliente}`
  }

  retornaHintRelatorio('btnImprimir', 'RelProcesso')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relprocesso?`;
        const filtros = retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelProcesso&ORDEM_ORDENACAO=0`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelProcesso');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelProcesso');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

});