$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

      {
        element: '#btn-filtros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("INVENTARIO");
  const parametrosVenda = await BuscaParametrosVenda();

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#btn-filtros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  const bProduto = parametrosVenda[17] == 0;
  if (bProduto) {
    $("#radioProduto").prop("checked", true);
  } else {
    $("#radioMaterial").prop("checked", true);
  }

  $('#btn-incluir').on('click', function () {
    $('#confirmar-dados').addClass('d-none');
    $('#confirmar-dadosincluir').removeClass('d-none');
    $('#btn-produto-filtro-editar').prop('disabled', false);
    $('#btn-limpa-produto-editar').prop('disabled', false);
    $('#btn-deposito-filtro-editar').prop('disabled', false);
    $('#btn-limpa-deposito-editar').prop('disabled', false);
    $('#btn-setor-filtro-editar').prop('disabled', false);
    $('#btn-limpa-setor-editar').prop('disabled', false);
    $('#btn-cor-filtro-editar').prop('disabled', false);
    $('#btn-limpa-cor-editar').prop('disabled', false);
    $('#txtQualidadeEditar').prop('disabled', false);
    $('#btn-limpa-qualidade-editar').prop('disabled', false);
    $('#btn-qualidade-filtro-editar').prop('disabled', false);
    $('#txtProdutoEditar').prop('disabled', false);
    $('#txtDepositoEditar').prop('disabled', false);
    $('#btn-limpa-cnpj-editar').prop('disabled', false);
    $('#btn-cnpj-filtro-editar').prop('disabled', false);
    $('#txtCnpjEditar').prop('disabled', false);
    $('#txtSetorEditar').prop('disabled', false);
    $('#txtCorEditar').prop('disabled', false);
    $('#txtUnEditar').prop('disabled', false);
    $('#txtPosseEditar').prop('disabled', false);
    $('#txtTamEditar').prop('disabled', false);
    $('#btn-tam-filtro-editar').prop('disabled', false);
    $('#btn-limpa-tam-editar').prop('disabled', false);
    $('#txtDataEditar').prop('disabled', false);
    $('#txtLoteEditar').prop('disabled', false).val('000000');
    $('#modal-manutencao').modal('show');
  });


  $('#btnConsultar').trigger('click');

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    if ($.fn.DataTable.isDataTable('#tabelaInventario')) {
      $('#tabelaInventario').DataTable().destroy();
      $('#tabelaInventario').empty();
    };
    if ($('#radioMaterial').is(':checked')) {
      await consultaInventarioMat();
    } else {
      await consultaInventario(true);
    }
  });

  //BOTÕES DE RADIO
  $('#radioProduto, #radioMaterial').on('change', async function () {
    $('#btn-produto-filtro').unbind();
    $('#btnGrupo').unbind();
    $('#btnGrupoMA').unbind();
    $('#txtProduto').val('');
    adicionaPesquisaCampos()
  });

  function adicionaPesquisaCampos() {
    if ($('#radioMaterial').is(':checked')) {
      $("#txtProduto").attr("placeholder", "Material");
      $("#lblProduto").text("Material");
      $('#btn-lancamento-filtro').pesquisa('#txtLancamentoPesquisa', 'LANCAMENTO', 'DT_MES', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"INVENTARIO", "camposSelect":[ "LANCAMENTO", "DT_MES"],"where": null, "GROUPBY":[ "LANCAMENTO", "DT_MES"]}', 'Pesquisa Tabela', 'LANCAMENTO');
      $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
      $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

      $('#btn-produto-filtro-editar').pesquisa_serverside(['#txtProdutoEditar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
      $('#txtProdutoEditar').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);

      $("#txtGrupo").attr("id", "txtGrupoMA");
      $("#btnGrupo").attr("id", "btnGrupoMA");
      $("#btnLimpaGrupo").attr("id", "btnLimpaGrupoMA");
      componenteFiltro('grupoMA', false, false)

      $('#divSubGrupo').removeClass('d-none')
      $('#divSubGrupo').addClass('col-6')
      $('#divGrupo').removeClass('col-12')
      $('#divGrupo').addClass('col-6')
    } else {
      $("#txtProduto").attr("placeholder", "Produto");
      $("#lblProduto").text("Produto");
      $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Produto');
      $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

      $("#txtGrupoMA").attr("id", "txtGrupo");
      $("#btnGrupoMA").attr("id", "btnGrupo");
      $("#btnLimpaGrupoMA").attr("id", "btnLimpaGrupo");
      componenteFiltro('grupo', false, false)

      $('#divGrupo').removeClass('col-6')
      $('#divGrupo').addClass('col-12')
      $('#divSubGrupo').addClass('d-none')
    }
  }

  $('txtLancamentoPesquisa').pesquisa_serverside(['#txtLancamentoPesquisa'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"INVENTARIO", "camposSelect":[ "LANCAMENTO"], "where": null,}', 'Pesquisa Lancamento');
  $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Produto');
  $('#btn-deposito-filtro').pesquisa_serverside(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Deposito');
  $('#btn-setor-filtro').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Setor');
  $('#btn-cor-filtro').pesquisa_serverside(['#txtCor'], ['COR'], ['DESCRICAO'], '{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"],    "where": null}', 'Pesquisa Cor');

  $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "CODIGO CHAVE", "descricao"], "where": null}`);
  $('#txtDeposito').autocompleta(3, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "descricao"], "where": null}`);
  $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO"], "where": null}`);

  $('#btn-produto-filtro').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-produto').on('click', function () {
    $('#txtProduto').val('');
  });
  $('#btn-deposito-filtro').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-deposito').on('click', function () {
    $('#txtDeposito').val('');
  });
  $('#btn-setor-filtro').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-setor').on('click', function () {
    $('#txtSetor').val('');
  });
  $('#btn-cor-filtro').pesquisa('#txtCor', 'COR', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}', 'Pesquisa Tabela', 'COR');
  $('#btn-limpa-cor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btn-limpa-lancamento').on('click', function () {
    $('#txtLancamentoPesquisa').val('');
  });
  $('#btn-limpa-produto').on('click', function () {
    $('#txtProduto').val('');
  });
  $('#btn-limpa-deposito').on('click', function () {
    $('#txtDeposito').val('');
  });
  $('#btn-limpa-setor').on('click', function () {
    $('#txtSetor').val('');
  });
  $('#btn-limpa-cor').on('click', function () {
    $('#txtCor').val('');
  });

  componenteFiltro('grupoMA', false, false);
  componenteFiltro('qualidade', false, false);
  componenteFiltro('subGrupo', false, false);
  componenteFiltro('linha', false, false);

  $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`);
  $('#btnLote').pesquisa_serverside(['#txtLote'], ['LOTE'], ['CODIGO'], `{"tabela":"MAT_ITEN", "camposSelect":["LOTE", "CODIGO", "COR"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

  $('#btnLimpaLote').on('click', function () {
    $('#txtLote').val('');
  });

  $('#txtLancamentoPesquisa').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#txtLancamentoPesquisa').click();
    }
  });
  $('#txtProduto').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-produto-filtro').click();
    }
  });
  $('#txtDeposito').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-deposito-filtro').click();
    }
  });
  $('#txtSetor').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-setor-filtro').click();
    }
  });
  $('#txtCor').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-cor-filtro').click();
    }
  });

  $('#btn-produto-filtro-editar').pesquisa_serverside(['#txtProdutoEditar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Produto');
  $('#btn-deposito-filtro-editar').pesquisa_serverside(['#txtDepositoEditar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Deposito');
  $('#btn-setor-filtro-editar').pesquisa_serverside(['#txtSetorEditar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Setor');
  $('#btn-cor-filtro-editar').pesquisa_serverside(['#txtCorEditar'], ['COR'], ['DESCRICAO'], '{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": null}', 'Pesquisa Cor');
  $('#btn-tam-filtro-editar').pesquisa_serverside(['#txtTamEditar'], ['TAM'], ['ID_TAM'], '{"tabela":"TABTAM", "camposSelect":[ "TAM", "ID_TAM"], "where": null}', 'Pesquisa Tam');
  $('#btn-cnpj-filtro-editar').pesquisa_serverside(['#txtCnpjEditar'], ['CODCLI'], ['CNPJ'], '{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME", "CNPJ"], "where": null}', 'Pesquisa CNPJ');
  $('#txtCnpjEditar').pesquisa_serverside(['#txtCnpjEditar'], ['CODCLI'], ['CNPJ'], '{"tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME", "CNPJ"], "where": null}', 'Pesquisa CNPJ');
  $('#btn-qualidade-filtro-editar').pesquisa_serverside(['#txtQualidadeEditar'], ['CODCLI'], ['CNPJ'], '{"tabela":"TABQUL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa CODIGO');

  $('#btn-produto-filtro-editar').pesquisa('#txtProdutoEditar', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-produto-editar').on('click', function () {
    $('#txtProdutoEditar').val('');
  });
  $('#btn-deposito-filtro-editar').pesquisa('#txtDepositoEditar', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-deposito-editar').on('click', function () {
    $('#txtDepositoEditar').val('');
  });
  $('#btn-setor-filtro-editar').pesquisa('#txtSetorEditar', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'CODIGO');
  $('#btn-limpa-setor-editar').on('click', function () {
    $('#txtSetorEditar').val('');
  });
  $('#btn-cor-filtro-editar').pesquisa('#txtCorEditar', 'COR', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}', 'Pesquisa Tabela', 'COR');
  $('#btn-limpa-cor-editar').on('click', function () {
    $('#txtCorEditar').val('');
  });
  $('#btn-tam-filtro-editar').pesquisa('#txtTamEditar', 'TAM', 'ID_TAM', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM", "ID_TAM"]}', 'Pesquisa Tabela', 'TAM');
  $('#btn-limpa-tam-editar').on('click', function () {
    $('#txtTamEditar').val('');
  });
  $('#btn-qualidade-filtro-editar').pesquisa('#txtQualidadeEditar', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Tabela', 'QUALIDADE');
  $('#btn-limpa-qualidade-editar').on('click', function () {
    $('#txtQualidadeEditar').val('');
  });
  // $('#btn-cnpj-filtro-editar').pesquisa('#txtCnpjEditar', 'CODCLI', 'CNPJ', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME", "CNPJ"]}', 'Pesquisa Tabela', 'CNPJ');
  // $('#btn-limpa-cnpj-editar').on('click', function () {
  //   $('#txtCnpjEditar').val('');
  // });

  $('#btn-limpa-produto-editar').on('click', function () {
    $('#txtProdutoEditar').val('');
  });
  $('#btn-limpa-deposito-editar').on('click', function () {
    $('#txtDepositoEditar').val('');
  });
  $('#btn-limpa-setor-editar').on('click', function () {
    $('#txtSetorEditar').val('');
  });
  $('#btn-limpa-cor-editar').on('click', function () {
    $('#txtCorEditar').val('');
  });
  $('#btn-limpa-tam-editar').on('click', function () {
    $('#txtTamEditar').val('');
  });
  $('#btn-limpa-cnpj-editar').on('click', function () {
    $('#txtCnpjEditar').val('');
  });
  $('#btn-limpa-qualidade-editar').on('click', function () {
    $('#txtQualidadeEditar').val('');
  });

  $('#txtProdutoEditar').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtDepositoEditar').autocompleta(3, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtSetorEditar').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtCorEditar').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtTamEditar').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtCnpjEditar').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "CNPJ DESCRICAO"], "where": null}`);
  $('#txtQualidadeEditar').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);

  $('#txtProdutoEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-produto-filtro-editar').click();
    }
  });
  $('#txtDepositoEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-deposito-filtro-editar').click();
    }
  });
  $('#txtSetorEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-setor-filtro-editar').click();
    }
  });
  $('#txtCorEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-cor-filtro-editar').click();
    }
  });
  $('#txtTamEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-tam-filtro-editar').click();
    }
  }); $('#txtQualidadeEditar').keydown(function (e) {

    if (e.which == 115) {
      e.preventDefault();
      $('#btn-qualidade-filtro-editar').click();
    }
  });

  $('#btnLimparFiltros').on('click', async function () {
    await setarDataAtual('dtCadastroDe');
    await setarDataAtual('dtCadastroAte');
    $('#txtLancamentoPesquisa').val('')
    $('#txtDeposito').val('')
    $('#txtSetor').val('')
    $('#txtGrupoMA').val('')
    $('#txtSubGrupo').val('')
    $('#txtLinha').val('')
    $('#txtProduto').val('')
    $('#txtCor').val('')
    $('#txtQualidade').val('')
    $('#txtLote').val('')

  })

  async function consultaInventarioMat() {
    try {
      $.LoadingOverlay("show");
      const dtCadastroDe = "'" + $('#dtCadastroDe').val() + "'";
      const dtCadastroAte = "'" + $('#dtCadastroAte').val() + "'";
      let lancamento = $('#txtLancamentoPesquisa').val() != '' ? ` AND INVENTARIO.LANCAMENTO = '${$('#txtLancamentoPesquisa').val()}'` : '';
      let produto = pegaChave('#txtProduto') != '' ? ` AND MAT_ITEN.CODIGO = '${pegaChave('#txtProduto')}'` : '';
      let deposito = pegaChave('#txtDeposito') != '' ? ` AND MAT_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}'` : '';
      let setor = pegaChave('#txtSetor') != '' ? ` AND INVENTARIO.CODSETOR = '${pegaChave('#txtSetor')}'` : '';
      let cor = pegaChave('#txtCor') != '' ? ` AND MAT_ITEN.COR = '${pegaChave('#txtCor')}'` : '';
      let tipo = $('#radioMaterial').is(':checked') ? ` AND INVENTARIO.TP_INV = 'M'` : ` AND TP_INV = 'P'`;

      let grupo = pegaChave('#txtGrupoMA') != '' ? ` AND INVENTARIO.GRUPO = '${pegaChave('#txtGrupoMA')}'` : '';
      let subGrupo = pegaChave('#txtSubGrupo') != '' ? ` AND INVENTARIO.SUB_GRUPO = '${pegaChave('#txtSubGrupo')}'` : '';
      let linha = pegaChave('#txtLinha') != '' ? ` AND INVENTARIO.LINHA = '${pegaChave('#txtLinha')}'` : '';
      let qualidade = pegaChave('#txtQualidade') != '' ? ` AND MAT_ITEN.QUALIDADE = '${pegaChave('#txtQualidade')}'` : '';
      let lote = pegaChave('#txtLote') != '' ? ` AND MAT_ITEN.LOTE = '${pegaChave('#txtLote')}'` : '';

      if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
        msgAlerta('Informe uma data para consultar!')
        return;
      }

      let obj = {
        tabela: "INVENTARIO",
        camposSelect: ["INVENTARIO.TP_INV", "INVENTARIO.CHAVE", "INVENTARIO.LANCAMENTO", "INVENTARIO.CODIGO", "INVENTARIO.DESCRICAO",
          "INVENTARIO.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "INVENTARIO.TAM", "INVENTARIO.CODSETOR", "CADFLUXO.DESCRICAO DESC_SETOR",
          "INVENTARIO.COR", "CADCOR.DESCRICAO DESC_COR", "INVENTARIO.QTDE", "INVENTARIO.PRECO", "INVENTARIO.PRECO_DIV",
          "INVENTARIO.PRECO_COR", "INVENTARIO.DT_MES", "INVENTARIO.LOTE", "INVENTARIO.QUALIDADE", "TABQUL.DESCRICAO DESC_QUALIDADE",
          "INVENTARIO.GRUPO", "GRUPO_MA.DESCRICAO DESC_GRUPO", "INVENTARIO.SUB_GRUPO", "SUBGRUPO_MA.DESCRICAO DESC_SUBGRUPO",
          "INVENTARIO.LINHA", "TABLIN.DESCRICAO DESC_LINHA"],
        leftJoin: [
          { tabela: "GRUPO_MA", condicao: "GRUPO_MA.CODIGO = INVENTARIO.GRUPO" },
          { tabela: "SUBGRUPO_MA", condicao: "SUBGRUPO_MA.CODIGO = INVENTARIO.SUB_GRUPO" },
          { tabela: "TABLIN", condicao: "TABLIN.CODIGO = INVENTARIO.LINHA" },
          { tabela: "TABQUL", condicao: "TABQUL.CODIGO = INVENTARIO.QUALIDADE" },
          { tabela: "DEPOSITO", condicao: "DEPOSITO.CODIGO = INVENTARIO.DEPOSITO" },
          { tabela: "CADCOR", condicao: "CADCOR.COR = INVENTARIO.COR" },
          { tabela: "CADFLUXO", condicao: "CADFLUXO.CODIGO = INVENTARIO.CODSETOR" },
        ],
        where: [`(INVENTARIO.DT_MES >= ${dtCadastroDe} and INVENTARIO.DT_MES <= ${dtCadastroAte}) ${lancamento} ${produto} ${deposito} ${setor} ${cor} ${tipo} ${grupo} ${subGrupo} ${linha} ${qualidade} ${lote}`]
      }

      const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON=${JSON.stringify(obj)}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaInventario').DataTable({
        destroy: true,
        lengthChange: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [
          { "data": "TP_INV", "title": "Tipo" },
          { "data": "CHAVE", "title": "Chave" },
          { "data": "LANCAMENTO", "title": "Lançamento" },
          { "data": "CODIGO", "title": "Código" },
          { "data": "DESCRICAO", "title": "Descrição" },
          { "data": "LOTE", "title": "Lote" },
          { "data": "TAM", "title": "Tamanho" },
          { "data": "COR", "title": "Cor" },
          { "data": "DESC_COR", "title": "Desc_Cor" },
          { "data": "CODSETOR", "title": "Setor" },
          { "data": "DESC_SETOR", "title": "Desc_Setor" },
          { "data": "QTDE", "title": "Qtde" },
          { "data": "QUALIDADE", "title": "Qualidade" },
          { "data": "DESC_QUALIDADE", "title": "Desc_Qualidade" },
          { "data": "GRUPO", "title": "Grupo" },
          { "data": "DESC_GRUPO", "title": "Desc_Grupo" },
          { "data": "SUB_GRUPO", "title": "SubGrupo" },
          { "data": "DESC_SUBGRUPO", "title": "Desc_SubGrupo" },
          { "data": "LINHA", "title": "Linha" },
          { "data": "DESC_LINHA", "title": "Desc_Linha" },
        ],
        "columnDefs": [
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          }
        ]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function consultaInventario(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      const dtCadastroDe = "'" + $('#dtCadastroDe').val() + "'";
      const dtCadastroAte = "'" + $('#dtCadastroAte').val() + "'";
      let lancamento = $('#txtLancamentoPesquisa').val() != '' ? ` AND LANCAMENTO = '${$('#txtLancamentoPesquisa').val()}'` : '';
      let produto = pegaChave('#txtProduto') != '' ? ` AND CODIGO = '${pegaChave('#txtProduto')}'` : '';
      let deposito = pegaChave('#txtDeposito') != '' ? ` AND DEPOSITO = '${pegaChave('#txtDeposito')}'` : '';
      let setor = pegaChave('#txtSetor') != '' ? ` AND CODSETOR = '${pegaChave('#txtSetor')}'` : '';
      let cor = pegaChave('#txtCor') != '' ? ` AND COR = '${pegaChave('#txtCor')}'` : '';
      let tipo = $('#radioMaterial').is(':checked') ? ` AND TP_INV = 'M'` : ` AND TP_INV = 'P'`;

      if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
        msgAlerta('Informe uma data para consultar!')
        return;
      }
      if (bBotao) {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"INVENTARIO", "camposSelect":["TP_INV", "CHAVE", "LANCAMENTO", "CODIGO", "DESCRICAO", "DEPOSITO", "TAM", "CODSETOR", "COR", "QTDE", "PRECO", "PRECO_DIV", "PRECO_COR", "DT_MES", "LOTE"], "where": ["(dt_mes >= ${dtCadastroDe} and dt_mes <= ${dtCadastroAte}) ${lancamento} ${produto} ${deposito} ${setor} ${cor} ${tipo}"]}`, null);
      } else {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"INVENTARIO", "camposSelect":["TP_INV", "DT_MES"], "where": null, "limit": 10000}', null);
      }

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaInventario').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [
          { "data": "TP_INV", "title": "Tipo" },
          { "data": "CHAVE", "title": "Chave" },
          { "data": "LANCAMENTO", "title": "Lançamento" },
          { "data": "CODIGO", "title": "Código" },
          { "data": "DESCRICAO", "title": "Descrição" },
          { "data": "TAM", "title": "Tamanho" },
          { "data": "COR", "title": "Cor" },
          { "data": "CODSETOR", "title": "CodSetor" },
          { "data": "QTDE", "title": "Quantidade" },
        ],
        "columnDefs": [{
          targets: [1], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function buscaDadosItem(chave) {
    const pesquisa = {
      tabela: "INVENTARIO",
      camposSelect: ["TP_INV, CHAVE, LANCAMENTO, CODIGO, DESCRICAO, DEPOSITO, TAM, CODSETOR, COR, QTDE, PRECO, PRECO_DIV, PRECO_COR, DT_MES, LOTE, QUALIDADE, POSSE, UNIDADE"],
      where: [`CHAVE = '${chave}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return jsonStr[0];
  }

  $('#tabelaInventario').on('click', '#btn-editar', async function () {
    $('#confirmar-dados').removeClass('d-none');
    $('#confirmar-dadosincluir').addClass('d-none');
    $('#btn-produto-filtro-editar').prop('disabled', true);
    $('#btn-limpa-produto-editar').prop('disabled', true);
    $('#btn-deposito-filtro-editar').prop('disabled', true);
    $('#btn-limpa-deposito-editar').prop('disabled', true);
    $('#btn-setor-filtro-editar').prop('disabled', true);
    $('#btn-limpa-setor-editar').prop('disabled', true);
    $('#btn-cor-filtro-editar').prop('disabled', true);
    $('#btn-limpa-cor-editar').prop('disabled', true);
    $('#txtUnEditar').prop('disabled', true);
    $('#txtQualidadeEditar').prop('disabled', true);
    $('#btn-limpa-qualidade-editar').prop('disabled', true);
    $('#btn-qualidade-filtro-editar').prop('disabled', true);
    $('#txtPosseEditar').prop('disabled', true);
    $('#txtProdutoEditar').prop('disabled', true);
    $('#txtDepositoEditar').prop('disabled', true);
    $('#btn-limpa-cnpj-editar').prop('disabled', true);
    $('#btn-cnpj-filtro-editar').prop('disabled', true);
    $('#txtCnpjEditar').prop('disabled', true);
    $('#txtSetorEditar').prop('disabled', true);
    $('#txtCorEditar').prop('disabled', true);
    $('#txtTamEditar').prop('disabled', true);
    $('#btn-tam-filtro-editar').prop('disabled', true);
    $('#btn-limpa-tam-editar').prop('disabled', true);
    $('#txtDataEditar').prop('disabled', true);
    $('#txtLoteEditar').prop('disabled', true);
    $('#modal-manutencao').modal('show');
    try {
      try {
        $.LoadingOverlay("show");
        $('#modal-manutencao').modal('show');
        $('#txtLinhaEditada').val($(this).closest("tr")[0].rowIndex - 1);
        let tabela = $('#radioMaterial').is(':checked') ? 'MATERIAL' : 'PRODUTO'
        const data = $('#tabelaInventario').DataTable().row($(this).parents('tr')).data();

        const dadosItem = await buscaDadosItem(data.CHAVE)

        $('#txtChaveEditar').val(dadosItem.CHAVE);
        $('#txtLancamentoEditar').val(dadosItem.LANCAMENTO);
        insereValor('#txtProdutoEditar', dadosItem.CODIGO, { tabela: tabela, campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.CODIGO });
        insereValor('#txtDepositoEditar', dadosItem.DEPOSITO, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.DEPOSITO });
        insereValor('#txtCorEditar', dadosItem.COR, { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'COR', valorWhere: dadosItem.COR });
        insereValor('#txtTamEditar', dadosItem.TAM, { tabela: 'TABTAM', campoBusca: 'TAM', campoWhere: 'TAM', valorWhere: dadosItem.TAM });
        $('#txtLoteEditar').val(dadosItem.LOTE);
        insereValor('#txtSetorEditar', dadosItem.CODSETOR, { tabela: 'CADFLUXO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.CODSETOR });
        $('#txtDataEditar').val(dadosItem.DT_MES.split(' ')[0]);
        $('#txtQtdeEditar').val(dadosItem.QTDE);
        $('#txtPrecoEditar').val(dadosItem.PRECO);
        $('#txtPrecoDivEditar').val(dadosItem.PRECO_DIV);
        $('#txtPrecoCorEditar').val(dadosItem.PRECO_COR);
        $('#txtTPInvEditar').val(dadosItem.TP_INV);
        $('#txtCnpjEditar').val(dadosItem.CNPJ);
        insereValor('#txtUnEditar', dadosItem.UNIDADE, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: dadosItem.UNIDADE });
        $('#txtPosseEditar').val(dadosItem.POSSE);
        insereValor('#txtQualidadeEditar', dadosItem.QUALIDADE, { tabela: 'TABQUL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dadosItem.QUALIDADE });

      } catch (error) {
        msgErro('Erro ao buscar dados da nota');
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#modal-manutencao').on('hidden.bs.modal', function (e) {
    $('#txtChaveEditar').val('');
    $('#txtLancamentoEditar').val('');
    $('#txtProdutoEditar').val('');
    $('#txtDepositoEditar').val('');
    $('#txtCorEditar').val('');
    $('#txtSetorEditar').val('');
    $('#txtDataEditar').val('');
    $('#txtTamEditar').val('');
    $('#txtLoteEditar').val('000000');
    $('#txtQtdeEditar').val('');
    $('#txtPrecoEditar').val('');
    $('#txtPrecoDivEditar').val('');
    $('#txtPrecoCorEditar').val('');
    $('#txtLinhaEditada').val('');
    $('#txtCnpjEditar').val('');
    $('#txtUnEditar').val('');
    $('#txtPosseEditar').val('');
    $('#txtQualidadeEditar').val('');
  });

  $('#confirmar-dados').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {

        const linhaEditada = $('#txtLinhaEditada').val();
        const dataOld = $('#tabelaInventario').DataTable().row(linhaEditada).data();

        dataOld.CHAVE = $('#txtChaveEditar').val();
        dataOld.CODIGO = pegaChave('#txtProdutoEditar');
        dataOld.DEPOSITO = pegaChave('#txtDepositoEditar');
        dataOld.COR = pegaChave('#txtCorEditar');
        dataOld.TAM = pegaChave('#txtTamEditar');
        dataOld.DT_MES = $('txtDataEditar').val();
        dataOld.CODSETOR = pegaChave('#txtSetorEditar');
        dataOld.LOTE = $('#txtLoteEditar').val();
        dataOld.QTDE = $('#txtQtdeEditar').val();
        dataOld.PRECO = $('#txtPrecoEditar').val();
        dataOld.PRECO_DIV = $('#txtPrecoDivEditar').val();
        dataOld.PRECO_COR = $('#txtPrecoCorEditar').val();
        dataOld.CNPJ = pegaChave('#txtCnpjEditar');
        dataOld.UNIDADE = $('#txtUnEditar').val();
        dataOld.POSSE = $('#txtPosseEditar').val();
        dataOld.QUALIDADE = pegaChave('#txtQualidadeEditar');

        // grava no banco com as informações novas  

        let response = await requisicao("POST", "/sisplan/inventario/v1/manutencaoinventario?", `JSON=${encodeURIComponent(JSON.stringify(dataOld))}`, null);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }
        criaMensagemSucesso('Cadastro efetuado com sucesso!',)
        $('#btnConsultar').trigger('click');

      } catch (error) {

      }
    } finally {
      $('#modal-manutencao').modal('hide');
      $.LoadingOverlay("hide");
    }
  });



  $('#confirmar-dadosincluir').on('click', async function () {
    if ($("#txtProdutoEditar").val() == "") {
      msgAlerta("Produto não informado, favor verificar.");
      return;
    }
    if ($("#txtDepositoEditar").val() == "") {
      msgAlerta("Depósito não informado, favor verificar.");
      return;
    }
    if ($("#txtSetorEditar").val() == "") {
      msgAlerta("Setor não informado, favor verificar.");
      return;
    }
    if ($("#txtCorEditar").val() == "") {
      msgAlerta("Cor não informada, favor verificar.");
      return;
    }
    if ($("#txtDataEditar").val() == "") {
      msgAlerta("Data não informada, favor verificar.");
      return;
    }
    if ($("#txtTamEditar").val() == "") {
      msgAlerta("Tamanho não informado, favor verificar.");
      return;
    }
    if ($("#txtQtdeEditar").val() == "") {
      msgAlerta("Quantidade não informado, favor verificar.");
      return;
    }
    if ($("#txtPrecoEditar").val() == "") {
      msgAlerta("Preço não informado, favor verificar.");
      return;
    }
    if ($("#txtCnpjEditar").val() == "") {
      msgAlerta("CNPJ não informado, favor verificar.");
      return;
    }
    if ($("#txtUnEditar").val() == "") {
      msgAlerta("Unidade não informado, favor verificar.");
      return;
    }
    if ($("#txtPosseEditar").val() == 0) {
      msgAlerta("Posse não informado, favor verificar.");
      return;
    } if ($("#txtQualidadeEditar").val() == 0) {
      msgAlerta("Qualidade não informada, favor verificar.");
      return;
    }
    try {
      $.LoadingOverlay("show");
      try {
        const envio = {
          CHAVE: pegaChave('#txtChaveEditar') == '' ? 0 : $('#txtChaveEditar'),
          CODIGO: pegaChave('#txtProdutoEditar'),
          DESCRICAO: pegaDescricao('#txtProdutoEditar'),
          DEPOSITO: pegaChave('#txtDepositoEditar'),
          COR: pegaChave('#txtCorEditar'),
          TAMANHO: pegaChave('#txtTamEditar'),
          LOTE: $('#txtLoteEditar').val(),
          CODSETOR: pegaChave('#txtSetorEditar'),
          SETOR: pegaDescricao('#txtSetorEditar'),
          DT_MES: $('#txtDataEditar').val(),
          QTDE: $('#txtQtdeEditar').val(),
          PRECO: $('#txtPrecoEditar').val(),
          PRECO_DIV: $('#txtPrecoDivEditar').val(),
          PRECO_COR: $('#txtPrecoCorEditar').val(),
          LANCAMENTO: pegaChave('#txtLancamentoEditar'),
          CNPJ: pegaDescricao('#txtCnpjEditar'),
          UNIDADE: $('#txtUnEditar').val(),
          POSSE: $('#txtPosseEditar').val(),
          TP_INV: $('#txtTPInvEditar').val(),
          QUALIDADE: pegaChave('#txtQualidadeEditar'),
        }

        const retorno = await requisicao(
          "POST",
          "/sisplan/inventario/v1/manutencaoinventario?",
          '',
          `JSON=${JSON.stringify(envio)}`,
          900000
        );
        if (!retorno) {
          return;
        }
        criaMensagemSucesso('Cadastro efetuado com sucesso!');
      } catch (error) {
      }
    } finally {
      $('#modal-manutencao').modal('hide');
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaInventario').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaInventario").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const dtCadastroDe = $('#dtCadastroDe').val();
      const dtCadastroAte = $('#dtCadastroAte').val();
      let lancamento = $('#txtLancamentoPesquisa').val();
      let deposito = pegaChave('#txtDeposito');
      let setor = pegaChave('#txtSetor');
      let cor = pegaChave('#txtCor');

      if ((dtCadastroDe == "''") || (dtCadastroAte == "''")) {
        msgAlerta('Informe uma data para consultar!')
        return;
      }

      const url = `/sisplan/impressao/v1/manutencao_inventario?DT_MESI=${dtCadastroDe}&DT_MESF=${dtCadastroAte}&LANCAMENTO=${lancamento}&DEPOSITO=${deposito}&SETOR=${setor}&COR=${cor}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('ManutencaoInventario');
      const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'ManutencaoInventario');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/inventario/v1/manutencaoinventario?", `CHAVE=${valorLinha.CHAVE}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }


  await setarDataAtual('dtCadastroDe');
  await setarDataAtual('dtCadastroAte');

  adicionaPesquisaCampos()
});
