$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoLancamento',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um lançamento.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaLancamento',
                popover: {
                    title: 'Tabela Lançamentos',
                    description: 'Aqui estão os dados dos Lançamentos cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    componenteFiltro('representante', true, true)

    const permissaoUsuarioLogado = await permissaoAcessos("LANCREP");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaLancamentos();

    $('#btnConsultar').on('click', async function () {
        await consultaLancamentos();
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtRepresentante').empty().trigger('change')
        //aqui vai limpar todos os outros filtros
    });

    async function retornaFiltros() {
        const filtros = `FILTRONUMERO=${$('#txtNumero').val()}` +
            `&CODREP=${await formataListas($('#txtRepresentante').val().toString())}` +
            `&DTINICIO=${$('#txtDtIni').val()}` +
            `&DTFINAL=${$('#txtDtIni').val()}`

        return filtros
    }

    async function consultaLancamentos() {
        $.LoadingOverlay("show");
        try {
            const url = "/sisplan/cadastros/v1/lancrep?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, filtros, "", 36000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr['RESULT'][0].mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            const keys = Object.keys(jsonStr[0]);
            let dataSetCols = [];

            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k].toUpperCase(),
                    'data': keys[k]
                });
            };

            $('#tabelaLancamento').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                autoWidth: true,
                columns: dataSetCols,
                data: jsonStr,
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                    {
                        type: "date-br",
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat("pt-BR").format(
                                    new Date(`${data.split(" ")[0]} 23:59:59`)
                                );
                            } else {
                                return ''
                            }
                        },
                        targets: [7, 8],
                    },
                    {
                        render: function (data) {
                            if (data) {
                                return parseFloat(data).toLocaleString("pt-br", {
                                    maximumFractionDigits: 2,
                                    minimumFractionDigits: 2,
                                });
                            } else {
                                return ''
                            }
                        },
                        targets: [5, 10],
                    },
                ]
            });

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnNovoLancamento').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "lancrep/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaLancamento').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaLancamento').DataTable().row($(this).parents('tr')).data();
            if (data.TIPO != 'MAN'){
                msgAlerta('Operação não permitida. Lançamento não é do tipo manual.')
                return
            }
            if (data.PAGO != 'N'){
                msgAlerta('Não é possível alterar o registro, valores já pagos!')
                return
            }
            let registroLiberado = await verificarRegistro('LANCREP', data.NUMERO);
            if (registroLiberado) {
                window.location.href = `lancrep/${data.NUMERO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaLancamento').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaLancamento').DataTable().row($(this)).data();
            if (data.TIPO != 'MAN'){
                msgAlerta('Operação não permitida. Lançamento não é do tipo manual.')
                return
            }
            if (data.PAGO != 'N'){
                msgAlerta('Não é possível alterar o registro, valores já pagos!')
                return
            }
            let registroLiberado = await verificarRegistro('LANCREP', data.NUMERO);
            if (registroLiberado) {
                window.location.href = `lancrep/${data.NUMERO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaLancamento').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaLancamento").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/lancrep?", `NUMERO=${encodeURIComponent(valorLinha.NUMERO)}&TIPO=${encodeURIComponent(valorLinha.TIPO)}&PAGO=${encodeURIComponent(valorLinha.PAGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});