<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Pagar</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2410.21.2">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2410.21.2">
    <!-- Google Font: Source Sans Pro -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2410.21.2">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2410.21.2">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2410.21.2">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2410.21.2" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2410.21.2" />
    <link rel="stylesheet" href="dist/css/select.bootstrap.min.css?versao=3.2410.21.2" />
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2410.21.2">
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2410.21.2">
    <link rel="stylesheet" href="dist/css/cards-financeiro.css">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2410.21.2">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2410.21.2">

    <style>
        #msform {
            text-align: start;
            position: relative;
        }

        #myModalText {
            color: black;
            font-size: 17px;
        }

        td.ColunaVermelha {
            color: red;
        }

        .table.dataTable tbody td {
            white-space: nowrap;
            text-overflow: ellipsis;
            /* overflow: hidden; --- retirado pois o botao dropdown nao funcionava*/
        }

        .table.dataTable thead th {
            white-space: nowrap;
            text-overflow: ellipsis;
            /* overflow: hidden; retirado pois o botao dropdown nao funcionava */
        }

        #cbTodos {
            margin: 0px 0 0 20px;
            width: 21px;
            margin-bottom: 0px !important;
        }

        #scrollToBottomBtn {
            z-index: 10;
            padding: 10px 12px;
            background-color: #c2121a;
            color: white;
            border: none;
            border-radius: 18px;
            cursor: pointer;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            bottom: 5rem;
            left: 50%;
            transform: translateX(-50%);
            animation: pulse 2s infinite ease-in-out;
        }

        @media (min-height: 300px) and (max-height: 349px) {
            #scrollToBottomBtn {
                bottom: 0rem;
            }
        }

        @media (min-height: 350px) and (max-height: 399px) {
            #scrollToBottomBtn {
                bottom: 0.5rem;
            }
        }

        @media (min-height: 400px) and (max-height: 449px) {
            #scrollToBottomBtn {
                bottom: 1rem;
            }
        }

        @media (min-height: 450px) and (max-height: 499px) {
            #scrollToBottomBtn {
                bottom: 1.5rem;
            }
        }

        @media (min-height: 500px) and (max-height: 549px) {
            #scrollToBottomBtn {
                bottom: 2rem;
            }
        }

        @media (min-height: 550px) and (max-height: 599px) {
            #scrollToBottomBtn {
                bottom: 2.5rem;
            }
        }

        @media (min-height: 600px) and (max-height: 649px) {
            #scrollToBottomBtn {
                bottom: 3rem;
            }
        }

        @media (min-height: 650px) and (max-height: 699px) {
            #scrollToBottomBtn {
                bottom: 3.5rem;
            }
        }

        @media (min-height: 700px) and (max-height: 749px) {
            #scrollToBottomBtn {
                bottom: 4rem;
            }
        }

        @media (min-height: 750px) and (max-height: 799px) {
            #scrollToBottomBtn {
                bottom: 4.5rem;
            }
        }

        @keyframes pulse {
            0% {
                transform: translateY(-7%)
            }

            50% {
                transform: translateY(0%)
            }

            100% {
                transform: translateY(-7%)
            }
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <?php
        include_once('../../../menu.php');
        ?>

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Contas a Pagar</h1>
                            <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div><!-- /.col -->
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                    <!-- Small boxes (Stat box) -->
                    <div class="row" id="boxdashboard">
                        <div class="col-md-4 col-sm-4 col-12">
                            <div class="info-box" id="valortotalInfoTour">
                                <span class="info-box-icon text-white" style="background-color:var(--info-box-primary)"><i class="fas fa-dollar-sign"></i></span>

                                <div class="info-box-content">
                                    <span class="info-box-text">Valor Total</span>
                                    <span class="info-box-number" id="txt_val_total">0.00</span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                            <!-- /.info-box -->
                        </div>
                        <div class="col-md-4 col-sm-4 col-12">
                            <div class="info-box" id="valorPagoInfoTour">
                                <span class="info-box-icon text-white" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>

                                <div class="info-box-content">
                                    <span class="info-box-text">Pago</span>
                                    <span class="info-box-number" id="txt_val_pago">0.00</span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                            <!-- /.info-box -->
                        </div>
                        <div class="col-md-4 col-sm-4 col-12">
                            <div class="info-box" id="saldoInfoTour">
                                <span class="info-box-icon text-white" style="background-color:var(--info-box-success)"><i class="fas fa-dollar-sign"></i></span>

                                <div class="info-box-content">
                                    <span class="info-box-text">Saldo</span>
                                    <span class="info-box-number" id="txt_val_saldo">0.00</span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                            <!-- /.info-box -->
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- right col -->
                </div>
                <div class="container-fluid">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp" id="btn-novoPagar"><span class="fas fa-plus"></span> Novo</button>
                            <button type="button" class="btn btn-secondary btn-sisp" id="btnBaixar" data-toggle="modal" data-target=".bd-baixa-modal-xl" title="Selecione alguma Conta a Pagar para baixar" disabled><i class="far fa-arrow-alt-circle-down"></i> Baixar</button>
                            <button class="btn btn-success btn-sisp" id="btnImprimir" title="Selecione alguma AP para imprimir"><i class="fas fa-print"></i> Imprimir</button>
                            <button class="btn btn-primary btn-sisp" id="btnDesdobrarAgrupar" title="Selecione alguma AP para desdobrar/agrupar"><i class="fas fa-wallet"></i> Desdobrar/Agrupar APs</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <table id="tabelaPagar" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th>
                                            <div class="icheck-primary" for="check_todos" id="cbTodos">
                                                <input class="form-check-input" type="checkbox" id="check_todos">
                                                <label for="check_todos" value="option5" data-toggle="tooltip" data-placement="top" title="Selecionar todos os registros"></label>
                                            </div>
                                        </th>
                                        <th>Num AP.</th>
                                        <th>Codcre</th>
                                        <th>Nome</th>
                                        <th>Lançamento</th>
                                        <th>Dupli</th>
                                        <th>Valor</th>
                                        <th>Valor Pago</th>
                                        <th>Saldo</th>
                                        <th>Juros</th>
                                        <th>Multa</th>
                                        <th>Desconto</th>
                                        <th>Emissão</th>
                                        <th>Vencimento</th>
                                        <th>Classe</th>
                                        <th>Banco</th>
                                        <th>Conta</th>
                                        <th>Status</th>
                                        <th>Situação</th>
                                        <th>Obs</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>

                            </table>
                        </div>
                    </div>

                    <!-- Modais  -->

                    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-xl" role="document">
                            <div class="modal-content" id="modalBody">
                                <div class="modal-header">
                                    <h4 class="modal-title">Filtros</h4>
                                    <label style="margin-top: 12px; margin-left: 15px;" for="checkTodasEmpresas"><input type="checkbox" id="checkTodasEmpresas"> Todas Empresas</label>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">

                                    <div class="row">
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-6 col-6">
                                            <div class="group-default">
                                                <label for="dtEmiIni">Emissão De/ Até:</label>
                                                <div class="input-group">
                                                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataDe" name="DataDe">
                                                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataAte" name="DataAte">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-6 col-6">
                                            <div class="group-default">
                                                <label for="txtVenctoDe">Vencimento De/ Até:</label>
                                                <div class="input-group">
                                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtVenctoDe" name="txtVenctoDe">
                                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtVenctoAte" name="txtVenctoAte">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-6 col-6">
                                            <div class="group-default">
                                                <label for="dtBaixaDe">Baixa De/ Até:</label>
                                                <div class="input-group">
                                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="dtBaixaDe" name="dtBaixaDe">
                                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="dtBaixaAte" name="dtBaixaAte">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12">
                                            <div class="group-default">
                                                <label for="numero_ap">Número Ap: </label>
                                                <div class="relative">
                                                    <input type="text" value="" class="input-default focus form-control validate" id="txtNum_ap" name="num_ap">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="FornecedorInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaFornecedor">Fornecedor: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaFornecedor" name="txtConsultaFornecedor" class="form-control" placeholder="Fornecedor"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaFornecedor" name="txtConsultaFornecedor" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaFornecedor" name="btn-ConsultaFornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaFornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="HistoricoInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaHistorico">Histórico: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaHistorico" name="txtConsultaHistorico" class="form-control" placeholder="Histórico"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaHistorico" name="txtConsultaHistorico" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaHistorico" name="btn-ConsultaHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="ClasseGerencialInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaClasseGerencial">Classe Gerencial: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaClasseGerencial" name="txtConsultaClasseGerencial" class="form-control" placeholder="Classe Gerencial"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaClasseGerencial" name="txtConsultaClasseGerencial" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaClasseGerencial" name="btn-ConsultaClasseGerencial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaClasseGerencial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="BancoInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaBanco">Banco: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaBanco" name="txtConsultaBanco" class="form-control" placeholder="Banco"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaBanco" name="txtConsultaBanco" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaBanco" name="btn-ConsultaBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="ContaInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaConta">Conta: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaConta" name="txtConsultaConta" class="form-control" placeholder="Conta"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaConta" name="txtConsultaConta" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaConta" name="btn-ConsultaConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-12 col-12" id="SituacaoInfoTour">
                                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaSituacao">Situação: </label>
                                            <div class="relative" style="margin-top: 5px;">
                                                <div class="input-group">
                                                    <!-- <input type="text" class="input-default focus form-control" id="txtConsultaSituacao" name="txtConsultaSituacao" class="form-control" placeholder="Situacao"> -->
                                                    <select class="js-example-programmatic js-states form-control" id="txtConsultaSituacao" name="txtConsultaSituacao" multiple="multiple"></select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btn-ConsultaSituacao" name="btn-ConsultaSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btn-limpa-ConsultaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-6 col-12">
                                            <div class="group-default form-group">
                                                <label for="Sstatus">Status:</label>
                                                <div class="relative">
                                                    <select id="Status" class="input-default focus form-control validate">
                                                        <option value="" selected>Todos</option>
                                                        <option value="DUPL">A.Ps</option>
                                                        <option value="ANTE">Antecipações</option>
                                                        <option value="ORCA">Orçamentos</option>
                                                        <option value="CHEQ">Cheques</option>
                                                        <option value="CHDE">Cheques Devolvidos</option>
                                                        <option value="CHCA">Cheques Cancelados</option>
                                                        <option value="DESD">Desdobradas</option>
                                                        <option value="AGRU">Agrupadas</option>
                                                        <!-- <option value="PROV" id="3">PROV</option>
                                                        <option value="RASC" id="2">RASC</option> -->
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-2 col-lg-4 col-md-6 col-sm-6 col-12">
                                            <div class="group-default form-group">
                                                <label for="Situacao">Situacão AP's:</label>
                                                <div class="relative">
                                                    <select id="txtSituacao" class="input-default focus form-control validate">
                                                        <option value="">Todos</option>
                                                        <option value="Aberto" selected>Aberto</option>
                                                        <option value="Pagas">Pagas</option>
                                                        <option value="Devolvidas">Devolvidas</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer justify-content-start pl-0 pr-3">
                                        <div class="form-row col-lg-12 col-sm-12">
                                            <div class="col-lg-4 col-sm-12">
                                                <label for="txtOrdem">Opção de Relatório:</label>
                                                <div class="relative">
                                                    <select id="txtOrdem" class="input-default focus custom-select"></select>
                                                </div>
                                            </div>
                                            <div class="col-lg-8 col-sm-12 d-flex justify-content-end align-items-end pr-2">
                                                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>
                                                <button id="btnConsultar" class='btn btn-primary btn-sisp ml-2' type='button'><span class="fas fa-search"></span> Consultar </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="myModal" class="modal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content" id="modalBody">
                                <div class="modal-header">
                                    <h4 id="myModalLabel" class="modal-title">Modal title</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p id="myModalText">Modal body text goes here.</p>
                                </div>
                                <div class="modal-footer">
                                    <button id="btnYes" type="button" class="btn btn-danger btn-sisp" style="width: 100px;">Sim</button>
                                    <button id="btnNo" type="button" class="btn btn-secondary btn-sisp" data-dismiss="modal">Não</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Baixas -->
                    <div class="modal fade bd-baixa-modal-xl" id="modalBaixar" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="BaixaModal">Baixas Pagar</h5>
                                    <button type="button" class="close" id="CloseBaixa" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <button type="button" id="scrollToBottomBtn" class="fa fa-arrow-down" aria-hidden="true"></button>
                                    <div class="container-fluid">
                                        <div class="card">
                                            <div class="card-body">
                                                <form id="msform" name="msform">
                                                    <div class="form-row">
                                                        <div class="col-md-4 col-12 form-group" id="ContaInfoTour">
                                                            <label data-error="wrong" data-success="right" for="txtConta">Conta *</label>
                                                            <div class="input-group">
                                                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                    <button class="btn bg-danger" id="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 col-12 form-group" id="ClasseInfoTour">
                                                            <label data-error="wrong" data-success="right" for="txtClasse">Classe *</label>
                                                            <div class="input-group">
                                                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasse" name="txtClasse" class="form-control" placeholder="Classe">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btn-Classe" name="btn-Classe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                    <button class="btn bg-danger" id="btn-limpa-Classe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 col-12 form-group" id="HistoricoInfoTour">
                                                            <label data-error="wrong" data-success="right" for="txtHistorico">Histórico *</label>
                                                            <div class="input-group">
                                                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                    <button class="btn bg-danger" id="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group group-default col-md-3 col-6">
                                                            <label for="">Data Pagamento</label>
                                                            <div class="relative">
                                                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTPagamento">
                                                            </div>
                                                        </div>
                                                        <div class="form-group group-default col-md-3 col-6">
                                                            <label for="">Data Contabilização</label>
                                                            <div class="relative">
                                                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTContabilizacao">
                                                            </div>
                                                        </div>
                                                        <div class="form-group group-default col-md col-12">
                                                            <label for="">Obs</label>
                                                            <div class="relative">
                                                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtObs" name="txtObs" class="form-control" placeholder="Observação">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12 table-responsive">
                                                        <table id="tabelaBaixarContas" class="table table-sm table-select table-hover" width="100%">
                                                            <thead>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <input id="btn-baixar" type="button" style="font-size:16px; margin-top:10px;" class="btn btn-danger btn-sisp float-right" value="Gravar Baixa">
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Visualizar -->
                    <div class="modal fade bd-visualizar-modal-lg" id="ModalVisualizarBaixa" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="VisualizarModal">Visualizar Duplicata</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="container-fluid">
                                        <div class="card">
                                            <div class="card-body">
                                                <form id="formVisualizar" name="formVisualizar">
                                                    <div class="form-row">
                                                        <div class="col-12" id="FornecedorInfoTour">
                                                            <label data-error="wrong" data-success="right" for="txtFornecedorVisual">Fornecedor</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtFornecedorVisual" name="txtFornecedorVisual" class="form-control" placeholder="Fornecedor" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group group-default col-md-6 col-12" id="NotaFiscalInfoTour">
                                                            <label>Nota Fiscal</label>
                                                            <div class="relative">
                                                                <input type="text" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNotaFiscalVisual" name="numbers" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="form-group group-default col-md-6 col-12">
                                                            <label>Data de Emissão</label>
                                                            <div class="relative" id="DataEmissao">
                                                                <input type="date" max="2500-12-31" class="input-default focus form-control validatel" id="txtDTemissaoVisual" disabled>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group group-default col-md-12 col-12" id="NotaFiscalInfoTour">
                                                            <label>Saldo</label>
                                                            <div class="relative">
                                                                <input type="text" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtSaldoVisual" name="numbers" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="card-body">
                                                <div class="col-sm-12 table-responsive">
                                                    <table id="tabelaBaixar" class="table table-sm table-select table-hover" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th>Numero Ap</th>
                                                                <th>Data Pagamento</th>
                                                                <th>Valor</th>
                                                                <th>Valor Pago</th>
                                                                <th>Juros</th>
                                                                <th>Multa</th>
                                                                <th>Desconto</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </div> <!-- /.content-header -->
        </div><!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php
        include_once('../../../modais.php');
        ?>
        <?php
        include_once('../../../menu_fiscal.php');
        include_once('../../../modals/modal_lancRateio.html');
        include_once('../../../modals/modal_desdobra_pagar.html');
        ?>
    </div><!-- /.wrapper -->

    <!-- ./wrapper -->
    <script src="plugins/jquery/jquery.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/jquery.maskMoney.min.js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2410.21.2"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2410.21.2"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/sisplan.js?versao=3.2410.21.2"></script>
    <script src="utils/funcoes.js?versao=3.2410.21.2"></script>
    <script src="utils/cookies.js?versao=3.2410.21.2"></script>
    <script src="dist/js/requisicoes.js?versao=3.2410.21.2"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/driver.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/datetime.js?versao=3.2410.21.2"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2410.21.2"></script>
    <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2410.21.2"></script>
    <script src="plugins/moment/moment.min.js?versao=3.2410.21.2"></script>
    <script src="dist/js/jquery.inputmask.js?versao=3.2410.21.2"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="modals/modal_lancRateio.js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="modals/modal_desdobra_pagar.js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.2410.21.2"></script>
    <script type="text/javascript" src="config.js?versao=3.2410.21.2"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }
            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');
            let queryString = window.location.href;
            let parametros = queryString.split('/');
            let nomeTela = parametros[parametros.length - 1].toUpperCase();

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;
            sArquivo = `${BASE_URI}/pages/pagar/acesso_pagar/acesso_pagar.js?versao=3.2410.21.2`;

            const temAcesso = await temAcessoTela('PAGAR');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            await insereJavaScriptPagina(sArquivo);

            await verificaPermissoes('PAGAR')
        });
    </script>
</body>

</html>