$(document).ready(async function () {
    var ultimaColunaOrdenada = {
        nome: '',
        ordenacao: 'ASC'
    };

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para Imprimir um relatório.',
                    position: 'right'
                }
            }
            ]);
            driver.start();
        });
    });

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relEstoqueMat == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: novasColunas }))

            $('#tabelaRelEstoqueMat').DataTable().columns().visible(true);

            $('#tabelaRelEstoqueMat').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    await preencheOrdenacaoTela('RelEstoqueMat');

    $('#txtOrdem').val('3');

    // const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

    const filtroDeposito = await buscaDepositoEmpresaUsuario();

    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('depositoUsuario', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('colecao', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('composicaoMaterial', true);
    componenteFiltro('linha', true);

    $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`, 'LOTE', 'CODIGO');
    $('#btnLote').pesquisa_serversideSel('#txtLote', `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO", "COR" ], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

    $('#txtLote').addClass('camposFiltros');
    $('#btnLimpaLote').on('click', function () {
        $('#txtLote').empty().trigger('change')
        $('#txtLote').val('');
        $('#txtLote').attr('data-chave', '');
        $('#txtLote').attr('data-desc', '');
    });

    $('#txtLoteInterno').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO"]}`, 'LOTE_INTERNO', 'CODIGO');
    $('#btnLoteInterno').pesquisa_serversideSel('#txtLoteInterno', `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO", "COR"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO", "COR"]}`, 'Pesquisa Lote');

    $('#txtLoteInterno').addClass('camposFiltros');
    $('#btnLimpaLoteInterno').on('click', function () {
        $('#txtLoteInterno').empty().trigger('change')
        $('#txtLoteInterno').val('');
        $('#txtLoteInterno').attr('data-chave', '');
        $('#txtLoteInterno').attr('data-desc', '');
    });

    $('#txtTonalidade').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'TONALIDADE', 'ATIVO');
    $('#btnTonalidade').pesquisa_serversideSel('#txtTonalidade', `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa de Tonalidade');

    $('#txtTonalidade').addClass('camposFiltros');
    $('#btnLimpaTonalidade').on('click', function () {
        $('#txtTonalidade').empty().trigger('change')
        $('#txtTonalidade').val('');
        $('#txtTonalidade').attr('data-chave', '');
        $('#txtTonalidade').attr('data-desc', '');
    });

    await carregaValoresPadroes();

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABELA = 'ESTOQUE'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'DEPOSITO': {
                    if (item.VALOR != '') {
                        let descricao = await buscaValor('DEPOSITO', 'DESCRICAO', 'CODIGO', item.VALOR);
                        descricao = descricao != undefined ? descricao.DESCRICAO : 'VALOR INVÁLIDO';
                        adicionaValorPadraoVarios('depositoUsuario', item.VALOR, descricao);
                    }
                    break;
                }
                case 'QUALIDADE': {
                    if (item.VALOR != '') {
                        let descricao = await buscaValor('TABQUL', 'DESCRICAO', 'CODIGO', item.VALOR);
                        descricao = descricao != undefined ? descricao.DESCRICAO : 'VALOR INVÁLIDO';
                        adicionaValorPadraoVarios('qualidade', item.VALOR, descricao);
                    }
                    break;
                }
            }
        });
    };

    limparFiltros(true);

    retornaHintRelatorio('btnImprimir', 'estoque_material')

    $('#txtOrdem').on('change', function () {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
            .toArray()
            .map(map => {
                return [map.selected, $(map)
                    .attr('nome_prt')]
            })
            .filter(filter => filter[0] == true)[0][1])
    })

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/estoque?`;

                const item = 'M';

                const filtros = await retornaFiltros();
                const params = `CODIGO=${filtros.codigo}` +
                    `&DEPOSITO=${filtros.deposito}` +
                    `&LOTE=${filtros.lote}` +
                    `&LOTE_INTERNO=${filtros.loteInterno}` +
                    `&TONALIDADE=${filtros.tonalidade}` +
                    `&LINHA=${filtros.linha}` +
                    `&FABRICACAODE=${filtros.fabricacaoDe}` +
                    `&FABRICACAOATE=${filtros.fabricacaoAte}` +
                    `&COR=${filtros.cor}` +
                    `&COLECAO=${filtros.colecao}` +
                    `&GRUPO=${filtros.grupo}` +
                    `&QUALIDADE=${filtros.qualidade}` +
                    `&TIPOITEM=${item}` +
                    `&CONTEMESTOQUE=${$('#cbContemEstoque').prop('checked')}` +
                    `&DIFERENCA_QUANTIDADE=${$('#cbDiferencaQuantidade').prop('checked')}` +
                    `&SUBGRUPO=${filtros.subGrupo}`;
                const ordem = `&TELA_ORDENACAO=RelEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueMat');
                let arquivo = await GeraRelatorio(`${url}${params}${ordem}`, 'GET', 1000000, false, 'RelEstoqueMat');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function retornaFiltros() {

        let dep = await formataListas($('#txtDepositoUsuario').val().toString());

        if (dep == '' && !$("#cbTodosDepositos").prop("checked")) {
            dep = filtroDeposito;
        }

        const filtros = {
            tipoItem: 'MATERIAL',
            tabelaEstoque: 'MAT_ITEN',
            campoQualidade: 'QUALIDADE',
            codigo: await formataListas($('#txtMaterial').val().toString()),
            cor: await formataListas($('#txtCor').val().toString()),
            colecao: await formataListas($('#txtColecao').val().toString()),
            grupo: await formataListas($('#txtGrupoMA').val().toString()),
            subGrupo: await formataListas($('#txtSubGrupo').val().toString()),
            qualidade: await formataListas($('#txtQualidade').val().toString()),
            lote: await formataListas($('#txtLote').val().toString()),
            composicao: await formataListas($('#txtComposicaoMaterial').val().toString()),
            loteInterno: await formataListas($('#txtLoteInterno').val().toString()),
            tonalidade: await formataListas($('#txtTonalidade').val().toString()),
            linha: await formataListas($('#txtLinha').val().toString()),
            fabricacaoDe: $('#dtFabricacaoDe').val(),
            fabricacaoAte: $('#dtFabricacaoAte').val(),
            deposito: dep
        }

        return filtros;
    }

    async function montaPesquisa(colunaOrdenacao = '') {
        try {
            const tipoBanco = await retornaDatabase();
            let fFabricacaoDe = ''
            let fFabricacaoAte = ''

            const filtros = await retornaFiltros();
            const fCodigo = filtros.codigo != '' ? ` AND ${filtros.tabelaEstoque}.CODIGO IN (${filtros.codigo})` : '';
            const fCor = filtros.cor != '' ? ` AND ${filtros.tabelaEstoque}.COR IN (${filtros.cor})` : '';
            const fColecao = filtros.colecao != '' ? ` AND COLECAO.CODIGO IN (${filtros.colecao})` : '';
            const fGrupo = filtros.grupo != '' ? ` AND ${filtros.tipoItem}.GRUPO IN (${filtros.grupo})` : '';
            const fSubGrupo = filtros.subGrupo != '' ? ` AND ${filtros.tipoItem}.SUB_GRUPO IN (${filtros.subGrupo})` : '';
            const fQualidade = filtros.qualidade != '' ? ` AND ${filtros.tabelaEstoque}.QUALIDADE IN (${filtros.qualidade})` : '';
            const fDeposito = filtros.deposito != '' ? ` AND ${filtros.tabelaEstoque}.DEPOSITO IN (${filtros.deposito})` : '';
            const fComposicao = filtros.composicao != '' ? ` AND MATERIAL.COMPOSICAO IN (${filtros.composicao})` : '';
            const fLote = filtros.lote != '' ? ` AND MAT_ITEN.LOTE IN (${filtros.lote})` : '';
            const fLoteInterno = filtros.loteInterno != '' ? ` AND MAT_ITEN.LOTE_INTERNO IN (${filtros.loteInterno})` : '';
            const fTonalidade = filtros.tonalidade != '' ? ` AND MAT_ITEN.TONALIDADE IN (${filtros.tonalidade})` : '';
            const fLinha = filtros.linha != '' ? ` AND MATERIAL.LINHA IN (${filtros.linha})` : '';
            if (tipoBanco == 'ORACLE') {
                fFabricacaoDe = filtros.fabricacaoDe != '' ? ` AND MAT_ITEN.DT_FAB >= TO_TIMESTAMP('${filtros.fabricacaoDe} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
                fFabricacaoAte = filtros.fabricacaoAte != '' ? ` AND MAT_ITEN.DT_FAB <= TO_TIMESTAMP('${filtros.fabricacaoAte} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
            } else {
                fFabricacaoDe = filtros.fabricacaoDe != '' ? ` AND MAT_ITEN.DT_FAB >= '${filtros.fabricacaoDe}'` : '';
                fFabricacaoAte = filtros.fabricacaoAte != '' ? ` AND MAT_ITEN.DT_FAB <= '${filtros.fabricacaoAte}'` : '';
            }

            const ordemOrdenacao = $('#txtOrdem').val();
            let orderBy = colunaOrdenacao == '' ? await retornaOrderBy(ordemOrdenacao) : colunaOrdenacao;
            let somenteEstoque = '';

            somenteEstoque = $('#cbContemEstoque').prop('checked') == true ? ` AND ${filtros.tabelaEstoque}.QTDE > 0 ` : '';
            diferencaQuantidade = $('#cbDiferencaQuantidade').prop('checked') == true ? ` AND ${filtros.tabelaEstoque}.QTDE <> ${filtros.tabelaEstoque}.QTDE_ORIG ` : '';

            let camposSelect = '';
            let cols = [];

            camposSelect = ["MAT_ITEN.ID_MAT_ITEN", "MAT_ITEN.CODIGO", "MATERIAL.DESCRICAO AS DESCRICAO", "MAT_ITEN.COR", "CADCOR.DESCRICAO DESCCOR", "COLECAO.CODIGO CODCOLECAO",
                "COLECAO.DESCRICAO DESCCOLECAO", "MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO DESCDEPOSITO", "MAT_ITEN.LOTE", "MAT_ITEN.LOTE_ORIG", "MAT_ITEN.QTDE AS QUANTIDADE", "MAT_ITEN.QTDE_ORIG", "MAT_ITEN.BARRA", "0 AS TAM", "MATERIAL.UNIDADE", "MATERIAL.SUB_GRUPO",
                "MATERIAL.UNI_AUX", "MATERIAL.RENDIMENTO", "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO DESCQUALIDADE", "MAT_ITEN.TONALIDADE", "MAT_ITEN.DT_FAB"];
            cols = ["ID_MAT_ITEN", "CODIGO", "DESCRICAO", "COR", "DESCCOR", "CODCOLECAO", "DESCCOLECAO", "DEPOSITO", "DESCDEPOSITO", "LOTE", "LOTE_ORIG", "QUANTIDADE", "QTDE_ORIG", "BARRA", "TAM", "UNIDADE", "SUB_GRUPO", "UNI_AUX", "RENDIMENTO", "QUALIDADE", "DESCQUALIDADE", "TONALIDADE", "DT_FABRICACAO"];

            const ligacaoTabelaCor = { "tabela": "CADCOR", "condicao": `CADCOR.COR = ${filtros.tabelaEstoque}.COR` };

            const ligacaoProdutoMaterial = { "tabela": `${filtros.tipoItem}`, "condicao": `${filtros.tipoItem}.CODIGO = ${filtros.tabelaEstoque}.CODIGO` };

            const ligacaoColecao = { "tabela": "COLECAO", "condicao": `COLECAO.CODIGO = ${filtros.tipoItem}.COLECAO` };

            const ligacaoQualidade = { "tabela": "TABQUL", "condicao": `TABQUL.CODIGO = ${filtros.tabelaEstoque}.${filtros.campoQualidade}` };

            const ligacaoDeposito = { "tabela": "DEPOSITO", "condicao": `DEPOSITO.CODIGO = ${filtros.tabelaEstoque}.DEPOSITO` };


            const pesquisa = {
                tabela: filtros.tabelaEstoque,
                camposSelect: camposSelect,
                leftjoin: [ligacaoTabelaCor, ligacaoProdutoMaterial, ligacaoColecao, ligacaoQualidade, ligacaoDeposito],
                where: [`1=1 ${fCodigo} ${fDeposito} ${fCor} ${fColecao} ${fGrupo} ${fQualidade} ${fComposicao} ${somenteEstoque} ${fSubGrupo} ${fLote} ${fLoteInterno} ${fTonalidade} ${fLinha} ${fFabricacaoDe} ${fFabricacaoAte} ${diferencaQuantidade}`],
                orderby: [orderBy]
            }

            return {
                pesquisa: pesquisa,
                colunas: cols
            }
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function buscaDados(colunaOrdenacao = '') {
        if ($.fn.DataTable.isDataTable('#tabelaRelEstoqueMat')) {
            $("#tabelaRelEstoqueMat").DataTable().destroy();
            $("#tabelaRelEstoqueMat").empty();
        }

        ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
        ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

        try {
            try {
                $.LoadingOverlay("show");

                const pesquisa = await montaPesquisa(colunaOrdenacao);
                let dataSetCols = [];

                for (let i = 0; i < pesquisa.colunas.length; i++) {
                    dataSetCols.push({
                        'title': pesquisa.colunas[i],
                        'data': pesquisa.colunas[i]
                    });
                }

                // const ajaxData = {
                //     "EMPRESA": getCookie('empresa'),
                //     "JSON": `{"tabela":"${tabelaEstoque}", 
                //       "camposSelect": ${camposSelect}, 
                //       "leftJoin": [${ligacaoTabelaCor},${ligacaoProdutoMaterial},${ligacaoColecao},${ligacaoQualidade}], 
                //       "where": ["1=1 ${sCodigo} ${sDeposito} ${sCor} ${sColecao} ${sGrupo} ${sQualidade} ${somenteEstoque} ${sSubGrupo}"],
                //       "orderby": ["${orderBy}"]  
                //     }`,
                //     "CLIENTE": 'N',
                // };

                $('#tabelaRelEstoqueMat').DataTable({
                    paging: true,
                    colReorder: true,
                    lengthChange: true, // habilita o select para mudar a quantidade de itens por página
                    lengthMenu: [10, 25, 50, 100], // opções disponíveis no select
                    pageLength: 10,
                    filter: false,
                    info: true,
                    order: true,
                    autoWidth: true,
                    destroy: true,
                    serverSide: true,
                    processing: true,
                    ajax: {
                        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                        type: "POST",
                        headers: {
                            'Authorization': BASIC_AUTH
                        },
                        data: {
                            EMPRESA: getCookie('empresa'),
                            JSON: JSON.stringify(pesquisa.pesquisa),
                            CLIENTE: 'N',
                        },
                        dataSrc: function (data) {
                            const cols = pesquisa.colunas;
                            const array = data.data;
                            return array.map(row => {
                                return row.reduce((obj, value, index) => {
                                    obj[cols[index]] = value;
                                    return obj;
                                }, {});
                            });
                        }
                    },
                    "language": {
                        "sEmptyTable": "Nenhuma consulta realizada",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhuma consulta realizada",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }
                    },
                    columns: dataSetCols,
                    columnDefs: [
                        {
                            "targets": [10],
                            "className": 'pr-4 text-right'
                        }
                    ]
                });

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                $('#tabelaRelEstoqueMat_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaRelEstoqueMat_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/Sisplan/Funcoes/v1/pesquisa?';
                    const pesquisa = await montaPesquisa();
                    await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`, true, null, 'Relatório de Estoque de Material', '#tabelaRelEstoqueMat');
                })


                $('#tabelaRelEstoqueMat').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relEstoqueMat).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })

                $('#tabelaRelEstoqueMat th').on('click', async function () {
                    const nomeColuna = $(this).html();
                    const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
                    const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
                    await buscaDados(nomeColuna + ' ' + ordenacao);
                });

            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados dos itens.');
            }
        } finally {
            $.LoadingOverlay("hide");
            $('#modal-filtros').modal('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaRelEstoqueMat').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relEstoqueMat ?? [])
    })

    $('#btnConsultar').on('click', async function () {
        await buscaDados();
    });

    async function retornaOrderBy(ordem) {
        let resultado;
        const pesquisa = {
            tabela: "ORDEM_TELA",
            camposSelect: ["NOME_ORD_SIST"],
            where: [`NOME_TELA = 'RelEstoqueMat' AND ORDEM = ${ordem}`]
        };
        const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        resultado = json[0].NOME_ORD_SIST;
        return resultado.replaceAll(';', ',')
    }

    $("#cbTodosDepositos").on("change", function () {
        bTodosDepositos = $("#cbTodosDepositos").prop("checked");
        $("#txtDepositoUsuario").empty().trigger("change");
        $("#txtDepositoUsuario").prop("disabled", bTodosDepositos)
        $("#btnDepositoUsuario").prop("disabled", bTodosDepositos)
        $("#btnLimpaDepositoUsuario").prop("disabled", bTodosDepositos)
    })

});
