$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir um relatório.',
                position: 'right'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    /////COLUNAS INVISIVEIS
    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.vendaDetalhada == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhada: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.vendaDetalhadaHistorico == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaHistorico: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.vendaDetalhadaItens == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaItens: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.vendaDetalhadaFiscais == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFiscais: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.vendaDetalhadaFinanceiro == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFinanceiro: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            if (localStorage.getItem('vendas') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhada: novasColunas }))
                $('#tabelaVendas').DataTable().columns().visible(true);
                $('#tabelaVendas').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            } else if (localStorage.getItem('historico') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaHistorico: novasColunas }))
                $('#tabelaHistorico').DataTable().columns().visible(true);
                $('#tabelaHistorico').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            } else if (localStorage.getItem('itens') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaItens: novasColunas }))
                $('#tabelaItens').DataTable().columns().visible(true);
                $('#tabelaItens').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            } else if (localStorage.getItem('fiscais') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFiscais: novasColunas }))
                $('#tabelaFiscais').DataTable().columns().visible(true);
                $('#tabelaFiscais').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            } else if (localStorage.getItem('financeiro') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFinanceiro: novasColunas }))
                $('#tabelaFinanceiro').DataTable().columns().visible(true);
                $('#tabelaFinanceiro').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            }


            $('#modal-ColunasVisiveis').modal('hide');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        if (localStorage.getItem('vendas') == 'true') {
            $('#tabelaVendas').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.vendaDetalhada ?? [], [])
        } else if (localStorage.getItem('historico') == 'true') {
            $('#tabelaHistorico').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaHistorico ?? [], [])
        } else if (localStorage.getItem('itens') == 'true') {
            $('#tabelaItens').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaItens ?? [], [])
        } else if (localStorage.getItem('fiscais') == 'true') {
            $('#tabelaFiscais').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaFiscais ?? [], [])
        } else if (localStorage.getItem('financeiro') == 'true') {
            $('#tabelaFinanceiro').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaFinanceiro ?? [], [])
        }
    })

    $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
        localStorage.removeItem('vendas')
        localStorage.removeItem('historico')
        localStorage.removeItem('itens')
        localStorage.removeItem('fiscais')
        localStorage.removeItem('financeiro')
    })
    /////COLUNAS INVISIVEIS

    addFiltros()

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        await consultaVendas();
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCliente').empty().trigger('change')
        $('#txtVendedor').empty().trigger('change')
        $('#txtCaixa').empty().trigger('change')
        $('#txtTipoVenda').empty().trigger('change')
        $('#txtVenda').empty().trigger('change')
        $('#txtNota').empty().trigger('change')
        $('#txtNotaNfce').empty().trigger('change')
        $('#txtDtIni').val('1200-01-01')
        $('#txtDtFin').val('2500-12-31')
        $('#radioProduto').prop('checked', true)
        $('#cbEmitido').prop('checked', false)
        $('#cbPendente').prop('checked', false)
        $('#cbAgrupada').prop('checked', false)
        $('#cbDevolvido').prop('checked', false)
        $('#cbCancelada').prop('checked', false)
        $('#cbSemNfe').prop('checked', false)
        $('#cbComNfe').prop('checked', false)
        $('#cbSemNfce').prop('checked', false)
        $('#cbComNfce').prop('checked', false)
    });

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    async function retornaFiltros() {
        const item = $('#radioProduto').is(':checked') ? 'P' : 'M';
        const dtIni = $('#txtDtIni').val() == '1200-01-01' ? '' : $('#txtDtIni').val()
        const dtFin = $('#txtDtFin').val() == '2500-12-31' ? '' : $('#txtDtFin').val()
        const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const filtros = `CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&VENDEDOR=${await formataListas($('#txtVendedor').val().toString())}` +
            `&CAIXA=${await formataListas($('#txtCaixa').val().toString())}` +
            `&TIPOVENDA=${await formataListas($('#txtTipoVenda').val().toString())}` +
            `&VENDA=${await formataListas($('#txtVenda').val().toString())}` +
            `&NOTA=${await formataListas($('#txtNota').val().toString())}` +
            `&NOTANFCE=${await formataListas($('#txtNotaNfce').val().toString())}` +
            `&DTINICIO=${dtIni}` +
            `&DTFINAL=${dtFin}` +
            `&ITEM=${item}` +
            `&EMITIDO=${$('#cbEmitido').is(':checked')}` +
            `&PENDENTE=${$('#cbPendente').is(':checked')}` +
            `&AGRUPADA=${$('#cbAgrupada').is(':checked')}` +
            `&DEVOLVIDO=${$('#cbDevolvido').is(':checked')}` +
            `&CANCELADAS=${$('#cbCancelada').is(':checked')}` +
            `&NFE=${$('#cbSemNfe').is(':checked') ? 'S' : $('#cbComNfe').is(':checked') ? 'C' : ''}` +
            `&NFCE=${$('#cbSemNfce').is(':checked') ? 'S' : $('#cbComNfce').is(':checked') ? 'C' : ''}` +
            `&TIPOITEM=${$('#radioProduto').is(':checked') ? 'P' : 'M'}` +
            `&EMP_ID=${listaEmpIds}`

        return filtros
    }

    async function consultaVendas() {
        if ($.fn.DataTable.isDataTable('#tabelaVendas')) {
            $('#tabelaVendas').DataTable().destroy();
            $('#tabelaVendas').empty();
        }
        limpaTabelasAuxiliares()
        $.LoadingOverlay("show");
        try {
            const url = "/sisplan/impressao/v1/buscavendadetalhada?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, filtros, "", 36000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            const keys = Object.keys(jsonStr[0]);
            let dataSetCols = [];

            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k].toUpperCase(),
                    'data': keys[k]
                });
            };

            $('#tabelaVendas').DataTable({
                destroy: true,
                lengthChange: true,
                serverside: true,
                search: false,
                filter: false,
                pageLength: 5,
                lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
                colReorder: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                autoWidth: true,
                columns: dataSetCols,
                data: jsonStr,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat(
                                    "pt-BR",
                                    {
                                        year: "numeric",
                                        month: "2-digit",
                                        day: "2-digit",
                                        hour: "numeric",
                                        minute: "numeric",
                                        second: "numeric"
                                    })
                                    .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                                    .replace(",", "");
                            } else {
                                return ''
                            }
                        },
                        targets: [7],
                    },
                    {
                        render: function (data) {
                            if (data) {
                                return parseFloat(data).toLocaleString("pt-br", {
                                    maximumFractionDigits: 2,
                                    minimumFractionDigits: 2,
                                });
                            } else {
                                return ''
                            }
                        },
                        targets: [10],
                    },
                    {
                        targets: 11,
                        className: 'pr-4 text-right'
                    }
                ]
            });

            $('#tabelaVendas_length').prepend('<button class="buttonColVis" id="buttonColVisVenda"><i class="fas fa-cogs"></i></button>');
            $('#tabelaVendas_length').prepend('<button class="buttonExcel" id="buttonExcelVenda"><i class="fas fa-file-excel"></i></button>');

            $('#buttonExcelVenda').on('click', async function () {
                let dados = $("#tabelaVendas").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda', '#tabelaVendas', '', 999, false, false, dados);
            })

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#buttonColVisVenda').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    localStorage.setItem('vendas', 'true')
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $('#tabelaVendas').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.vendaDetalhada).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#tabelaVendas').on('click', 'tr', async function () {
        $.LoadingOverlay('show')
        try {
            let codven = 0;

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaVendas').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                codven = $('#tabelaVendas').DataTable().row($(this)).data().CODVEN
            }

            if (codven > 0) {
                await atualizaTabelas(codven, $('#radioProduto').is(':checked') ? 'P' : 'M')
            } else {
                limpaTabelasAuxiliares()
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function atualizaTabelas(codven, tipo) {
        limpaTabelasAuxiliares()
        $.LoadingOverlay('show')
        try {
            const url = "/sisplan/impressao/v1/buscavendadetalhada?";
            const response = await requisicao("POST", url, `TIPOITEM=${tipo}&CODVEN=${codven}`, "", 480000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr[0].length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            const tbItens = jsonStr[0]
            const tbFiscais = jsonStr[1]
            const tbFinanceiro = jsonStr[2]
            const tbHistorico = jsonStr[3]
            if (tbFiscais.length > 0) {
                await montaDataTableFiscais(tbFiscais)
            }
            if (tbItens.length > 0) {
                await montaDataTableItens(tbItens)
            }
            if (tbFinanceiro.length > 0) {
                await montaDataTableFinanceiro(tbFinanceiro)
            }
            if (tbHistorico.length > 0) {
                await montaDataTableHistorico(tbHistorico)
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTableFiscais(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaFiscais').DataTable({
            destroy: true,
            lengthChange: true,
            serverside: true,
            search: false,
            filter: false,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            colReorder: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat(
                                "pt-BR")
                                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                                .replace(",", "");
                        } else {
                            return ''
                        }
                    },
                    targets: [3],
                },
                {
                    render: function (data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [8, 9, 10],
                },
            ]
        });

        $('#tabelaFiscais_length').prepend('<button class="buttonColVis" id="buttonColVisFiscais"><i class="fas fa-cogs"></i></button>');
        $('#tabelaFiscais_length').prepend('<button class="buttonExcel" id="buttonExcelFiscais"><i class="fas fa-file-excel"></i></button>');

        $('#buttonExcelFiscais').on('click', async function () {
            let dados = $("#tabelaFiscais").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Documentos Fiscais', '#tabelaFiscais', '', 999, false, false, dados);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisFiscais').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                localStorage.setItem('fiscais', 'true')
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaFiscais').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.vendaDetalhadaFiscais).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })
    }

    async function montaDataTableItens(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaItens').DataTable({
            destroy: true,
            lengthChange: true,
            serverside: true,
            search: false,
            filter: false,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            colReorder: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    render: function (data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [13, 14, 15, 16],
                },
                {
                    targets: 12,
                    className: 'pr-4 text-right'
                }
            ]
        });

        $('#tabelaItens_length').prepend('<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>');
        $('#tabelaItens_length').prepend('<button class="buttonExcel" id="buttonExcelItens"><i class="fas fa-file-excel"></i></button>');

        $('#buttonExcelItens').on('click', async function () {
            let dados = $("#tabelaItens").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Itens', '#tabelaItens', '', 999, false, false, dados);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisItens').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                localStorage.setItem('itens', 'true')
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaItens').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.vendaDetalhadaItens).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })
    }

    async function montaDataTableFinanceiro(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaFinanceiro').DataTable({
            destroy: true,
            lengthChange: true,
            serverside: true,
            search: false,
            filter: false,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            colReorder: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat(
                                "pt-BR")
                                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                                .replace(",", "");
                        } else {
                            return ''
                        }
                    },
                    targets: [2, 3],
                },
                {
                    render: function (data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [4, 5, 6, 7],
                },
            ]
        });

        $('#tabelaFinanceiro_length').prepend('<button class="buttonColVis" id="buttonColVisFinanceiro"><i class="fas fa-cogs"></i></button>');
        $('#tabelaFinanceiro_length').prepend('<button class="buttonExcel" id="buttonExcelFinanceiro"><i class="fas fa-file-excel"></i></button>');

        $('#buttonExcelFinanceiro').on('click', async function () {
            let dados = $("#tabelaFinanceiro").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Financeiro', '#tabelaFinanceiro', '', 999, false, false, dados);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisFinanceiro').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                localStorage.setItem('financeiro', 'true')
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaFinanceiro').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.vendaDetalhadaFinanceiro).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })
    }

    async function montaDataTableHistorico(jsonStr) {
        const dataSetCols = []
        const keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaHistorico').DataTable({
            destroy: true,
            lengthChange: true,
            serverside: true,
            search: false,
            filter: false,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            colReorder: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat(
                                "pt-BR",
                                {
                                    year: "numeric",
                                    month: "2-digit",
                                    day: "2-digit",
                                    hour: "numeric",
                                    minute: "numeric",
                                    second: "numeric"
                                })
                                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                                .replace(",", "");
                        } else {
                            return ''
                        }
                    },
                    targets: [2],
                },
                {
                    targets: [1],
                    render(data) {
                        if (data) {
                            switch (data) {
                                case 'R':
                                    return 'REJEITADA'
                                    break;
                                case 'L':
                                    return 'LIBERADA'
                                    break;
                                default:
                                    return 'OUTRO'
                                    break;
                            }
                        } else {
                            return 'PENDENTE'
                        }
                    }
                }
            ]
        });

        $('#tabelaHistorico_length').prepend('<button class="buttonColVis" id="buttonColVisHistorico"><i class="fas fa-cogs"></i></button>');
        $('#tabelaHistorico_length').prepend('<button class="buttonExcel" id="buttonExcelHistorico"><i class="fas fa-file-excel"></i></button>');

        $('#buttonExcelHistorico').on('click', async function () {
            let dados = $("#tabelaHistorico").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Historico', '#tabelaHistorico', '', 999, false, false, dados);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisHistorico').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                localStorage.setItem('historico', 'true')
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaHistorico').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.vendaDetalhadaHistorico).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })
    }

    function limpaTabelasAuxiliares() {
        if ($.fn.DataTable.isDataTable('#tabelaFiscais')) {
            $('#tabelaFiscais').DataTable().destroy();
            $('#tabelaFiscais').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaItens')) {
            $('#tabelaItens').DataTable().destroy();
            $('#tabelaItens').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaFinanceiro')) {
            $('#tabelaFinanceiro').DataTable().destroy();
            $('#tabelaFinanceiro').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaHistorico')) {
            $('#tabelaHistorico').DataTable().destroy();
            $('#tabelaHistorico').empty();
        }
    }

    preencheOrdenacaoTela('VendaDetalhada');

    retornaHintRelatorio('btnImprimir', 'RelVendaDetalhada')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimirvendadetalhada?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelVendaDetalhada&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('VendaDetalhada');
                const arquivo = await GeraRelatorio(`${url}${ordem}&`, 'POST', 100000, false, 'VendaDetalhada', filtros);
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function addFiltros() {
        componenteFiltro('cliente', true, true)
        componenteFiltro('vendedor', true, true)
        componenteFiltro('caixa', true, true)
        componenteFiltro('tipoVenda', true, true)
        componenteFiltro('venda', true, true)
        componenteFiltro('nota', true, true)
        componenteFiltro('notaNfce', true, true)

        $('#cbSemNfe').on('click', function () {
            $('#cbComNfe').prop('checked', false)
        })
        $('#cbComNfe').on('click', function () {
            $('#cbSemNfe').prop('checked', false)
        })
        $('#cbSemNfce').on('click', function () {
            $('#cbComNfce').prop('checked', false)
        })
        $('#cbComNfce').on('click', function () {
            $('#cbSemNfce').prop('checked', false)
        })
    }
});