// eslint-disable-next-line no-unused-vars
async function carregaParametrosLogin() {
  const empId = getCookie("emp_id");
  if (!empId) {
    window.location.href = `${BASE_URI}/login`;
    return '';
  }
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "loja_param",
    camposSelect: ["tipo", "posicao", "valor"],
    where: [`emp_id = ${empId}`],
    orderBy: ['tipo', 'posicao']
  };
  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }

  const jsonStr = await response.json();

  const acessosEmpresa = jsonStr.RESULT[0];
  sessionStorage.setItem('web@parametros', JSON.stringify(acessosEmpresa));

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }
}

// eslint-disable-next-line no-unused-vars
async function carregaEmpValorLogin() {
  const empId = getCookie("emp_id");
  if (!empId) {
    window.location.href = `${BASE_URI}/login`;
    return '';
  }
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "EMP_VALOR",
    camposSelect: ["TABELA", "VALOR"],
    where: [`EMP_ID = ${empId}`]
  };


//   const response = await requisicao(
//     "GET",
//     url,
//     `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID", "VALOR"], "where": ["TABELA = '${tabela}' AND EMP_ID=${getCookie(
//         "emp_id"
//     )}"]}`
// );

  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }

  const jsonStr = await response.json();

  const dados = jsonStr.RESULT[0];
  sessionStorage.setItem('web@empValor', JSON.stringify(dados));

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }
}

async function acessoRetaguardaSupervisor(){
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "ACESSO_LOJAWEB",
    camposSelect: ["ACESSO_LOJAWEB.CODIGO"],
    leftjoin: [{tabela: 'ACESSO_USUARIOS', condicao: 'ACESSO_USUARIOS.CODIGO = ACESSO_LOJAWEB.CODIGO'}],
    where: [`ACESSO_LOJAWEB.NOME_TELA = 'RETAGUARDASUPERVISOR'
              AND ACESSO_LOJAWEB.CONSULTA = 'S'
              AND ACESSO_LOJAWEB.ALTERA = 'S'
              AND ((ACESSO_USUARIOS.TIPO = '1') OR (ACESSO_USUARIOS.TIPO = '2'))`]
  };
  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Ocorreu um erro ao realizar pesquisa.");
  }

  const jsonStr = await response.json();

  const acessosEmpresa = jsonStr.RESULT[0];
  if (acessosEmpresa.length <= 0){
    sessionStorage.setItem('acessoretaguardasupervisor', 'N');
  } else {
    sessionStorage.setItem('acessoretaguardasupervisor', 'S');
  }

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Ocorreu um erro ao realizar pesquisa");
  }
}